/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.RedisClientEntry;
import org.redisson.core.Node;
import org.redisson.core.NodesGroup;

public class RedisNodes<N extends Node>
implements NodesGroup<N> {
    private final ConnectionManager connectionManager;

    public RedisNodes(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public Collection<N> getNodes() {
        return this.connectionManager.getClients();
    }

    @Override
    public boolean pingAll() {
        ArrayList<RedisClientEntry> clients = new ArrayList<RedisClientEntry>(this.connectionManager.getClients());
        final HashMap result = new HashMap(clients.size());
        final CountDownLatch latch = new CountDownLatch(clients.size());
        for (RedisClientEntry entry : clients) {
            Future<RedisConnection> f = entry.getClient().connectAsync();
            f.addListener((GenericFutureListener)new FutureListener<RedisConnection>(){

                public void operationComplete(Future<RedisConnection> future) throws Exception {
                    if (future.isSuccess()) {
                        RedisConnection c = (RedisConnection)future.getNow();
                        Future r = ((RedisConnection)future.getNow()).async(RedisCommands.PING, new Object[0]);
                        result.put(c, r);
                    }
                    latch.countDown();
                }
            });
        }
        long time = System.currentTimeMillis();
        try {
            latch.await(this.connectionManager.getConfig().getPingTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (System.currentTimeMillis() - time >= (long)this.connectionManager.getConfig().getPingTimeout()) {
            for (Map.Entry entry : result.entrySet()) {
                ((RedisConnection)entry.getKey()).closeAsync();
            }
            return false;
        }
        boolean res = true;
        for (Map.Entry entry : result.entrySet()) {
            Future f = (Future)entry.getValue();
            long timeout = Math.max((long)this.connectionManager.getConfig().getPingTimeout() - (System.currentTimeMillis() - time), 0L);
            f.awaitUninterruptibly(timeout, TimeUnit.MILLISECONDS);
            if (!"PONG".equals(f.getNow())) {
                res = false;
            }
            ((RedisConnection)entry.getKey()).closeAsync();
        }
        return res && result.size() == clients.size();
    }
}

