/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.redisson.BaseMasterSlaveServersConfig;
import org.redisson.misc.URIBuilder;

public class MasterSlaveServersConfig
extends BaseMasterSlaveServersConfig<MasterSlaveServersConfig> {
    private List<URI> slaveAddresses = new ArrayList<URI>();
    private URI masterAddress;

    public MasterSlaveServersConfig() {
    }

    MasterSlaveServersConfig(MasterSlaveServersConfig config) {
        super(config);
        this.setLoadBalancer(config.getLoadBalancer());
        this.setMasterAddress(config.getMasterAddress());
        this.setSlaveAddresses(config.getSlaveAddresses());
    }

    public MasterSlaveServersConfig setMasterAddress(String masterAddress) {
        this.masterAddress = URIBuilder.create(masterAddress);
        return this;
    }

    public URI getMasterAddress() {
        return this.masterAddress;
    }

    public void setMasterAddress(URI masterAddress) {
        this.masterAddress = masterAddress;
    }

    public MasterSlaveServersConfig addSlaveAddress(String ... sAddresses) {
        for (String address : sAddresses) {
            this.slaveAddresses.add(URIBuilder.create(address));
        }
        return this;
    }

    public List<URI> getSlaveAddresses() {
        return this.slaveAddresses;
    }

    void setSlaveAddresses(List<URI> readAddresses) {
        this.slaveAddresses = readAddresses;
    }
}

