/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import org.redisson.ClusterServersConfig;
import org.redisson.MasterSlaveServersConfig;
import org.redisson.SentinelServersConfig;
import org.redisson.SingleServerConfig;
import org.redisson.client.codec.Codec;
import org.redisson.codec.JsonJacksonCodec;

public class Config {
    private SentinelServersConfig sentinelServersConfig;
    private MasterSlaveServersConfig masterSlaveServersConfig;
    private SingleServerConfig singleServerConfig;
    private ClusterServersConfig clusterServersConfig;
    private int threads = 0;
    private Codec codec;
    private boolean useLinuxNativeEpoll;

    public Config() {
    }

    Config(Config oldConf) {
        this.setUseLinuxNativeEpoll(oldConf.isUseLinuxNativeEpoll());
        if (oldConf.getCodec() == null) {
            oldConf.setCodec(new JsonJacksonCodec());
        }
        this.setThreads(oldConf.getThreads());
        this.setCodec(oldConf.getCodec());
        if (oldConf.getSingleServerConfig() != null) {
            this.setSingleServerConfig(new SingleServerConfig(oldConf.getSingleServerConfig()));
        }
        if (oldConf.getMasterSlaveServersConfig() != null) {
            this.setMasterSlaveServersConfig(new MasterSlaveServersConfig(oldConf.getMasterSlaveServersConfig()));
        }
        if (oldConf.getSentinelServersConfig() != null) {
            this.setSentinelServersConfig(new SentinelServersConfig(oldConf.getSentinelServersConfig()));
        }
        if (oldConf.getClusterServersConfig() != null) {
            this.setClusterServersConfig(new ClusterServersConfig(oldConf.getClusterServersConfig()));
        }
    }

    public Config setCodec(Codec codec) {
        this.codec = codec;
        return this;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public ClusterServersConfig useClusterServers() {
        this.checkMasterSlaveServersConfig();
        this.checkSentinelServersConfig();
        this.checkSingleServerConfig();
        if (this.clusterServersConfig == null) {
            this.clusterServersConfig = new ClusterServersConfig();
        }
        return this.clusterServersConfig;
    }

    ClusterServersConfig getClusterServersConfig() {
        return this.clusterServersConfig;
    }

    void setClusterServersConfig(ClusterServersConfig clusterServersConfig) {
        this.clusterServersConfig = clusterServersConfig;
    }

    public SingleServerConfig useSingleServer() {
        this.checkClusterServersConfig();
        this.checkMasterSlaveServersConfig();
        this.checkSentinelServersConfig();
        if (this.singleServerConfig == null) {
            this.singleServerConfig = new SingleServerConfig();
        }
        return this.singleServerConfig;
    }

    SingleServerConfig getSingleServerConfig() {
        return this.singleServerConfig;
    }

    void setSingleServerConfig(SingleServerConfig singleConnectionConfig) {
        this.singleServerConfig = singleConnectionConfig;
    }

    public SentinelServersConfig useSentinelConnection() {
        this.checkClusterServersConfig();
        this.checkSingleServerConfig();
        this.checkMasterSlaveServersConfig();
        if (this.sentinelServersConfig == null) {
            this.sentinelServersConfig = new SentinelServersConfig();
        }
        return this.sentinelServersConfig;
    }

    SentinelServersConfig getSentinelServersConfig() {
        return this.sentinelServersConfig;
    }

    void setSentinelServersConfig(SentinelServersConfig sentinelConnectionConfig) {
        this.sentinelServersConfig = sentinelConnectionConfig;
    }

    public MasterSlaveServersConfig useMasterSlaveConnection() {
        this.checkClusterServersConfig();
        this.checkSingleServerConfig();
        this.checkSentinelServersConfig();
        if (this.masterSlaveServersConfig == null) {
            this.masterSlaveServersConfig = new MasterSlaveServersConfig();
        }
        return this.masterSlaveServersConfig;
    }

    MasterSlaveServersConfig getMasterSlaveServersConfig() {
        return this.masterSlaveServersConfig;
    }

    void setMasterSlaveServersConfig(MasterSlaveServersConfig masterSlaveConnectionConfig) {
        this.masterSlaveServersConfig = masterSlaveConnectionConfig;
    }

    public boolean isClusterConfig() {
        return this.clusterServersConfig != null;
    }

    public int getThreads() {
        return this.threads;
    }

    public Config setThreads(int threads) {
        this.threads = threads;
        return this;
    }

    private void checkClusterServersConfig() {
        if (this.clusterServersConfig != null) {
            throw new IllegalStateException("cluster servers config already used!");
        }
    }

    private void checkSentinelServersConfig() {
        if (this.sentinelServersConfig != null) {
            throw new IllegalStateException("sentinel servers config already used!");
        }
    }

    private void checkMasterSlaveServersConfig() {
        if (this.masterSlaveServersConfig != null) {
            throw new IllegalStateException("master/slave servers already used!");
        }
    }

    private void checkSingleServerConfig() {
        if (this.singleServerConfig != null) {
            throw new IllegalStateException("single server config already used!");
        }
    }

    public Config setUseLinuxNativeEpoll(boolean useLinuxNativeEpoll) {
        this.useLinuxNativeEpoll = useLinuxNativeEpoll;
        return this;
    }

    public boolean isUseLinuxNativeEpoll() {
        return this.useLinuxNativeEpoll;
    }
}

