/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.CommandExecutor;
import org.redisson.RedisClientResult;
import org.redisson.SlotCallback;
import org.redisson.SyncOperation;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.connection.ConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandExecutorService
implements CommandExecutor {
    final Logger log = LoggerFactory.getLogger(this.getClass());
    final ConnectionManager connectionManager;

    public CommandExecutorService(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public <T, R> Future<Collection<R>> readAllAsync(RedisCommand<T> command, Object ... params) {
        final Promise mainPromise = this.connectionManager.newPromise();
        DefaultPromise promise = new DefaultPromise<R>(){
            Queue<R> results = new ConcurrentLinkedQueue();
            AtomicInteger counter;
            {
                this.counter = new AtomicInteger(CommandExecutorService.this.connectionManager.getEntries().keySet().size());
            }

            public Promise<R> setSuccess(R result) {
                if (result instanceof Collection) {
                    this.results.addAll((Collection)result);
                } else {
                    this.results.add(result);
                }
                if (this.counter.decrementAndGet() == 0 && !mainPromise.isDone()) {
                    mainPromise.setSuccess(this.results);
                }
                return this;
            }

            public Promise<R> setFailure(Throwable cause) {
                mainPromise.setFailure(cause);
                return this;
            }
        };
        for (Integer slot : this.connectionManager.getEntries().keySet()) {
            this.async(true, slot, null, this.connectionManager.getCodec(), (RedisCommand)command, params, (Promise<R>)promise, null, 0);
        }
        return mainPromise;
    }

    @Override
    public <T, R> Future<R> readRandomAsync(RedisCommand<T> command, Object ... params) {
        Promise mainPromise = this.connectionManager.newPromise();
        ArrayList<Integer> slots = new ArrayList<Integer>(this.connectionManager.getEntries().keySet());
        Collections.shuffle(slots);
        this.retryReadRandomAsync(command, mainPromise, slots, params);
        return mainPromise;
    }

    private <R, T> void retryReadRandomAsync(final RedisCommand<T> command, final Promise<R> mainPromise, final List<Integer> slots, final Object ... params) {
        Promise attemptPromise = this.connectionManager.newPromise();
        attemptPromise.addListener((GenericFutureListener)new FutureListener<R>(){

            public void operationComplete(Future<R> future) throws Exception {
                if (future.isSuccess()) {
                    if (future.getNow() == null) {
                        if (slots.isEmpty()) {
                            mainPromise.setSuccess(null);
                        } else {
                            CommandExecutorService.this.retryReadRandomAsync(command, mainPromise, slots, params);
                        }
                    } else {
                        mainPromise.setSuccess(future.getNow());
                    }
                } else {
                    mainPromise.setFailure(future.cause());
                }
            }
        });
        Integer slot = slots.remove(0);
        this.async(true, slot, null, this.connectionManager.getCodec(), command, params, attemptPromise, null, 0);
    }

    @Override
    public <T> Future<Void> writeAllAsync(RedisCommand<T> command, Object ... params) {
        return this.writeAllAsync(command, null, params);
    }

    @Override
    public <R, T> Future<R> writeAllAsync(RedisCommand<T> command, SlotCallback<T, R> callback, Object ... params) {
        return this.allAsync(false, command, callback, params);
    }

    public <T, R> Future<R> allAsync(boolean readOnlyMode, RedisCommand<T> command, final SlotCallback<T, R> callback, Object ... params) {
        final Promise mainPromise = this.connectionManager.newPromise();
        DefaultPromise promise = new DefaultPromise<T>(){
            AtomicInteger counter;
            {
                this.counter = new AtomicInteger(CommandExecutorService.this.connectionManager.getEntries().keySet().size());
            }

            public Promise<T> setSuccess(T result) {
                if (callback != null) {
                    callback.onSlotResult(result);
                }
                if (this.counter.decrementAndGet() == 0) {
                    if (callback != null) {
                        mainPromise.setSuccess(callback.onFinish());
                    } else {
                        mainPromise.setSuccess(null);
                    }
                }
                return this;
            }

            public Promise<T> setFailure(Throwable cause) {
                mainPromise.setFailure(cause);
                return this;
            }
        };
        for (Integer slot : this.connectionManager.getEntries().keySet()) {
            this.async(readOnlyMode, slot, null, this.connectionManager.getCodec(), (RedisCommand)command, params, (Promise<R>)promise, null, 0);
        }
        return mainPromise;
    }

    @Override
    public <V> V get(Future<V> future) {
        future.awaitUninterruptibly();
        if (future.isSuccess()) {
            return (V)future.getNow();
        }
        throw future.cause() instanceof RedisException ? (RedisException)future.cause() : new RedisException("Unexpected exception while processing command", future.cause());
    }

    @Override
    public <T, R> R read(String key, RedisCommand<T> command, Object ... params) {
        return this.read(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> R read(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        Future<R> res = this.readAsync(key, codec, command, params);
        return this.get(res);
    }

    @Override
    public <T, R> R read(RedisClient client, String key, RedisCommand<T> command, Object ... params) {
        Future<R> res = this.readAsync(client, key, this.connectionManager.getCodec(), command, params);
        return this.get(res);
    }

    public <T, R> Future<R> readAsync(RedisClient client, String key, Codec codec, RedisCommand<T> command, Object ... params) {
        Promise mainPromise = this.connectionManager.newPromise();
        int slot = this.connectionManager.calcSlot(key);
        this.async(true, slot, null, codec, command, params, mainPromise, client, 0);
        return mainPromise;
    }

    @Override
    public <T, R> Future<R> readAsync(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        Promise mainPromise = this.connectionManager.newPromise();
        int slot = this.connectionManager.calcSlot(key);
        this.async(true, slot, null, codec, command, params, mainPromise, null, 0);
        return mainPromise;
    }

    @Override
    public <T, R> R write(Integer slot, Codec codec, RedisCommand<T> command, Object ... params) {
        Future<R> res = this.writeAsync(slot, codec, command, params);
        return this.get(res);
    }

    public <T, R> Future<R> writeAsync(Integer slot, Codec codec, RedisCommand<T> command, Object ... params) {
        Promise mainPromise = this.connectionManager.newPromise();
        this.async(false, slot, null, codec, command, params, mainPromise, null, 0);
        return mainPromise;
    }

    @Override
    public <T, R> Future<R> readAsync(String key, RedisCommand<T> command, Object ... params) {
        return this.readAsync(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <R> R write(String key, SyncOperation<R> operation) {
        int slot = this.connectionManager.calcSlot(key);
        return this.async(false, slot, operation, 0);
    }

    @Override
    public <R> R read(String key, SyncOperation<R> operation) {
        int slot = this.connectionManager.calcSlot(key);
        return this.async(true, slot, operation, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R async(boolean readOnlyMode, int slot, SyncOperation<R> operation, int attempt) {
        if (!this.connectionManager.getShutdownLatch().acquire()) {
            return null;
        }
        try {
            RedisConnection connection = readOnlyMode ? this.connectionManager.connectionReadOp(slot) : this.connectionManager.connectionWriteOp(slot);
            try {
                R r = operation.execute(this.connectionManager.getCodec(), connection);
                return r;
            }
            catch (RedisMovedException e) {
                R r = this.async(readOnlyMode, e.getSlot(), operation, attempt);
                return r;
            }
            catch (RedisTimeoutException e) {
                if (attempt == this.connectionManager.getConfig().getRetryAttempts()) {
                    throw e;
                }
                R r = this.async(readOnlyMode, slot, operation, ++attempt);
                return r;
            }
            finally {
                this.connectionManager.getShutdownLatch().release();
                if (readOnlyMode) {
                    this.connectionManager.releaseRead(slot, connection);
                } else {
                    this.connectionManager.releaseWrite(slot, connection);
                }
            }
        }
        catch (RedisException e) {
            if (attempt == this.connectionManager.getConfig().getRetryAttempts()) {
                throw e;
            }
            try {
                Thread.sleep(this.connectionManager.getConfig().getRetryInterval());
                return this.async(readOnlyMode, slot, operation, ++attempt);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
            return this.async(readOnlyMode, slot, operation, ++attempt);
        }
    }

    @Override
    public <T, R> Future<R> evalReadAsync(String key, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(true, key, this.connectionManager.getCodec(), evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> Future<R> evalReadAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(true, key, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> R evalRead(String key, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalRead(key, this.connectionManager.getCodec(), evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> R evalRead(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        Future<R> res = this.evalReadAsync(key, codec, evalCommandType, script, keys, params);
        return this.get(res);
    }

    @Override
    public <T, R> Future<R> evalWriteAsync(String key, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(false, key, this.connectionManager.getCodec(), evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> Future<R> evalWriteAsync(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalAsync(false, key, codec, evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> Future<R> evalWriteAllAsync(RedisCommand<T> command, SlotCallback<T, R> callback, String script, List<Object> keys, Object ... params) {
        return this.evalAllAsync(false, command, callback, script, keys, params);
    }

    public <T, R> Future<R> evalAllAsync(boolean readOnlyMode, RedisCommand<T> command, final SlotCallback<T, R> callback, String script, List<Object> keys, Object ... params) {
        final Promise mainPromise = this.connectionManager.newPromise();
        DefaultPromise promise = new DefaultPromise<T>(){
            AtomicInteger counter;
            {
                this.counter = new AtomicInteger(CommandExecutorService.this.connectionManager.getEntries().keySet().size());
            }

            public Promise<T> setSuccess(T result) {
                callback.onSlotResult(result);
                if (this.counter.decrementAndGet() == 0 && !mainPromise.isDone()) {
                    mainPromise.setSuccess(callback.onFinish());
                }
                return this;
            }

            public Promise<T> setFailure(Throwable cause) {
                mainPromise.setFailure(cause);
                return this;
            }
        };
        ArrayList<Object> args = new ArrayList<Object>(2 + keys.size() + params.length);
        args.add(script);
        args.add(keys.size());
        args.addAll(keys);
        args.addAll(Arrays.asList(params));
        for (Integer slot : this.connectionManager.getEntries().keySet()) {
            this.async(readOnlyMode, slot, null, this.connectionManager.getCodec(), (RedisCommand)command, args.toArray(), (Promise<R>)promise, null, 0);
        }
        return mainPromise;
    }

    private <T, R> Future<R> evalAsync(boolean readOnlyMode, String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        Promise mainPromise = this.connectionManager.newPromise();
        ArrayList<Object> args = new ArrayList<Object>(2 + keys.size() + params.length);
        args.add(script);
        args.add(keys.size());
        args.addAll(keys);
        args.addAll(Arrays.asList(params));
        int slot = this.connectionManager.calcSlot(key);
        this.async(readOnlyMode, slot, null, codec, evalCommandType, args.toArray(), mainPromise, null, 0);
        return mainPromise;
    }

    @Override
    public <T, R> R evalWrite(String key, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        return this.evalWrite(key, this.connectionManager.getCodec(), evalCommandType, script, keys, params);
    }

    @Override
    public <T, R> R evalWrite(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        Future<R> res = this.evalWriteAsync(key, codec, evalCommandType, script, keys, params);
        return this.get(res);
    }

    @Override
    public <T, R> R write(String key, RedisCommand<T> command, Object ... params) {
        Future<R> res = this.writeAsync(key, command, params);
        return this.get(res);
    }

    @Override
    public <T, R> Future<R> writeAsync(String key, RedisCommand<T> command, Object ... params) {
        return this.writeAsync(key, this.connectionManager.getCodec(), command, params);
    }

    @Override
    public <T, R> R write(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        Future<R> res = this.writeAsync(key, codec, command, params);
        return this.get(res);
    }

    @Override
    public <T, R> Future<R> writeAsync(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        Promise mainPromise = this.connectionManager.newPromise();
        int slot = this.connectionManager.calcSlot(key);
        this.async(false, slot, null, codec, command, params, mainPromise, null, 0);
        return mainPromise;
    }

    protected <V, R> void async(final boolean readOnlyMode, final int slot, final MultiDecoder<Object> messageDecoder, final Codec codec, final RedisCommand<V> command, final Object[] params, final Promise<R> mainPromise, final RedisClient client, final int attempt) {
        if (!this.connectionManager.getShutdownLatch().acquire()) {
            mainPromise.setFailure((Throwable)new IllegalStateException("Redisson is shutdown"));
            return;
        }
        final Promise attemptPromise = this.connectionManager.newPromise();
        final AtomicReference<RedisException> ex = new AtomicReference<RedisException>();
        final TimerTask retryTimerTask = new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (attemptPromise.isDone()) {
                    return;
                }
                if (attempt == CommandExecutorService.this.connectionManager.getConfig().getRetryAttempts()) {
                    attemptPromise.setFailure((Throwable)ex.get());
                    return;
                }
                if (!attemptPromise.cancel(false)) {
                    return;
                }
                int count = attempt + 1;
                CommandExecutorService.this.async(readOnlyMode, slot, messageDecoder, codec, command, params, mainPromise, client, count);
            }
        };
        try {
            RedisConnection connection = readOnlyMode ? (client != null ? this.connectionManager.connectionReadOp(slot, client) : this.connectionManager.connectionReadOp(slot)) : this.connectionManager.connectionWriteOp(slot);
            this.log.debug("getting connection for command {} from slot {} using node {}", new Object[]{command, slot, connection.getRedisClient().getAddr()});
            ChannelFuture future = connection.send(new CommandData(attemptPromise, messageDecoder, codec, command, params));
            ex.set(new RedisTimeoutException());
            final Timeout timeout = this.connectionManager.getTimer().newTimeout(retryTimerTask, (long)this.connectionManager.getConfig().getTimeout(), TimeUnit.MILLISECONDS);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        timeout.cancel();
                        ex.set(new WriteRedisConnectionException("Can't send command: " + command + ", params: " + params + ", channel: " + future.channel(), future.cause()));
                        CommandExecutorService.this.connectionManager.getTimer().newTimeout(retryTimerTask, (long)CommandExecutorService.this.connectionManager.getConfig().getRetryInterval(), TimeUnit.MILLISECONDS);
                    }
                }
            });
            if (readOnlyMode) {
                attemptPromise.addListener(this.connectionManager.createReleaseReadListener(slot, connection, timeout));
            } else {
                attemptPromise.addListener(this.connectionManager.createReleaseWriteListener(slot, connection, timeout));
            }
        }
        catch (RedisException e) {
            ex.set(e);
            this.connectionManager.getTimer().newTimeout(retryTimerTask, (long)this.connectionManager.getConfig().getRetryInterval(), TimeUnit.MILLISECONDS);
        }
        attemptPromise.addListener((GenericFutureListener)new FutureListener<R>(){

            public void operationComplete(Future<R> future) throws Exception {
                if (future.isCancelled()) {
                    return;
                }
                if (future.cause() instanceof RedisMovedException) {
                    RedisMovedException ex = (RedisMovedException)future.cause();
                    CommandExecutorService.this.connectionManager.getTimer().newTimeout(retryTimerTask, (long)CommandExecutorService.this.connectionManager.getConfig().getRetryInterval(), TimeUnit.MILLISECONDS);
                    CommandExecutorService.this.async(readOnlyMode, ex.getSlot(), messageDecoder, codec, command, params, mainPromise, client, attempt);
                    return;
                }
                if (future.isSuccess()) {
                    Object res = future.getNow();
                    if (res instanceof RedisClientResult) {
                        ((RedisClientResult)res).setRedisClient(client);
                    }
                    mainPromise.setSuccess(res);
                } else {
                    mainPromise.setFailure(future.cause());
                }
            }
        });
    }
}

