/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.CommandExecutorService;
import org.redisson.SyncOperation;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisException;
import org.redisson.client.RedisMovedException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.connection.ConnectionManager;

public class CommandBatchExecutorService
extends CommandExecutorService {
    private final AtomicInteger index = new AtomicInteger();
    private ConcurrentMap<Integer, Entry> commands = PlatformDependent.newConcurrentHashMap();
    private boolean executed;

    public CommandBatchExecutorService(ConnectionManager connectionManager) {
        super(connectionManager);
    }

    @Override
    protected <V, R> void async(boolean readOnlyMode, int slot, MultiDecoder<Object> messageDecoder, Codec codec, RedisCommand<V> command, Object[] params, Promise<R> mainPromise, RedisClient client, int attempt) {
        if (this.executed) {
            throw new IllegalStateException("Batch already executed!");
        }
        Entry entry = (Entry)this.commands.get(slot);
        if (entry == null) {
            entry = new Entry();
            Entry oldEntry = this.commands.putIfAbsent(slot, entry);
            if (oldEntry != null) {
                entry = oldEntry;
            }
        }
        if (!readOnlyMode) {
            entry.setReadOnlyMode(false);
        }
        entry.getCommands().add(new CommandEntry(new CommandData<V, R>(mainPromise, messageDecoder, codec, command, params), this.index.incrementAndGet()));
    }

    public List<?> execute() {
        return this.get(this.executeAsync());
    }

    public Future<List<?>> executeAsync() {
        if (this.executed) {
            throw new IllegalStateException("Batch already executed!");
        }
        if (this.commands.isEmpty()) {
            return this.connectionManager.getGroup().next().newSucceededFuture(null);
        }
        this.executed = true;
        Promise voidPromise = this.connectionManager.newPromise();
        final Promise promise = this.connectionManager.newPromise();
        voidPromise.addListener((GenericFutureListener)new FutureListener<Void>(){

            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    promise.setFailure(future.cause());
                    return;
                }
                ArrayList<CommandEntry> entries = new ArrayList<CommandEntry>();
                for (Entry e : CommandBatchExecutorService.this.commands.values()) {
                    entries.addAll(e.getCommands());
                }
                Collections.sort(entries);
                ArrayList<Object> result = new ArrayList<Object>();
                for (CommandEntry commandEntry : entries) {
                    result.add(commandEntry.getCommand().getPromise().getNow());
                }
                promise.setSuccess(result);
                CommandBatchExecutorService.this.commands = null;
            }
        });
        AtomicInteger slots = new AtomicInteger(this.commands.size());
        for (Map.Entry e : this.commands.entrySet()) {
            this.execute((Entry)e.getValue(), (Integer)e.getKey(), voidPromise, slots, 0);
        }
        return promise;
    }

    public void execute(final Entry entry, final int slot, final Promise<Void> mainPromise, final AtomicInteger slots, final int attempt) {
        if (!this.connectionManager.getShutdownLatch().acquire()) {
            mainPromise.setFailure((Throwable)new IllegalStateException("Redisson is shutdown"));
            return;
        }
        final Promise attemptPromise = this.connectionManager.newPromise();
        final AtomicReference<RedisException> ex = new AtomicReference<RedisException>();
        final TimerTask retryTimerTask = new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                if (attemptPromise.isDone()) {
                    return;
                }
                if (attempt == CommandBatchExecutorService.this.connectionManager.getConfig().getRetryAttempts()) {
                    attemptPromise.setFailure((Throwable)ex.get());
                    return;
                }
                attemptPromise.cancel(true);
                int count = attempt + 1;
                CommandBatchExecutorService.this.execute(entry, slot, (Promise<Void>)mainPromise, slots, count);
            }
        };
        try {
            RedisConnection connection = entry.isReadOnlyMode() ? this.connectionManager.connectionReadOp(slot) : this.connectionManager.connectionWriteOp(slot);
            ArrayList list = new ArrayList(entry.getCommands().size());
            for (CommandEntry c : entry.getCommands()) {
                list.add(c.getCommand());
            }
            ChannelFuture future = connection.send(new CommandsData(attemptPromise, list));
            ex.set(new RedisTimeoutException());
            final Timeout timeout = this.connectionManager.getTimer().newTimeout(retryTimerTask, (long)this.connectionManager.getConfig().getTimeout(), TimeUnit.MILLISECONDS);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        timeout.cancel();
                        ex.set(new WriteRedisConnectionException("channel: " + future.channel() + " closed"));
                        CommandBatchExecutorService.this.connectionManager.getTimer().newTimeout(retryTimerTask, (long)CommandBatchExecutorService.this.connectionManager.getConfig().getRetryInterval(), TimeUnit.MILLISECONDS);
                    }
                }
            });
            if (entry.isReadOnlyMode()) {
                attemptPromise.addListener(this.connectionManager.createReleaseReadListener(slot, connection, timeout));
            } else {
                attemptPromise.addListener(this.connectionManager.createReleaseWriteListener(slot, connection, timeout));
            }
        }
        catch (RedisException e) {
            ex.set(e);
            this.connectionManager.getTimer().newTimeout(retryTimerTask, (long)this.connectionManager.getConfig().getRetryInterval(), TimeUnit.MILLISECONDS);
        }
        attemptPromise.addListener((GenericFutureListener)new FutureListener<Void>(){

            public void operationComplete(Future<Void> future) throws Exception {
                if (future.isCancelled()) {
                    return;
                }
                if (future.cause() instanceof RedisMovedException) {
                    RedisMovedException ex = (RedisMovedException)future.cause();
                    CommandBatchExecutorService.this.execute(entry, ex.getSlot(), (Promise<Void>)mainPromise, slots, attempt);
                    return;
                }
                if (future.isSuccess()) {
                    if (slots.decrementAndGet() == 0) {
                        mainPromise.setSuccess(future.getNow());
                    }
                } else {
                    mainPromise.setFailure(future.cause());
                }
            }
        });
    }

    @Override
    public <T, R> R evalRead(String key, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, R> R evalRead(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, R> R evalWrite(String key, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, R> R evalWrite(String key, Codec codec, RedisCommand<T> evalCommandType, String script, List<Object> keys, Object ... params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R> R read(String key, SyncOperation<R> operation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <R> R write(String key, SyncOperation<R> operation) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, R> R read(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, R> R read(String key, RedisCommand<T> command, Object ... params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, R> R write(String key, Codec codec, RedisCommand<T> command, Object ... params) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T, R> R write(String key, RedisCommand<T> command, Object ... params) {
        throw new UnsupportedOperationException();
    }

    public static class Entry {
        Queue<CommandEntry> commands = PlatformDependent.newMpscQueue();
        volatile boolean readOnlyMode = true;

        public Queue<CommandEntry> getCommands() {
            return this.commands;
        }

        public void setReadOnlyMode(boolean readOnlyMode) {
            this.readOnlyMode = readOnlyMode;
        }

        public boolean isReadOnlyMode() {
            return this.readOnlyMode;
        }
    }

    public static class CommandEntry
    implements Comparable<CommandEntry> {
        final CommandData<?, ?> command;
        final int index;

        public CommandEntry(CommandData<?, ?> command, int index) {
            this.command = command;
            this.index = index;
        }

        public CommandData<?, ?> getCommand() {
            return this.command;
        }

        @Override
        public int compareTo(CommandEntry o) {
            return this.index - o.index;
        }
    }
}

