/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import org.redisson.BaseConfig;
import org.redisson.connection.LoadBalancer;
import org.redisson.connection.RoundRobinLoadBalancer;

public class BaseMasterSlaveServersConfig<T extends BaseMasterSlaveServersConfig<T>>
extends BaseConfig<T> {
    private LoadBalancer loadBalancer = new RoundRobinLoadBalancer();
    private int slaveSubscriptionConnectionPoolSize = 25;
    private int slaveConnectionPoolSize = 100;
    private int masterConnectionPoolSize = 100;

    public BaseMasterSlaveServersConfig() {
    }

    BaseMasterSlaveServersConfig(T config) {
        super(config);
        this.setLoadBalancer(((BaseMasterSlaveServersConfig)config).getLoadBalancer());
        this.setMasterConnectionPoolSize(((BaseMasterSlaveServersConfig)config).getMasterConnectionPoolSize());
        this.setSlaveConnectionPoolSize(((BaseMasterSlaveServersConfig)config).getSlaveConnectionPoolSize());
        this.setSlaveSubscriptionConnectionPoolSize(((BaseMasterSlaveServersConfig)config).getSlaveSubscriptionConnectionPoolSize());
    }

    public T setSlaveConnectionPoolSize(int slaveConnectionPoolSize) {
        this.slaveConnectionPoolSize = slaveConnectionPoolSize;
        return (T)this;
    }

    public int getSlaveConnectionPoolSize() {
        return this.slaveConnectionPoolSize;
    }

    public T setMasterConnectionPoolSize(int masterConnectionPoolSize) {
        this.masterConnectionPoolSize = masterConnectionPoolSize;
        return (T)this;
    }

    public int getMasterConnectionPoolSize() {
        return this.masterConnectionPoolSize;
    }

    public T setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
        return (T)this;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public T setSlaveSubscriptionConnectionPoolSize(int slaveSubscriptionConnectionPoolSize) {
        this.slaveSubscriptionConnectionPoolSize = slaveSubscriptionConnectionPoolSize;
        return (T)this;
    }

    public int getSlaveSubscriptionConnectionPoolSize() {
        return this.slaveSubscriptionConnectionPoolSize;
    }
}

