/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import com.lambdaworks.redis.RedisClient;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.pubsub.RedisPubSubAdapter;
import com.lambdaworks.redis.pubsub.RedisPubSubConnection;
import com.lambdaworks.redis.pubsub.RedisPubSubListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import org.redisson.Config;
import org.redisson.codec.RedisCodecWrapper;
import org.redisson.connection.LoadBalancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Queue<RedisConnection> connections = new ConcurrentLinkedQueue<RedisConnection>();
    private final Queue<PubSubEntry> pubSubConnections = new ConcurrentLinkedQueue<PubSubEntry>();
    private final List<RedisClient> clients = new ArrayList<RedisClient>();
    private final Semaphore activeConnections;
    private final RedisCodec codec;
    private final Config config;
    private final LoadBalancer balancer;

    public ConnectionManager(Config config) {
        for (URI address : config.getAddresses()) {
            RedisClient client = new RedisClient(address.getHost(), address.getPort());
            this.clients.add(client);
        }
        this.balancer = config.getLoadBalancer();
        this.balancer.init(this.clients);
        this.codec = new RedisCodecWrapper(config.getCodec());
        this.activeConnections = new Semaphore(config.getConnectionPoolSize());
        this.config = config;
    }

    public <K, V> RedisConnection<K, V> connection() {
        this.acquireConnection();
        RedisConnection conn = this.connections.poll();
        if (conn == null) {
            conn = this.balancer.nextClient().connect(this.codec);
            if (this.config.getPassword() != null) {
                conn.auth(this.config.getPassword());
            }
        }
        return conn;
    }

    public <K, V> PubSubEntry subscribe(RedisPubSubAdapter<K, V> listener, K channel) {
        PubSubEntry entry2;
        for (PubSubEntry entry2 : this.pubSubConnections) {
            if (!entry2.subscribe(listener, channel)) continue;
            return entry2;
        }
        this.acquireConnection();
        RedisPubSubConnection conn = this.balancer.nextClient().connectPubSub(this.codec);
        if (this.config.getPassword() != null) {
            conn.auth(this.config.getPassword());
        }
        entry2 = new PubSubEntry(conn, this.config.getSubscriptionsPerConnection());
        entry2.subscribe(listener, channel);
        this.pubSubConnections.add(entry2);
        return entry2;
    }

    private void acquireConnection() {
        if (!this.activeConnections.tryAcquire()) {
            this.log.warn("Connection pool gets exhausted! Trying to acquire connection ...");
            long time = System.currentTimeMillis();
            this.activeConnections.acquireUninterruptibly();
            long endTime = System.currentTimeMillis() - time;
            this.log.warn("Connection acquired, time spended: {} ms", (Object)endTime);
        }
    }

    public <K> void unsubscribe(PubSubEntry entry, K channel) {
        entry.unsubscribe(channel);
        if (entry.tryClose()) {
            this.pubSubConnections.remove(entry);
            this.activeConnections.release();
        }
    }

    public void release(RedisConnection \u0441onnection) {
        this.connections.add(\u0441onnection);
        this.activeConnections.release();
    }

    public void shutdown() {
        for (RedisClient client : this.clients) {
            client.shutdown();
        }
    }

    public static class PubSubEntry {
        private final Semaphore semaphore;
        private final RedisPubSubConnection conn;
        private final int subscriptionsPerConnection;

        public PubSubEntry(RedisPubSubConnection conn, int subscriptionsPerConnection) {
            this.conn = conn;
            this.subscriptionsPerConnection = subscriptionsPerConnection;
            this.semaphore = new Semaphore(subscriptionsPerConnection);
        }

        public void addListener(RedisPubSubListener listener) {
            this.conn.addListener(listener);
        }

        public void removeListener(RedisPubSubListener listener) {
            this.conn.removeListener(listener);
        }

        public boolean subscribe(RedisPubSubAdapter listener, Object channel) {
            if (this.semaphore.tryAcquire()) {
                this.conn.addListener(listener);
                this.conn.subscribe(channel);
                return true;
            }
            return false;
        }

        public void unsubscribe(Object channel) {
            this.conn.unsubscribe(channel);
            this.semaphore.release();
        }

        public boolean tryClose() {
            if (this.semaphore.tryAcquire(this.subscriptionsPerConnection)) {
                this.conn.close();
                return true;
            }
            return false;
        }
    }
}

