/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import com.lambdaworks.redis.RedisConnection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.redisson.RedissonSortedSet;
import org.redisson.connection.ConnectionManager;

class RedissonSubSortedSet<V>
implements SortedSet<V> {
    private ConnectionManager connectionManager;
    private RedissonSortedSet<V> redissonSortedSet;
    private V headValue;
    private V tailValue;

    public RedissonSubSortedSet(RedissonSortedSet<V> redissonSortedSet, ConnectionManager connectionManager, V headValue, V tailValue) {
        this.headValue = headValue;
        this.tailValue = tailValue;
        this.connectionManager = connectionManager;
        this.redissonSortedSet = redissonSortedSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            double headScore = this.getHeadScore(connection);
            double tailScore = this.getTailScore(connection);
            int n = connection.zcount(this.redissonSortedSet.getName(), headScore, tailScore).intValue();
            return n;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    private double getTailScore(RedisConnection<Object, V> connection) {
        if (this.tailValue != null) {
            return this.redissonSortedSet.score(this.tailValue, connection, 1, true);
        }
        return Double.MAX_VALUE;
    }

    private double getHeadScore(RedisConnection<Object, V> connection) {
        if (this.headValue != null) {
            return this.redissonSortedSet.score(this.headValue, connection, -1, false);
        }
        return 0.0;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        RedisConnection connection = this.connectionManager.connection();
        try {
            double headScore = this.getHeadScore(connection);
            double tailScore = this.getTailScore(connection);
            RedissonSortedSet.BinarySearchResult<Object> res = this.redissonSortedSet.binarySearch(o, connection);
            boolean bl = res.getScore() < tailScore && res.getScore() > headScore;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<V> iterator() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            double headScore = this.getHeadScore(connection);
            double tailScore = this.getTailScore(connection);
            Iterator<V> iterator = this.redissonSortedSet.iterator(headScore, tailScore);
            return iterator;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            double headScore = this.getHeadScore(connection);
            double tailScore = this.getTailScore(connection);
            Object[] objectArray = connection.zrangebyscore(this.redissonSortedSet.getName(), headScore, tailScore).toArray();
            return objectArray;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        RedisConnection connection = this.connectionManager.connection();
        try {
            double headScore = this.getHeadScore(connection);
            double tailScore = this.getTailScore(connection);
            T[] TArray = connection.zrangebyscore(this.redissonSortedSet.getName(), headScore, tailScore).toArray(a);
            return TArray;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(V e) {
        RedisConnection connection = this.connectionManager.connection();
        try {
            double headScore = this.getHeadScore(connection);
            double tailScore = this.getTailScore(connection);
            RedissonSortedSet.BinarySearchResult<V> res = this.redissonSortedSet.binarySearch(e, connection);
            if (res.getScore() == null) {
                RedissonSortedSet.NewScore score = this.redissonSortedSet.calcNewScore(res.getIndex(), connection);
                if (score.getScore() < tailScore && score.getScore() > headScore) {
                    boolean bl = this.redissonSortedSet.add(e);
                    return bl;
                }
                throw new IllegalArgumentException("value out of range");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        RedisConnection connection = this.connectionManager.connection();
        try {
            double headScore = this.getHeadScore(connection);
            double tailScore = this.getTailScore(connection);
            RedissonSortedSet.BinarySearchResult<Object> res = this.redissonSortedSet.binarySearch(o, connection);
            if (res.getScore() != null && res.getScore() < tailScore && res.getScore() > headScore) {
                boolean bl = this.redissonSortedSet.remove(o);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean changed = false;
        for (V v : c) {
            if (!this.add(v)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (V object : this) {
            if (c.contains(object)) continue;
            this.remove(object);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object obj : c) {
            if (!this.remove(obj)) continue;
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            double headScore = this.getHeadScore(connection);
            double tailScore = this.getTailScore(connection);
            connection.zremrangebyscore(this.redissonSortedSet.getName(), headScore, tailScore);
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    @Override
    public Comparator<? super V> comparator() {
        return this.redissonSortedSet.comparator();
    }

    @Override
    public SortedSet<V> subSet(V fromElement, V toElement) {
        if (fromElement == null) {
            fromElement = this.headValue;
        }
        if (toElement == null) {
            toElement = this.tailValue;
        }
        return new RedissonSubSortedSet<V>(this.redissonSortedSet, this.connectionManager, fromElement, toElement);
    }

    @Override
    public SortedSet<V> headSet(V toElement) {
        return this.subSet((V)null, toElement);
    }

    @Override
    public SortedSet<V> tailSet(V fromElement) {
        return this.subSet(fromElement, (V)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V first() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            if (this.headValue != null) {
                RedissonSortedSet.BinarySearchResult<V> res = this.redissonSortedSet.binarySearch(this.headValue, connection);
                if (res.getIndex() < 0) {
                    RedissonSortedSet.NewScore headScore = this.redissonSortedSet.calcNewScore(res.getIndex(), connection);
                    double tailScore = this.getTailScore(connection);
                    List vals = connection.zrangebyscore(this.redissonSortedSet.getName(), headScore.getScore(), tailScore);
                    if (vals.isEmpty()) {
                        throw new NoSuchElementException();
                    }
                    Object v = vals.get(0);
                    return v;
                }
                V v = res.getValue();
                return v;
            }
            V v = this.redissonSortedSet.first();
            return v;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V last() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            if (this.tailValue != null) {
                RedissonSortedSet.BinarySearchResult<V> res = this.redissonSortedSet.binarySearch(this.tailValue, connection);
                if (res.getIndex() < 0) {
                    RedissonSortedSet.NewScore tailScore = this.redissonSortedSet.calcNewScore(res.getIndex(), connection);
                    double headScore = this.getHeadScore(connection);
                    List vals = connection.zrangebyscore(this.redissonSortedSet.getName(), headScore, tailScore.getScore());
                    if (vals.isEmpty()) {
                        throw new NoSuchElementException();
                    }
                    Object v = vals.get(0);
                    return v;
                }
                V v = res.getValue();
                return v;
            }
            V v = this.redissonSortedSet.last();
            return v;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

