/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.ScoredValue;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.redisson.RedissonObject;
import org.redisson.RedissonSubSortedSet;
import org.redisson.connection.ConnectionManager;
import org.redisson.core.RSortedSet;

public class RedissonSortedSet<V>
extends RedissonObject
implements RSortedSet<V> {
    private final ConnectionManager connectionManager;
    private Comparator<? super V> comparator = NaturalComparator.NATURAL_ORDER;

    RedissonSortedSet(ConnectionManager connectionManager, String name) {
        super(name);
        this.connectionManager = connectionManager;
        this.loadComparator();
        RedisConnection<String, Long> conn = connectionManager.connection();
        conn.setnx(this.getCurrentVersionKey(), 0L);
        connectionManager.release(conn);
    }

    private void loadComparator() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            this.loadComparator(connection);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    private void loadComparator(RedisConnection<Object, ?> connection) {
        try {
            String comparatorSign = (String)connection.get(this.getComparatorKeyName());
            if (comparatorSign != null) {
                String[] parts = comparatorSign.split(":");
                String className = parts[0];
                String sign = parts[1];
                String result = RedissonSortedSet.calcClassSign(className);
                if (!result.equals(sign)) {
                    throw new IllegalStateException("Local class signature of " + className + " differs from used by this SortedSet!");
                }
                Class<?> clazz = Class.forName(className);
                this.comparator = (Comparator)clazz.newInstance();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static String calcClassSign(String name) {
        try {
            Class<?> clazz = Class.forName(name);
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            ObjectOutputStream outputStream = new ObjectOutputStream(result);
            outputStream.writeObject(clazz);
            outputStream.close();
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(result.toByteArray());
            return new BigInteger(1, crypt.digest()).toString(16);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can't calculate sign of " + name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            int n = this.size(connection);
            return n;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    private int size(RedisConnection<Object, ?> connection) {
        return connection.zcard(this.getName()).intValue();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        RedisConnection connection = this.connectionManager.connection();
        try {
            boolean bl = this.binarySearch(o, connection).getIndex() >= 0;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<V> iterator() {
        double startScore;
        RedisConnection connection = this.connectionManager.connection();
        try {
            startScore = this.getScoreAtIndex(0, connection);
        }
        finally {
            this.connectionManager.release(connection);
        }
        return this.iterator(startScore, Double.MAX_VALUE);
    }

    public Iterator<V> iterator(final double startScore, final double endScore) {
        return new Iterator<V>(){
            private double currentScore;
            private boolean removeExecuted;
            private V value;
            {
                this.currentScore = startScore;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                RedisConnection connection = RedissonSortedSet.this.connectionManager.connection();
                try {
                    Long remains = connection.zcount(RedissonSortedSet.this.getName(), this.currentScore, endScore);
                    boolean bl = remains > 0L;
                    return bl;
                }
                finally {
                    RedissonSortedSet.this.connectionManager.release(connection);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No such element at index " + this.currentScore);
                }
                this.removeExecuted = false;
                RedisConnection connection = RedissonSortedSet.this.connectionManager.connection();
                try {
                    double lastScore = RedissonSortedSet.this.getScoreAtIndex(-1, connection);
                    double scoreDiff = lastScore - this.currentScore;
                    Long remains = connection.zcount(RedissonSortedSet.this.getName(), this.currentScore, lastScore);
                    if (remains == 0L) {
                        throw new NoSuchElementException("No more elements!");
                    }
                    List values = connection.zrangebyscoreWithScores(RedissonSortedSet.this.getName(), this.currentScore, Double.MAX_VALUE);
                    if (values.isEmpty()) {
                        throw new NoSuchElementException("No more elements!");
                    }
                    ScoredValue val = values.get(0);
                    this.value = val.value;
                    if (values.size() > 1) {
                        ScoredValue nextVal = values.get(1);
                        this.currentScore = nextVal.score;
                    } else {
                        this.currentScore = endScore;
                    }
                    Object v = this.value;
                    return v;
                }
                finally {
                    RedissonSortedSet.this.connectionManager.release(connection);
                }
            }

            @Override
            public void remove() {
                if (this.removeExecuted) {
                    throw new IllegalStateException("Element been already deleted");
                }
                RedissonSortedSet.this.remove(this.value);
                this.removeExecuted = true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            Object[] objectArray = connection.zrange(this.getName(), 0L, -1L).toArray();
            return objectArray;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        RedisConnection connection = this.connectionManager.connection();
        try {
            T[] TArray = connection.zrange(this.getName(), 0L, -1L).toArray(a);
            return TArray;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    private String getCurrentVersionKey() {
        return "redisson__sortedset__version__" + this.getName();
    }

    private Long getCurrentVersion(RedisConnection<Object, Object> simpleConnection) {
        return ((Number)simpleConnection.get(this.getCurrentVersionKey())).longValue();
    }

    @Override
    public boolean add(V value) {
        RedisConnection<Object, Object> connection;
        RedisConnection<Object, Object> simpleConnection = connection = this.connectionManager.connection();
        try {
            while (true) {
                connection.watch(this.getComparatorKeyName());
                this.checkComparator(connection);
                Long version = this.getCurrentVersion(simpleConnection);
                BinarySearchResult<Object> res = this.binarySearch(value, connection);
                if (res.getIndex() < 0) {
                    if (!version.equals(this.getCurrentVersion(simpleConnection))) {
                        connection.unwatch();
                        continue;
                    }
                    NewScore newScore = this.calcNewScore(res.getIndex(), connection);
                    if (!version.equals(this.getCurrentVersion(simpleConnection))) {
                        connection.unwatch();
                        continue;
                    }
                    String leftScoreKey = this.getScoreKeyName(newScore.getLeftScore());
                    String rightScoreKey = this.getScoreKeyName(newScore.getRightScore());
                    if (simpleConnection.setnx(leftScoreKey, 1).booleanValue()) {
                        if (!version.equals(this.getCurrentVersion(simpleConnection))) {
                            connection.unwatch();
                            connection.del((Object[])new Object[]{leftScoreKey});
                            continue;
                        }
                        if (rightScoreKey != null && !simpleConnection.setnx(rightScoreKey, 1).booleanValue()) {
                            connection.unwatch();
                            connection.del((Object[])new Object[]{leftScoreKey});
                            continue;
                        }
                    } else {
                        connection.unwatch();
                        continue;
                    }
                    connection.multi();
                    connection.zadd((Object)this.getName(), newScore.getScore(), value);
                    if (rightScoreKey != null) {
                        connection.del((Object[])new Object[]{leftScoreKey, rightScoreKey});
                    } else {
                        connection.del((Object[])new Object[]{leftScoreKey});
                    }
                    connection.incr(this.getCurrentVersionKey());
                    List<Object> re = connection.exec();
                    if (re.size() == 3) {
                        Number val = (Number)re.get(0);
                        Long delCount = (Long)re.get(1);
                        if (rightScoreKey != null ? delCount != 2L : delCount != 1L) {
                            throw new IllegalStateException();
                        }
                        boolean bl = val != null && val.intValue() > 0;
                        return bl;
                    }
                } else {
                    connection.unwatch();
                    boolean bl = false;
                    return bl;
                }
                this.checkComparator(connection);
            }
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkComparator(RedisConnection<Object, ?> connection) {
        String comparatorSign = (String)connection.get(this.getComparatorKeyName());
        if (comparatorSign != null) {
            String[] vals = comparatorSign.split(":");
            String className = vals[0];
            if (!this.comparator.getClass().getName().equals(className)) {
                try {
                    this.loadComparator(connection);
                }
                finally {
                    connection.unwatch();
                }
            }
        }
    }

    public NewScore calcNewScore(int index, RedisConnection<Object, V> connection) {
        if (index >= 0) {
            throw new IllegalStateException("index should be negative, but value is " + index);
        }
        index = -(index + 1);
        Double leftScore = null;
        Double rightScore = null;
        double score = this.getScoreAtIndex(index, connection);
        if (index == 0) {
            if (score < 0.0) {
                score = 1000000.0;
                leftScore = score;
            } else {
                leftScore = score;
                score /= 2.0;
            }
        } else {
            leftScore = this.getScoreAtIndex(index - 1, connection);
            if (score < 0.0) {
                score = leftScore + 1000000.0;
            } else {
                rightScore = score;
                score = leftScore + (rightScore - leftScore) / 2.0;
            }
        }
        return new NewScore(leftScore, rightScore, score);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object value) {
        RedisConnection connection = this.connectionManager.connection();
        try {
            BinarySearchResult<Object> res = this.binarySearch(value, connection);
            if (res.getIndex() < 0) {
                boolean bl = false;
                return bl;
            }
            connection.multi();
            connection.zremrangebyscore(this.getName(), res.getScore(), res.getScore());
            connection.incr(this.getCurrentVersionKey());
            List<Object> result = connection.exec();
            if (result.size() == 2) {
                boolean bl = ((Number)result.get(0)).longValue() > 0L;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean changed = false;
        for (V v : c) {
            if (!this.add(v)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (V object : this) {
            if (c.contains(object)) continue;
            this.remove(object);
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object obj : c) {
            if (!this.remove(obj)) continue;
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            connection.del(this.getName());
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    @Override
    public Comparator<? super V> comparator() {
        return this.comparator;
    }

    @Override
    public SortedSet<V> subSet(V fromElement, V toElement) {
        return new RedissonSubSortedSet<V>(this, this.connectionManager, fromElement, toElement);
    }

    @Override
    public SortedSet<V> headSet(V toElement) {
        return this.subSet((V)null, toElement);
    }

    @Override
    public SortedSet<V> tailSet(V fromElement) {
        return this.subSet(fromElement, (V)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V first() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            BinarySearchResult res = this.getAtIndex(0, connection);
            if (res.getScore() == null) {
                throw new NoSuchElementException();
            }
            Object v = res.getValue();
            return v;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V last() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            BinarySearchResult res = this.getAtIndex(-1, connection);
            if (res.getScore() == null) {
                throw new NoSuchElementException();
            }
            Object v = res.getValue();
            return v;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    private String getScoreKeyName(Double score) {
        if (score == null) {
            return null;
        }
        return "redisson__sortedset__score__" + this.getName() + "__" + score;
    }

    private String getComparatorKeyName() {
        return "redisson__sortedset__comparator__" + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trySetComparator(Comparator<? super V> comparator) {
        RedisConnection<Object, String> connection = this.connectionManager.connection();
        try {
            connection.watch(this.getName(), this.getComparatorKeyName());
            if (this.size(connection) > 0) {
                connection.unwatch();
                boolean bl = false;
                return bl;
            }
            connection.multi();
            String className = comparator.getClass().getName();
            String comparatorSign = className + ":" + RedissonSortedSet.calcClassSign(className);
            connection.set(this.getComparatorKeyName(), comparatorSign);
            List<Object> res = connection.exec();
            if (res.size() == 1) {
                this.comparator = comparator;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    private double getScoreAtIndex(int index, RedisConnection<Object, V> connection) {
        List<ScoredValue<V>> res = connection.zrangeWithScores(this.getName(), index, index);
        if (res.isEmpty()) {
            return -1.0;
        }
        return res.get((int)0).score;
    }

    private BinarySearchResult<V> getAtIndex(int index, RedisConnection<Object, V> connection) {
        List<ScoredValue<V>> res = connection.zrangeWithScores(this.getName(), index, index);
        if (res.isEmpty()) {
            return new BinarySearchResult();
        }
        return new BinarySearchResult(res.get((int)0).value, res.get((int)0).score);
    }

    private BinarySearchResult<V> binarySearch(V value, RedisConnection<Object, V> connection, int lowerIndex, int upperIndex) {
        while (lowerIndex <= upperIndex) {
            int index = lowerIndex + (upperIndex - lowerIndex) / 2;
            BinarySearchResult<V> indexRes = this.getAtIndex(index, connection);
            int cmp = this.comparator.compare(value, indexRes.getValue());
            if (cmp == 0) {
                indexRes.setIndex(index);
                return indexRes;
            }
            if (cmp < 0) {
                upperIndex = index - 1;
                continue;
            }
            lowerIndex = index + 1;
        }
        BinarySearchResult indexRes = new BinarySearchResult();
        indexRes.setIndex(-(lowerIndex + 1));
        return indexRes;
    }

    public BinarySearchResult<V> binarySearch(V value, RedisConnection<Object, V> connection) {
        int upperIndex = this.size(connection) - 1;
        return this.binarySearch(value, connection, 0, upperIndex);
    }

    public double score(V value, RedisConnection<Object, V> connection, int indexDiff, boolean tail) {
        BinarySearchResult<V> res = this.binarySearch(value, connection);
        if (res.getIndex() < 0) {
            BinarySearchResult<V> element = this.getAtIndex(-res.getIndex() + indexDiff, connection);
            if (element.getScore() == null && res.getScore() == null && tail) {
                element = this.getAtIndex(-res.getIndex() - 2, connection);
                return element.getScore();
            }
            return element.getScore();
        }
        int ind = res.getIndex();
        if (tail) {
            ind = res.getIndex() - indexDiff;
        }
        BinarySearchResult<V> element = this.getAtIndex(ind, connection);
        return element.getScore();
    }

    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public static class BinarySearchResult<V> {
        private V value;
        private Double score;
        private int index;

        public BinarySearchResult(V value, double score) {
            this.value = value;
            this.score = score;
        }

        public BinarySearchResult() {
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public V getValue() {
            return this.value;
        }

        public Double getScore() {
            return this.score;
        }
    }

    public static class NewScore {
        private Double leftScore;
        private Double rightScore;
        private Double score;

        public NewScore(Double leftScore, Double rightScore, Double score) {
            this.leftScore = leftScore;
            this.rightScore = rightScore;
            this.score = score;
        }

        public Double getLeftScore() {
            return this.leftScore;
        }

        public Double getRightScore() {
            return this.rightScore;
        }

        public Double getScore() {
            return this.score;
        }
    }

    private static class NaturalComparator<V>
    implements Comparator<V>,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;
        static final NaturalComparator NATURAL_ORDER = new NaturalComparator();

        private NaturalComparator() {
        }

        @Override
        public int compare(V c1, V c2) {
            Comparable c1co = (Comparable)c1;
            Comparable c2co = (Comparable)c2;
            return c1co.compareTo(c2co);
        }
    }
}

