/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import com.lambdaworks.redis.RedisConnection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.redisson.RedissonObject;
import org.redisson.connection.ConnectionManager;
import org.redisson.core.RSet;

public class RedissonSet<V>
extends RedissonObject
implements RSet<V> {
    private final ConnectionManager connectionManager;

    RedissonSet(ConnectionManager connectionManager, String name) {
        super(name);
        this.connectionManager = connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            int n = connection.scard(this.getName()).intValue();
            return n;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        RedisConnection<String, Object> connection = this.connectionManager.connection();
        try {
            boolean bl = connection.sismember(this.getName(), o);
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<V> iterator() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            final Iterator iter = connection.smembers(this.getName()).iterator();
            Iterator iterator = new Iterator<V>(){
                private boolean removeExecuted;
                private V value;

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public V next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("No such element at index");
                    }
                    this.value = iter.next();
                    this.removeExecuted = false;
                    return this.value;
                }

                @Override
                public void remove() {
                    if (this.removeExecuted) {
                        throw new IllegalStateException("Element been already deleted");
                    }
                    iter.remove();
                    RedissonSet.this.remove(this.value);
                    this.removeExecuted = true;
                }
            };
            return iterator;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            Object[] objectArray = connection.smembers(this.getName()).toArray();
            return objectArray;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] a) {
        RedisConnection connection = this.connectionManager.connection();
        try {
            T[] TArray = connection.smembers(this.getName()).toArray(a);
            return TArray;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(V e) {
        RedisConnection<String, Object> connection = this.connectionManager.connection();
        try {
            boolean bl = connection.sadd(this.getName(), e) > 0L;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        RedisConnection<String, Object> connection = this.connectionManager.connection();
        try {
            boolean bl = connection.srem(this.getName(), o) > 0L;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object object : c) {
            if (this.contains(object)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends V> c) {
        RedisConnection<String, Object> connection = this.connectionManager.connection();
        try {
            boolean bl = connection.sadd(this.getName(), c.toArray()) > 0L;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (V object : this) {
            if (c.contains(object)) continue;
            this.remove(object);
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        RedisConnection<String, Object> connection = this.connectionManager.connection();
        try {
            boolean bl = connection.srem(this.getName(), c.toArray()) > 0L;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            connection.del(this.getName());
        }
        finally {
            this.connectionManager.release(connection);
        }
    }
}

