/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import com.lambdaworks.redis.RedisConnection;
import java.util.NoSuchElementException;
import org.redisson.RedissonList;
import org.redisson.connection.ConnectionManager;
import org.redisson.core.RQueue;

public class RedissonQueue<V>
extends RedissonList<V>
implements RQueue<V> {
    RedissonQueue(ConnectionManager connectionManager, String name) {
        super(connectionManager, name);
    }

    @Override
    public boolean offer(V e) {
        return this.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getFirst() {
        RedisConnection connection = this.getConnectionManager().connection();
        try {
            Object value = connection.lindex(this.getName(), 0L);
            if (value == null) {
                throw new NoSuchElementException();
            }
            Object v = value;
            return v;
        }
        finally {
            this.getConnectionManager().release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V removeFirst() {
        RedisConnection connection = this.getConnectionManager().connection();
        try {
            Object value = connection.lpop(this.getName());
            if (value == null) {
                throw new NoSuchElementException();
            }
            Object v = value;
            return v;
        }
        finally {
            this.getConnectionManager().release(connection);
        }
    }

    @Override
    public V remove() {
        return this.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V poll() {
        RedisConnection connection = this.getConnectionManager().connection();
        try {
            Object v = connection.lpop(this.getName());
            return v;
        }
        finally {
            this.getConnectionManager().release(connection);
        }
    }

    @Override
    public V element() {
        return this.getFirst();
    }

    @Override
    public V peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(0);
    }
}

