/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import com.lambdaworks.redis.RedisConnection;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.redisson.RedissonObject;
import org.redisson.connection.ConnectionManager;
import org.redisson.core.RMap;

public class RedissonMap<K, V>
extends RedissonObject
implements RMap<K, V> {
    private final ConnectionManager connectionManager;

    RedissonMap(ConnectionManager connectionManager, String name) {
        super(name);
        this.connectionManager = connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            int n = connection.hlen(this.getName()).intValue();
            return n;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        RedisConnection connection = this.connectionManager.connection();
        try {
            boolean bl = connection.hexists(this.getName(), key);
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsValue(Object value) {
        RedisConnection connection = this.connectionManager.connection();
        try {
            boolean bl = connection.hvals(this.getName()).contains(value);
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        RedisConnection connection = this.connectionManager.connection();
        try {
            Object v = connection.hget(this.getName(), key);
            return v;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        RedisConnection<String, V> connection = this.connectionManager.connection();
        try {
            Object prev = connection.hget(this.getName(), (String)key);
            connection.hset(this.getName(), (String)key, value);
            Object v = prev;
            return v;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        RedisConnection connection = this.connectionManager.connection();
        try {
            Object prev = connection.hget(this.getName(), key);
            connection.hdel(this.getName(), key);
            Object v = prev;
            return v;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        RedisConnection<? extends K, ? extends V> connection = this.connectionManager.connection();
        try {
            connection.hmset((K)this.getName(), map);
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            connection.del(this.getName());
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<K> keySet() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(connection.hkeys(this.getName()));
            return linkedHashSet;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<V> values() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            List list = connection.hvals(this.getName());
            return list;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            Map map = connection.hgetall(this.getName());
            HashMap result = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                result.put(entry.getKey(), entry.getValue());
            }
            Set set = result.entrySet();
            return set;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        RedisConnection<String, V> connection = this.connectionManager.connection();
        try {
            while (true) {
                Boolean res;
                if (!(res = connection.hsetnx(this.getName(), (String)key, value)).booleanValue()) {
                    V result = this.get(key);
                    if (result != null) {
                        V v = result;
                        return v;
                    }
                } else {
                    V v = null;
                    return v;
                }
            }
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    private boolean isEquals(RedisConnection<Object, Object> connection, Object key, Object value) {
        Object val = connection.hget(this.getName(), key);
        return value != null && value.equals(val) || value == null && val == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        RedisConnection<Object, Object> connection = this.connectionManager.connection();
        try {
            block5: {
                do {
                    connection.watch(this.getName());
                    if (!connection.hexists(this.getName(), key).booleanValue() || !this.isEquals(connection, key, value)) break block5;
                    connection.multi();
                    connection.hdel(this.getName(), (Object[])new Object[]{key});
                } while (connection.exec().size() != 1);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        RedisConnection<Object, Object> connection = this.connectionManager.connection();
        try {
            block5: {
                do {
                    connection.watch(this.getName());
                    if (!connection.hexists(this.getName(), key).booleanValue() || !this.isEquals(connection, key, oldValue)) break block5;
                    connection.multi();
                    connection.hset(this.getName(), key, newValue);
                } while (connection.exec().size() != 1);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        RedisConnection<Object, V> connection = this.connectionManager.connection();
        try {
            connection.watch(this.getName());
            if (connection.hexists(this.getName(), key).booleanValue()) {
                Object prev = connection.hget(this.getName(), key);
                connection.multi();
                connection.hset(this.getName(), key, value);
                if (connection.exec().size() == 1) {
                    Object v = prev;
                    return v;
                }
            }
            V v = null;
            return v;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }
}

