/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.pubsub.RedisPubSubAdapter;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import org.redisson.RedissonObject;
import org.redisson.connection.ConnectionManager;
import org.redisson.core.RLock;

public class RedissonLock
extends RedissonObject
implements RLock {
    private final ConnectionManager connectionManager;
    private final UUID id;
    private static final Integer unlockMessage = 0;
    private final CountDownLatch subscribeLatch = new CountDownLatch(1);
    private final AtomicBoolean subscribeOnce = new AtomicBoolean();
    private final Semaphore msg = new Semaphore(1);
    private ConnectionManager.PubSubEntry pubSubEntry;

    RedissonLock(ConnectionManager connectionManager, String name, UUID id) {
        super(name);
        this.connectionManager = connectionManager;
        this.id = id;
    }

    public void subscribe() {
        if (this.subscribeOnce.compareAndSet(false, true)) {
            this.msg.acquireUninterruptibly();
            RedisPubSubAdapter<String, Integer> listener = new RedisPubSubAdapter<String, Integer>(){

                @Override
                public void subscribed(String channel, long count) {
                    if (RedissonLock.this.getChannelName().equals(channel)) {
                        RedissonLock.this.subscribeLatch.countDown();
                    }
                }

                @Override
                public void message(String channel, Integer message) {
                    if (message.equals(unlockMessage) && RedissonLock.this.getChannelName().equals(channel)) {
                        RedissonLock.this.msg.release();
                    }
                }
            };
            this.pubSubEntry = this.connectionManager.subscribe(listener, this.getChannelName());
        }
        try {
            this.subscribeLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void lock() {
        try {
            this.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    private String getKeyName() {
        return "redisson__lock__" + this.getName();
    }

    private String getChannelName() {
        return "redisson__lock__channel__" + this.getName();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        while (!this.tryLock()) {
            this.msg.acquire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock() {
        LockValue currentLock = new LockValue(this.id, Thread.currentThread().getId());
        currentLock.incCounter();
        RedisConnection<String, LockValue> connection = this.connectionManager.connection();
        try {
            LockValue lock;
            Boolean res = connection.setnx(this.getKeyName(), currentLock);
            if (!res.booleanValue() && (lock = (LockValue)connection.get(this.getKeyName())) != null && lock.equals(currentLock)) {
                lock.incCounter();
                connection.set(this.getKeyName(), lock);
                boolean bl = true;
                return bl;
            }
            boolean bl = res;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) throws InterruptedException {
        time = unit.toMillis(time);
        while (!this.tryLock()) {
            if (time <= 0L) {
                return false;
            }
            long current = System.currentTimeMillis();
            this.msg.tryAcquire(time, TimeUnit.MILLISECONDS);
            long elapsed = System.currentTimeMillis() - current;
            time -= elapsed;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        block6: {
            LockValue currentLock = new LockValue(this.id, Thread.currentThread().getId());
            RedisConnection<Object, Object> connection = this.connectionManager.connection();
            try {
                LockValue lock = (LockValue)connection.get(this.getKeyName());
                if (lock != null && lock.equals(currentLock)) {
                    if (lock.getCounter() > 1) {
                        lock.decCounter();
                        connection.set(this.getKeyName(), lock);
                    } else {
                        this.unlock(connection);
                    }
                    break block6;
                }
                throw new IllegalMonitorStateException("Attempt to unlock lock, not locked by current id: " + this.id + " thread-id: " + Thread.currentThread().getId());
            }
            finally {
                this.connectionManager.release(connection);
            }
        }
    }

    private void unlock(RedisConnection<Object, Object> connection) {
        for (int counter = 0; counter < 5; ++counter) {
            connection.multi();
            connection.del((Object[])new Object[]{this.getKeyName()});
            connection.publish(this.getChannelName(), unlockMessage);
            if (connection.exec().size() != 2) continue;
            return;
        }
        throw new IllegalStateException("Can't unlock lock after 5 attempts. Current id: " + this.id + " thread-id: " + Thread.currentThread().getId());
    }

    @Override
    public Condition newCondition() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.connectionManager.unsubscribe(this.pubSubEntry, this.getChannelName());
    }

    @Override
    public void forceUnlock() {
        RedisConnection<Object, Object> connection = this.connectionManager.connection();
        try {
            while (true) {
                LockValue lock;
                if ((lock = (LockValue)connection.get(this.getKeyName())) == null) {
                    continue;
                }
                this.unlock(connection);
            }
        }
        catch (Throwable throwable) {
            this.connectionManager.release(connection);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLocked() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            LockValue lock = (LockValue)connection.get(this.getKeyName());
            boolean bl = lock != null;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHeldByCurrentThread() {
        LockValue currentLock = new LockValue(this.id, Thread.currentThread().getId());
        RedisConnection connection = this.connectionManager.connection();
        try {
            LockValue lock = (LockValue)connection.get(this.getKeyName());
            boolean bl = lock != null && lock.equals(currentLock);
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHoldCount() {
        LockValue currentLock = new LockValue(this.id, Thread.currentThread().getId());
        RedisConnection connection = this.connectionManager.connection();
        try {
            LockValue lock = (LockValue)connection.get(this.getKeyName());
            if (lock != null && lock.equals(currentLock)) {
                int n = lock.getCounter();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    public static class LockValue
    implements Serializable {
        private static final long serialVersionUID = -8895632286065689476L;
        private UUID id;
        private Long threadId;
        private int counter;

        public LockValue() {
        }

        public LockValue(UUID id, Long threadId) {
            this.id = id;
            this.threadId = threadId;
        }

        public void decCounter() {
            --this.counter;
        }

        public void incCounter() {
            ++this.counter;
        }

        public int getCounter() {
            return this.counter;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.threadId == null ? 0 : this.threadId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LockValue other = (LockValue)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.threadId == null ? other.threadId != null : !this.threadId.equals(other.threadId));
        }
    }
}

