/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import com.lambdaworks.redis.RedisConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.redisson.RedissonObject;
import org.redisson.connection.ConnectionManager;
import org.redisson.core.RList;

public class RedissonList<V>
extends RedissonObject
implements RList<V> {
    private int batchSize = 50;
    private final ConnectionManager connectionManager;

    RedissonList(ConnectionManager connectionManager, String name) {
        super(name);
        this.connectionManager = connectionManager;
    }

    protected ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            int n = connection.llen(this.getName()).intValue();
            return n;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Iterator<V> iterator() {
        return this.listIterator();
    }

    @Override
    public Object[] toArray() {
        List<V> list = this.subList(0, this.size());
        return list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List<V> list = this.subList(0, this.size());
        return list.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.addAll((Collection<? extends V>)Collections.singleton(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        RedisConnection<String, Object> connection = this.connectionManager.connection();
        try {
            boolean bl = connection.lrem(this.getName(), 1L, o) > 0L;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.isEmpty()) {
            return false;
        }
        RedisConnection connection = this.connectionManager.connection();
        try {
            ArrayList copy = new ArrayList(c);
            int to = this.div(this.size(), this.batchSize);
            for (int i = 0; i < to; ++i) {
                List range = connection.lrange(this.getName(), i * this.batchSize, i * this.batchSize + this.batchSize - 1);
                Iterator iterator = copy.iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    int index = range.indexOf(obj);
                    if (index == -1) continue;
                    iterator.remove();
                }
            }
            boolean bl = copy.isEmpty();
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends V> c) {
        RedisConnection<String, Object> conn = this.connectionManager.connection();
        try {
            conn.rpush(this.getName(), c.toArray());
            boolean bl = true;
            return bl;
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> coll) {
        this.checkPosition(index);
        if (index < this.size()) {
            RedisConnection<String, Object> conn = this.connectionManager.connection();
            try {
                while (true) {
                    conn.watch(this.getName());
                    List tail = conn.lrange(this.getName(), index, this.size());
                    conn.multi();
                    conn.ltrim(this.getName(), 0L, index - 1);
                    conn.rpush(this.getName(), coll.toArray());
                    conn.rpush(this.getName(), tail.toArray());
                    if (conn.exec().size() != 3) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.connectionManager.release(conn);
            }
        }
        return this.addAll((Collection<? extends V>)coll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        RedisConnection<String, ?> conn = this.connectionManager.connection();
        try {
            boolean result = false;
            for (Object object : c) {
                boolean res;
                boolean bl = res = conn.lrem(this.getName(), 0L, object) > 0L;
                if (result) continue;
                result = res;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Iterator<V> iterator = this.iterator();
        while (iterator.hasNext()) {
            V object = iterator.next();
            if (c.contains(object)) continue;
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        RedisConnection conn = this.connectionManager.connection();
        try {
            conn.del(this.getName());
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(int index) {
        this.checkIndex(index);
        RedisConnection conn = this.connectionManager.connection();
        try {
            Object v = conn.lindex(this.getName(), index);
            return v;
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    private void checkIndex(int index) {
        int size = this.size();
        if (!this.isInRange(index, size)) {
            throw new IndexOutOfBoundsException("index: " + index + " but current size: " + size);
        }
    }

    private boolean isInRange(int index, int size) {
        return index >= 0 && index < size;
    }

    private void checkPosition(int index) {
        int size = this.size();
        if (!this.isPositionInRange(index, size)) {
            throw new IndexOutOfBoundsException("index: " + index + " but current size: " + size);
        }
    }

    private boolean isPositionInRange(int index, int size) {
        return index >= 0 && index <= size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V set(int index, V element) {
        this.checkIndex(index);
        RedisConnection<String, V> conn = this.connectionManager.connection();
        try {
            Object prev = conn.lindex(this.getName(), index);
            conn.lset(this.getName(), index, element);
            Object v = prev;
            return v;
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    @Override
    public void add(int index, V element) {
        this.addAll(index, (Collection<? extends V>)Collections.singleton(element));
    }

    private int div(int p, int q) {
        int div = p / q;
        int rem = p - q * div;
        if (rem == 0) {
            return div;
        }
        return div + 1;
    }

    @Override
    public V remove(int index) {
        this.checkIndex(index);
        RedisConnection<String, Object> conn = this.connectionManager.connection();
        try {
            if (index == 0) {
                Object v = conn.lpop(this.getName());
                return v;
            }
            while (true) {
                conn.watch(this.getName());
                Object prev = conn.lindex(this.getName(), index);
                List tail = conn.lrange(this.getName(), index + 1, this.size());
                conn.multi();
                conn.ltrim(this.getName(), 0L, index - 1);
                conn.rpush(this.getName(), tail.toArray());
                if (conn.exec().size() != 2) continue;
                Object v = prev;
                return v;
            }
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object o) {
        if (this.isEmpty()) {
            return -1;
        }
        RedisConnection conn = this.connectionManager.connection();
        try {
            int to = this.div(this.size(), this.batchSize);
            for (int i = 0; i < to; ++i) {
                List range = conn.lrange(this.getName(), i * this.batchSize, i * this.batchSize + this.batchSize - 1);
                int index = range.indexOf(o);
                if (index == -1) continue;
                int n = index + i * this.batchSize;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object o) {
        if (this.isEmpty()) {
            return -1;
        }
        RedisConnection conn = this.connectionManager.connection();
        try {
            int size = this.size();
            int to = this.div(size, this.batchSize);
            for (int i = 1; i <= to; ++i) {
                int startIndex = -i * this.batchSize;
                List range = conn.lrange(this.getName(), startIndex, size - (i - 1) * this.batchSize);
                int index = range.lastIndexOf(o);
                if (index == -1) continue;
                int n = Math.max(size + startIndex, 0) + index;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    @Override
    public ListIterator<V> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<V> listIterator(final int ind) {
        return new ListIterator<V>(){
            private int currentIndex;
            private boolean removeExecuted;
            {
                this.currentIndex = ind - 1;
            }

            @Override
            public boolean hasNext() {
                int size = RedissonList.this.size();
                return this.currentIndex + 1 < size && size > 0;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                ++this.currentIndex;
                this.removeExecuted = false;
                return RedissonList.this.get(this.currentIndex);
            }

            @Override
            public void remove() {
                if (this.removeExecuted) {
                    throw new IllegalStateException("Element been already deleted");
                }
                RedissonList.this.remove(this.currentIndex);
                --this.currentIndex;
                this.removeExecuted = true;
            }

            @Override
            public boolean hasPrevious() {
                int size = RedissonList.this.size();
                return this.currentIndex - 1 < size && size > 0 && this.currentIndex >= 0;
            }

            @Override
            public V previous() {
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                this.removeExecuted = false;
                Object res = RedissonList.this.get(this.currentIndex);
                --this.currentIndex;
                return res;
            }

            @Override
            public int nextIndex() {
                return this.currentIndex + 1;
            }

            @Override
            public int previousIndex() {
                return this.currentIndex;
            }

            @Override
            public void set(V e) {
                if (this.currentIndex >= RedissonList.this.size() - 1) {
                    throw new IllegalStateException();
                }
                RedissonList.this.set(this.currentIndex, e);
            }

            @Override
            public void add(V e) {
                RedissonList.this.add(this.currentIndex + 1, e);
                ++this.currentIndex;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<V> subList(int fromIndex, int toIndex) {
        int size = this.size();
        if (fromIndex < 0 || toIndex > size) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + " toIndex: " + toIndex + " size: " + size);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex: " + fromIndex + " toIndex: " + toIndex);
        }
        RedisConnection conn = this.connectionManager.connection();
        try {
            List list = conn.lrange(this.getName(), fromIndex, toIndex - 1);
            return list;
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    public String toString() {
        Iterator<V> it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            V e;
            sb.append((Object)((e = it.next()) == this ? "(this Collection)" : e));
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }
}

