/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.pubsub.RedisPubSubAdapter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.RedissonObject;
import org.redisson.connection.ConnectionManager;
import org.redisson.core.RCountDownLatch;
import org.redisson.misc.ReclosableLatch;

public class RedissonCountDownLatch
extends RedissonObject
implements RCountDownLatch {
    private final CountDownLatch subscribeLatch = new CountDownLatch(1);
    private final String groupName = "redisson_countdownlatch_";
    private static final Integer zeroCountMessage = 0;
    private static final Integer newCountMessage = 1;
    private final AtomicBoolean subscribeOnce = new AtomicBoolean();
    private final ReclosableLatch msg = new ReclosableLatch();
    private final ConnectionManager connectionManager;
    private ConnectionManager.PubSubEntry pubSubEntry;

    RedissonCountDownLatch(ConnectionManager connectionManager, String name) {
        super(name);
        this.connectionManager = connectionManager;
    }

    public void subscribe() {
        if (this.subscribeOnce.compareAndSet(false, true)) {
            RedisPubSubAdapter<String, Integer> listener = new RedisPubSubAdapter<String, Integer>(){

                @Override
                public void subscribed(String channel, long count) {
                    if (RedissonCountDownLatch.this.getChannelName().equals(channel)) {
                        RedissonCountDownLatch.this.subscribeLatch.countDown();
                    }
                }

                @Override
                public void message(String channel, Integer message) {
                    if (!RedissonCountDownLatch.this.getChannelName().equals(channel)) {
                        return;
                    }
                    if (message.equals(zeroCountMessage)) {
                        RedissonCountDownLatch.this.msg.open();
                    }
                    if (message.equals(newCountMessage)) {
                        RedissonCountDownLatch.this.msg.close();
                    }
                }
            };
            this.pubSubEntry = this.connectionManager.subscribe(listener, this.getChannelName());
        }
        try {
            this.subscribeLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void await() throws InterruptedException {
        while (this.getCount() > 0L) {
            this.msg.await();
        }
    }

    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        time = unit.toMillis(time);
        while (this.getCount() > 0L) {
            if (time <= 0L) {
                return false;
            }
            long current = System.currentTimeMillis();
            this.msg.await(time, TimeUnit.MILLISECONDS);
            long elapsed = System.currentTimeMillis() - current;
            time -= elapsed;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countDown() {
        if (this.getCount() <= 0L) {
            return;
        }
        RedisConnection<String, Integer> connection = this.connectionManager.connection();
        try {
            Long val = connection.decr(this.getName());
            if (val == 0L) {
                connection.multi();
                connection.del(this.getName());
                connection.publish(this.getChannelName(), zeroCountMessage);
                if (connection.exec().size() != 2) {
                    throw new IllegalStateException();
                }
            } else if (val < 0L) {
                connection.del(this.getName());
            }
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    private String getChannelName() {
        return "redisson_countdownlatch_" + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCount() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            Number val = (Number)connection.get(this.getName());
            if (val == null) {
                long l = 0L;
                return l;
            }
            long l = val.longValue();
            return l;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trySetCount(long count) {
        RedisConnection<String, Number> connection = this.connectionManager.connection();
        try {
            connection.watch(this.getName());
            Long oldValue = (Long)connection.get(this.getName());
            if (oldValue != null) {
                connection.discard();
                boolean bl = false;
                return bl;
            }
            connection.multi();
            connection.set(this.getName(), count);
            connection.publish(this.getChannelName(), newCountMessage);
            boolean bl = connection.exec().size() == 2;
            return bl;
        }
        finally {
            this.connectionManager.release(connection);
        }
    }

    @Override
    public void close() {
        this.connectionManager.unsubscribe(this.pubSubEntry, this.getChannelName());
    }
}

