/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import com.lambdaworks.redis.RedisConnection;
import org.redisson.RedissonObject;
import org.redisson.connection.ConnectionManager;
import org.redisson.core.RAtomicLong;

public class RedissonAtomicLong
extends RedissonObject
implements RAtomicLong {
    private final ConnectionManager connectionManager;

    RedissonAtomicLong(ConnectionManager connectionManager, String name) {
        super(name);
        this.connectionManager = connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addAndGet(long delta) {
        RedisConnection conn = this.connectionManager.connection();
        try {
            long l = conn.incrby(this.getName(), delta);
            return l;
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    @Override
    public boolean compareAndSet(long expect, long update) {
        RedisConnection<String, Long> conn = this.connectionManager.connection();
        try {
            while (true) {
                conn.watch(this.getName());
                Long value = (Long)conn.get(this.getName());
                if (value != expect) {
                    conn.discard();
                    boolean bl = false;
                    return bl;
                }
                conn.multi();
                conn.set(this.getName(), update);
                if (conn.exec().size() != 1) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long decrementAndGet() {
        RedisConnection conn = this.connectionManager.connection();
        try {
            long l = conn.decr(this.getName());
            return l;
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long get() {
        RedisConnection conn = this.connectionManager.connection();
        try {
            long l = (Long)conn.get(this.getName());
            return l;
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    @Override
    public long getAndAdd(long delta) {
        long next;
        long current;
        while (!this.compareAndSet(current = this.get(), next = current + delta)) {
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAndSet(long newValue) {
        RedisConnection<String, Long> conn = this.connectionManager.connection();
        try {
            long l = conn.getset(this.getName(), newValue);
            return l;
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long incrementAndGet() {
        RedisConnection conn = this.connectionManager.connection();
        try {
            long l = conn.incr(this.getName());
            return l;
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    @Override
    public long getAndIncrement() {
        return this.getAndAdd(1L);
    }

    @Override
    public long getAndDecrement() {
        return this.getAndAdd(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long newValue) {
        RedisConnection<String, Long> conn = this.connectionManager.connection();
        try {
            conn.set(this.getName(), newValue);
        }
        finally {
            this.connectionManager.release(conn);
        }
    }

    public String toString() {
        return Long.toString(this.get());
    }
}

