/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import com.lambdaworks.redis.RedisConnection;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.redisson.Config;
import org.redisson.RedissonAtomicLong;
import org.redisson.RedissonCountDownLatch;
import org.redisson.RedissonList;
import org.redisson.RedissonLock;
import org.redisson.RedissonMap;
import org.redisson.RedissonObject;
import org.redisson.RedissonQueue;
import org.redisson.RedissonSet;
import org.redisson.RedissonSortedSet;
import org.redisson.RedissonTopic;
import org.redisson.connection.ConnectionManager;
import org.redisson.core.RAtomicLong;
import org.redisson.core.RCountDownLatch;
import org.redisson.core.RList;
import org.redisson.core.RLock;
import org.redisson.core.RMap;
import org.redisson.core.RQueue;
import org.redisson.core.RSet;
import org.redisson.core.RSortedSet;
import org.redisson.core.RTopic;
import org.redisson.misc.ReferenceMap;

public class Redisson {
    ReferenceMap.RemoveValueListener listener = new ReferenceMap.RemoveValueListener(){

        public void onRemove(Object value) {
            if (value instanceof RedissonObject) {
                ((RedissonObject)value).close();
            }
        }
    };
    private final ConcurrentMap<String, RedissonCountDownLatch> latchesMap = new ReferenceMap<String, RedissonCountDownLatch>(ReferenceMap.ReferenceType.STRONG, ReferenceMap.ReferenceType.SOFT, this.listener);
    private final ConcurrentMap<String, RedissonTopic> topicsMap = new ReferenceMap<String, RedissonTopic>(ReferenceMap.ReferenceType.STRONG, ReferenceMap.ReferenceType.SOFT, this.listener);
    private final ConcurrentMap<String, RedissonLock> locksMap = new ReferenceMap<String, RedissonLock>(ReferenceMap.ReferenceType.STRONG, ReferenceMap.ReferenceType.SOFT, this.listener);
    private final ConcurrentMap<String, RedissonAtomicLong> atomicLongsMap = new ReferenceMap<String, RedissonAtomicLong>(ReferenceMap.ReferenceType.STRONG, ReferenceMap.ReferenceType.SOFT);
    private final ConcurrentMap<String, RedissonQueue> queuesMap = new ReferenceMap<String, RedissonQueue>(ReferenceMap.ReferenceType.STRONG, ReferenceMap.ReferenceType.SOFT);
    private final ConcurrentMap<String, RedissonSet> setsMap = new ReferenceMap<String, RedissonSet>(ReferenceMap.ReferenceType.STRONG, ReferenceMap.ReferenceType.SOFT);
    private final ConcurrentMap<String, RedissonSortedSet> sortedSetMap = new ReferenceMap<String, RedissonSortedSet>(ReferenceMap.ReferenceType.STRONG, ReferenceMap.ReferenceType.SOFT);
    private final ConcurrentMap<String, RedissonList> listsMap = new ReferenceMap<String, RedissonList>(ReferenceMap.ReferenceType.STRONG, ReferenceMap.ReferenceType.SOFT);
    private final ConcurrentMap<String, RedissonMap> mapsMap = new ReferenceMap<String, RedissonMap>(ReferenceMap.ReferenceType.STRONG, ReferenceMap.ReferenceType.SOFT);
    private final ConnectionManager connectionManager;
    private final Config config;
    private final UUID id = UUID.randomUUID();

    Redisson(Config config) {
        this.config = config;
        Config configCopy = new Config(config);
        this.connectionManager = new ConnectionManager(configCopy);
    }

    public static Redisson create() {
        Config config = new Config();
        config.addAddress("127.0.0.1:6379");
        return Redisson.create(config);
    }

    public static Redisson create(Config config) {
        return new Redisson(config);
    }

    public <V> RList<V> getList(String name) {
        RedissonList oldList;
        RedissonList list = (RedissonList)this.listsMap.get(name);
        if (list == null && (oldList = this.listsMap.putIfAbsent(name, list = new RedissonList(this.connectionManager, name))) != null) {
            list = oldList;
        }
        return list;
    }

    public <K, V> RMap<K, V> getMap(String name) {
        RedissonMap oldMap;
        RedissonMap map = (RedissonMap)this.mapsMap.get(name);
        if (map == null && (oldMap = this.mapsMap.putIfAbsent(name, map = new RedissonMap(this.connectionManager, name))) != null) {
            map = oldMap;
        }
        return map;
    }

    public RLock getLock(String name) {
        RedissonLock oldLock;
        RedissonLock lock = (RedissonLock)this.locksMap.get(name);
        if (lock == null && (oldLock = this.locksMap.putIfAbsent(name, lock = new RedissonLock(this.connectionManager, name, this.id))) != null) {
            lock = oldLock;
        }
        lock.subscribe();
        return lock;
    }

    public <V> RSet<V> getSet(String name) {
        RedissonSet oldSet;
        RedissonSet set = (RedissonSet)this.setsMap.get(name);
        if (set == null && (oldSet = this.setsMap.putIfAbsent(name, set = new RedissonSet(this.connectionManager, name))) != null) {
            set = oldSet;
        }
        return set;
    }

    public <V> RSortedSet<V> getSortedSet(String name) {
        RedissonSortedSet oldSet;
        RedissonSortedSet set = (RedissonSortedSet)this.sortedSetMap.get(name);
        if (set == null && (oldSet = this.sortedSetMap.putIfAbsent(name, set = new RedissonSortedSet(this.connectionManager, name))) != null) {
            set = oldSet;
        }
        return set;
    }

    public <M> RTopic<M> getTopic(String name) {
        RedissonTopic oldTopic;
        RedissonTopic topic = (RedissonTopic)this.topicsMap.get(name);
        if (topic == null && (oldTopic = this.topicsMap.putIfAbsent(name, topic = new RedissonTopic(this.connectionManager, name))) != null) {
            topic = oldTopic;
        }
        topic.subscribe();
        return topic;
    }

    public <V> RQueue<V> getQueue(String name) {
        RedissonQueue oldQueue;
        RedissonQueue queue = (RedissonQueue)this.queuesMap.get(name);
        if (queue == null && (oldQueue = this.queuesMap.putIfAbsent(name, queue = new RedissonQueue(this.connectionManager, name))) != null) {
            queue = oldQueue;
        }
        return queue;
    }

    public RAtomicLong getAtomicLong(String name) {
        RedissonAtomicLong oldAtomicLong;
        RedissonAtomicLong atomicLong = (RedissonAtomicLong)this.atomicLongsMap.get(name);
        if (atomicLong == null && (oldAtomicLong = this.atomicLongsMap.putIfAbsent(name, atomicLong = new RedissonAtomicLong(this.connectionManager, name))) != null) {
            atomicLong = oldAtomicLong;
        }
        return atomicLong;
    }

    public RCountDownLatch getCountDownLatch(String name) {
        RedissonCountDownLatch oldLatch;
        RedissonCountDownLatch latch = (RedissonCountDownLatch)this.latchesMap.get(name);
        if (latch == null && (oldLatch = this.latchesMap.putIfAbsent(name, latch = new RedissonCountDownLatch(this.connectionManager, name))) != null) {
            latch = oldLatch;
        }
        latch.subscribe();
        return latch;
    }

    public void shutdown() {
        this.connectionManager.shutdown();
    }

    public Config getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushdb() {
        RedisConnection connection = this.connectionManager.connection();
        try {
            connection.flushdb();
        }
        finally {
            this.connectionManager.release(connection);
        }
    }
}

