/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.redisson.codec.JsonJacksonCodec;
import org.redisson.codec.RedissonCodec;
import org.redisson.connection.LoadBalancer;
import org.redisson.connection.RoundRobinLoadBalancer;

public class Config {
    private LoadBalancer loadBalancer = new RoundRobinLoadBalancer();
    private RedissonCodec codec = new JsonJacksonCodec();
    private int subscriptionsPerConnection = 5;
    private int connectionPoolSize = 100;
    private String password;
    private List<URI> addresses = new ArrayList<URI>();

    public Config() {
    }

    Config(Config oldConf) {
        this.setCodec(oldConf.getCodec());
        this.setConnectionPoolSize(oldConf.getConnectionPoolSize());
        this.setPassword(oldConf.getPassword());
        this.setSubscriptionsPerConnection(oldConf.getSubscriptionsPerConnection());
        this.setAddresses(oldConf.getAddresses());
        this.setLoadBalancer(oldConf.getLoadBalancer());
    }

    public void setCodec(RedissonCodec codec) {
        this.codec = codec;
    }

    public RedissonCodec getCodec() {
        return this.codec;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSubscriptionsPerConnection(int subscriptionsPerConnection) {
        this.subscriptionsPerConnection = subscriptionsPerConnection;
    }

    public int getSubscriptionsPerConnection() {
        return this.subscriptionsPerConnection;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void addAddress(String ... addressesVar) {
        for (String address : addressesVar) {
            try {
                this.addresses.add(new URI("//" + address));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Can't parse " + address);
            }
        }
    }

    public List<URI> getAddresses() {
        return this.addresses;
    }

    void setAddresses(List<URI> addresses) {
        this.addresses = addresses;
    }

    public void setLoadBalancer(LoadBalancer loadBalancer) {
        this.loadBalancer = loadBalancer;
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }
}

