/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.protocol.Charsets;
import com.lambdaworks.redis.protocol.CommandOutput;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.LinkedList;

public class RedisStateMachine<K, V> {
    private static final ByteBuffer QUEUED = Charsets.buffer("QUEUED");
    private LinkedList<State> stack = new LinkedList();

    /*
     * Enabled aggressive block sorting
     */
    public boolean decode(ByteBuf buffer, CommandOutput<K, V, ?> output) {
        if (this.stack.isEmpty()) {
            this.stack.add(new State());
        }
        if (output == null) {
            return this.stack.isEmpty();
        }
        block8: while (!this.stack.isEmpty()) {
            State state = this.stack.peek();
            if (state.type == null) {
                if (!buffer.isReadable()) {
                    return this.stack.isEmpty();
                }
                state.type = this.readReplyType(buffer);
                buffer.markReaderIndex();
            }
            switch (state.type) {
                case SINGLE: {
                    ByteBuffer bytes = this.readLine(buffer);
                    if (bytes == null) {
                        return this.stack.isEmpty();
                    }
                    if (QUEUED.equals(bytes)) break;
                    output.set(bytes);
                    break;
                }
                case ERROR: {
                    ByteBuffer bytes = this.readLine(buffer);
                    if (bytes == null) {
                        return this.stack.isEmpty();
                    }
                    output.setError(bytes);
                    break;
                }
                case INTEGER: {
                    int end = this.findLineEnd(buffer);
                    if (end == -1) {
                        return this.stack.isEmpty();
                    }
                    output.set(this.readLong(buffer, buffer.readerIndex(), end));
                    break;
                }
                case BULK: {
                    int end = this.findLineEnd(buffer);
                    if (end == -1) {
                        return this.stack.isEmpty();
                    }
                    int length = (int)this.readLong(buffer, buffer.readerIndex(), end);
                    if (length == -1) {
                        output.set(null);
                        break;
                    }
                    state.type = State.Type.BYTES;
                    state.count = length + 2;
                    buffer.markReaderIndex();
                    continue block8;
                }
                case MULTI: {
                    int length;
                    int end;
                    if (state.count == -1) {
                        end = this.findLineEnd(buffer);
                        if (end == -1) {
                            return this.stack.isEmpty();
                        }
                        state.count = length = (int)this.readLong(buffer, buffer.readerIndex(), end);
                        buffer.markReaderIndex();
                    }
                    if (state.count <= 0) break;
                    --state.count;
                    this.stack.addFirst(new State());
                    continue block8;
                }
                case BYTES: {
                    ByteBuffer bytes = this.readBytes(buffer, state.count);
                    if (bytes == null) {
                        return this.stack.isEmpty();
                    }
                    output.set(bytes);
                }
            }
            buffer.markReaderIndex();
            this.stack.remove();
            output.complete(this.stack.size());
        }
        return this.stack.isEmpty();
    }

    private int findLineEnd(ByteBuf buffer) {
        int start = buffer.readerIndex();
        int index = buffer.indexOf(start, buffer.writerIndex(), (byte)10);
        return index > 0 && buffer.getByte(index - 1) == 13 ? index : -1;
    }

    private State.Type readReplyType(ByteBuf buffer) {
        switch (buffer.readByte()) {
            case 43: {
                return State.Type.SINGLE;
            }
            case 45: {
                return State.Type.ERROR;
            }
            case 58: {
                return State.Type.INTEGER;
            }
            case 36: {
                return State.Type.BULK;
            }
            case 42: {
                return State.Type.MULTI;
            }
        }
        throw new RedisException("Invalid first byte");
    }

    private long readLong(ByteBuf buffer, int start, int end) {
        int offset;
        long value = 0L;
        boolean negative = buffer.getByte(start) == 45;
        int n = offset = negative ? start + 1 : start;
        while (offset < end - 1) {
            int digit = buffer.getByte(offset++) - 48;
            value = value * 10L - (long)digit;
        }
        if (!negative) {
            value = -value;
        }
        buffer.readerIndex(end + 1);
        return value;
    }

    private ByteBuffer readLine(ByteBuf buffer) {
        ByteBuffer bytes = null;
        int end = this.findLineEnd(buffer);
        if (end > -1) {
            int start = buffer.readerIndex();
            bytes = buffer.nioBuffer(start, end - start - 1);
            buffer.readerIndex(end + 1);
        }
        return bytes;
    }

    private ByteBuffer readBytes(ByteBuf buffer, int count) {
        ByteBuffer bytes = null;
        if (buffer.readableBytes() >= count) {
            bytes = buffer.nioBuffer(buffer.readerIndex(), count - 2);
            buffer.readerIndex(buffer.readerIndex() + count);
        }
        return bytes;
    }

    static class State {
        Type type = null;
        int count = -1;

        State() {
        }

        static enum Type {
            SINGLE,
            ERROR,
            INTEGER,
            BULK,
            MULTI,
            BYTES;

        }
    }
}

