/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.protocol.CommandHandler;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.group.ChannelGroup;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public class ConnectionWatchdog
extends ChannelInboundHandlerAdapter
implements TimerTask {
    private Bootstrap bootstrap;
    private Channel channel;
    private ChannelGroup channels;
    private Timer timer;
    private boolean reconnect;
    private int attempts;

    public ConnectionWatchdog(Bootstrap bootstrap, ChannelGroup channels, Timer timer) {
        this.bootstrap = bootstrap;
        this.channels = channels;
        this.timer = timer;
    }

    public void setReconnect(boolean reconnect) {
        this.reconnect = reconnect;
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.channel = ctx.channel();
        this.channels.add((Object)this.channel);
        this.attempts = 0;
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.reconnect) {
            if (this.attempts < 8) {
                ++this.attempts;
            }
            int timeout = 2 << this.attempts;
            this.timer.newTimeout((TimerTask)this, (long)timeout, TimeUnit.MILLISECONDS);
        }
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.channel().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Timeout timeout) throws Exception {
        ChannelPipeline old = this.channel.pipeline();
        final CommandHandler handler = (CommandHandler)old.get(CommandHandler.class);
        final RedisAsyncConnection connection = (RedisAsyncConnection)old.get(RedisAsyncConnection.class);
        ChannelFuture connect = null;
        Bootstrap bootstrap = this.bootstrap;
        synchronized (bootstrap) {
            connect = ((Bootstrap)this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{this, handler, connection});
                }
            })).connect();
        }
        connect.sync();
    }
}

