/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.protocol.Command;
import com.lambdaworks.redis.protocol.RedisStateMachine;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.util.concurrent.BlockingQueue;

@ChannelHandler.Sharable
public class CommandHandler<K, V>
extends ChannelDuplexHandler {
    protected BlockingQueue<Command<K, V, ?>> queue;
    protected ByteBuf buffer;
    protected RedisStateMachine<K, V> rsm;

    public CommandHandler(BlockingQueue<Command<K, V, ?>> queue) {
        this.queue = queue;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.buffer = ctx.alloc().heapBuffer();
        this.rsm = new RedisStateMachine();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.buffer.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf input = (ByteBuf)msg;
        try {
            if (!input.isReadable()) {
                return;
            }
            this.buffer.discardReadBytes();
            this.buffer.writeBytes(input);
            this.decode(ctx, this.buffer);
        }
        finally {
            input.release();
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        Command cmd = (Command)msg;
        Channel channel = ctx.channel();
        ByteBuf buf = ctx.alloc().heapBuffer();
        cmd.encode(buf);
        ctx.write((Object)buf, promise);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer) throws InterruptedException {
        while (!this.queue.isEmpty() && this.rsm.decode(buffer, ((Command)this.queue.peek()).getOutput())) {
            Command<K, V, ?> cmd = this.queue.take();
            cmd.complete();
        }
    }
}

