/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis.protocol;

import com.lambdaworks.redis.RedisCommandInterruptedException;
import com.lambdaworks.redis.protocol.Charsets;
import com.lambdaworks.redis.protocol.CommandArgs;
import com.lambdaworks.redis.protocol.CommandOutput;
import com.lambdaworks.redis.protocol.CommandType;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Command<K, V, T>
implements Future<T> {
    private static final byte[] CRLF = "\r\n".getBytes(Charsets.ASCII);
    public final CommandType type;
    protected CommandArgs<K, V> args;
    protected CommandOutput<K, V, T> output;
    protected CountDownLatch latch;

    public Command(CommandType type, CommandOutput<K, V, T> output, CommandArgs<K, V> args, boolean multi) {
        this.type = type;
        this.output = output;
        this.args = args;
        this.latch = new CountDownLatch(multi ? 2 : 1);
    }

    @Override
    public boolean cancel(boolean ignored) {
        boolean cancelled = false;
        if (this.latch.getCount() == 1L) {
            this.latch.countDown();
            this.output = null;
            cancelled = true;
        }
        return cancelled;
    }

    @Override
    public boolean isCancelled() {
        return this.latch.getCount() == 0L && this.output == null;
    }

    @Override
    public boolean isDone() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public T get() {
        try {
            this.latch.await();
            return this.output.get();
        }
        catch (InterruptedException e) {
            throw new RedisCommandInterruptedException(e);
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            if (!this.latch.await(timeout, unit)) {
                throw new TimeoutException("Command timed out");
            }
        }
        catch (InterruptedException e) {
            throw new RedisCommandInterruptedException(e);
        }
        return this.output.get();
    }

    public boolean await(long timeout, TimeUnit unit) {
        try {
            return this.latch.await(timeout, unit);
        }
        catch (InterruptedException e) {
            throw new RedisCommandInterruptedException(e);
        }
    }

    public CommandOutput<K, V, T> getOutput() {
        return this.output;
    }

    public void complete() {
        this.latch.countDown();
    }

    void encode(ByteBuf buf) {
        buf.writeByte(42);
        Command.writeInt(buf, 1 + (this.args != null ? this.args.count() : 0));
        buf.writeBytes(CRLF);
        buf.writeByte(36);
        Command.writeInt(buf, this.type.bytes.length);
        buf.writeBytes(CRLF);
        buf.writeBytes(this.type.bytes);
        buf.writeBytes(CRLF);
        if (this.args != null) {
            buf.writeBytes(this.args.buffer());
        }
    }

    protected static void writeInt(ByteBuf buf, int value) {
        if (value < 10) {
            buf.writeByte(48 + value);
            return;
        }
        StringBuilder sb = new StringBuilder(8);
        while (value > 0) {
            int digit = value % 10;
            sb.append((char)(48 + digit));
            value /= 10;
        }
        for (int i = sb.length() - 1; i >= 0; --i) {
            buf.writeByte((int)sb.charAt(i));
        }
    }
}

