/*
 * Decompiled with CFR 0.152.
 */
package com.lambdaworks.redis;

import com.lambdaworks.redis.RedisAsyncConnection;
import com.lambdaworks.redis.RedisConnection;
import com.lambdaworks.redis.RedisException;
import com.lambdaworks.redis.codec.RedisCodec;
import com.lambdaworks.redis.codec.Utf8StringCodec;
import com.lambdaworks.redis.protocol.CommandHandler;
import com.lambdaworks.redis.protocol.ConnectionWatchdog;
import com.lambdaworks.redis.pubsub.PubSubCommandHandler;
import com.lambdaworks.redis.pubsub.RedisPubSubConnection;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class RedisClient {
    private EventLoopGroup group;
    private Bootstrap bootstrap;
    private HashedWheelTimer timer;
    private ChannelGroup channels;
    private long timeout;
    private TimeUnit unit;

    public RedisClient(String host) {
        this(host, 6379);
    }

    public RedisClient(String host, int port) {
        InetSocketAddress addr = new InetSocketAddress(host, port);
        this.group = new NioEventLoopGroup();
        this.bootstrap = ((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(this.group)).remoteAddress((SocketAddress)addr);
        this.setDefaultTimeout(60L, TimeUnit.SECONDS);
        this.channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        this.timer = new HashedWheelTimer();
        this.timer.start();
    }

    public void setDefaultTimeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
        this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)unit.toMillis(timeout)));
    }

    public RedisConnection<String, String> connect() {
        return this.connect(new Utf8StringCodec());
    }

    public RedisAsyncConnection<String, String> connectAsync() {
        return this.connectAsync(new Utf8StringCodec());
    }

    public RedisPubSubConnection<String, String> connectPubSub() {
        return this.connectPubSub(new Utf8StringCodec());
    }

    public <K, V> RedisConnection<K, V> connect(RedisCodec<K, V> codec) {
        return new RedisConnection<K, V>(this.connectAsync(codec));
    }

    public <K, V> RedisAsyncConnection<K, V> connectAsync(RedisCodec<K, V> codec) {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        CommandHandler handler = new CommandHandler(queue);
        RedisAsyncConnection connection = new RedisAsyncConnection(queue, codec, this.timeout, this.unit);
        return this.connect(handler, connection);
    }

    public <K, V> RedisPubSubConnection<K, V> connectPubSub(RedisCodec<K, V> codec) {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        PubSubCommandHandler handler = new PubSubCommandHandler(queue, codec);
        RedisPubSubConnection connection = new RedisPubSubConnection(queue, codec, this.timeout, this.unit);
        return this.connect(handler, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V, T extends RedisAsyncConnection<K, V>> T connect(final CommandHandler<K, V> handler, final T connection) {
        try {
            final ConnectionWatchdog watchdog = new ConnectionWatchdog(this.bootstrap, this.channels, (Timer)this.timer);
            ChannelFuture connect = null;
            Bootstrap bootstrap = this.bootstrap;
            synchronized (bootstrap) {
                connect = ((Bootstrap)this.bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addLast(new ChannelHandler[]{watchdog, handler, connection});
                    }
                })).connect();
            }
            connect.sync();
            watchdog.setReconnect(true);
            return connection;
        }
        catch (Throwable e) {
            throw new RedisException("Unable to connect", e);
        }
    }

    public void shutdown() {
        for (Channel c : this.channels) {
            ChannelPipeline pipeline = c.pipeline();
            RedisAsyncConnection connection = (RedisAsyncConnection)pipeline.get(RedisAsyncConnection.class);
            connection.close();
        }
        ChannelGroupFuture future = this.channels.close();
        future.awaitUninterruptibly();
        this.group.shutdownGracefully().syncUninterruptibly();
        this.timer.stop();
    }
}

