/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.Redisson;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanNullSafeReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.DoubleReplayConvertor;
import org.redisson.client.protocol.convertor.EmptyListConvertor;
import org.redisson.client.protocol.convertor.VoidReplayConvertor;
import org.redisson.client.protocol.decoder.CodecDecoder;
import org.redisson.client.protocol.decoder.GeoDistanceDecoder;
import org.redisson.client.protocol.decoder.ListFirstObjectDecoder;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.ListScanResultReplayDecoder;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.ObjectSetReplayDecoder;
import org.redisson.client.protocol.decoder.TimeLongObjectDecoder;
import org.redisson.command.BatchPromise;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.spring.data.connection.BinaryConvertor;
import org.redisson.spring.data.connection.DataTypeConvertor;
import org.redisson.spring.data.connection.DistanceConvertor;
import org.redisson.spring.data.connection.GeoResultsDecoder;
import org.redisson.spring.data.connection.ListMergeDecoder;
import org.redisson.spring.data.connection.ObjectListReplayDecoder2;
import org.redisson.spring.data.connection.ObjectMapEntryReplayDecoder;
import org.redisson.spring.data.connection.PointDecoder;
import org.redisson.spring.data.connection.PropertiesDecoder;
import org.redisson.spring.data.connection.PropertiesListDecoder;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.redisson.spring.data.connection.RedissonStreamCommands;
import org.redisson.spring.data.connection.RedissonSubscription;
import org.redisson.spring.data.connection.ScoredSortedListReplayDecoder;
import org.redisson.spring.data.connection.ScoredSortedSetReplayDecoder;
import org.redisson.spring.data.connection.ScoredSortedSetReplayDecoderV2;
import org.redisson.spring.data.connection.ScoredSortedSingleBlockingReplayDecoder;
import org.redisson.spring.data.connection.ScoredSortedSingleReplayDecoder;
import org.redisson.spring.data.connection.SecondsConvertor;
import org.redisson.spring.data.connection.SingleMapEntryDecoder;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.AbstractRedisConnection;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.ExpirationOptions;
import org.springframework.data.redis.connection.Limit;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisCommands;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.ValueEncoding;
import org.springframework.data.redis.connection.zset.Aggregate;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.connection.zset.Weights;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.KeyBoundCursor;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.domain.geo.BoxShape;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.data.redis.domain.geo.RadiusShape;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class RedissonConnection
extends AbstractRedisConnection {
    private boolean closed;
    protected final Redisson redisson;
    private boolean filterOkResponses = false;
    CommandAsyncExecutor executorService;
    private RedissonSubscription subscription;
    private static final RedisStrictCommand<DataType> TYPE = new RedisStrictCommand("TYPE", (Convertor)new DataTypeConvertor());
    private static final RedisStrictCommand<Set<byte[]>> KEYS = new RedisStrictCommand("KEYS", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisStrictCommand<Boolean> EXPIRE = new RedisStrictCommand("EXPIRE", (Convertor)new BooleanReplayConvertor());
    private static final RedisStrictCommand<Boolean> EXPIREAT = new RedisStrictCommand("EXPIREAT", (Convertor)new BooleanReplayConvertor());
    private static final RedisStrictCommand<Long> TTL = new RedisStrictCommand("TTL");
    private static final RedisCommand<Long> SORT_TO = new RedisCommand("SORT");
    private static final RedisCommand<List<Object>> MGET = new RedisCommand("MGET", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<Boolean> SET = new RedisCommand("SET", (Convertor)new BooleanNullSafeReplayConvertor());
    private static final RedisCommand<Boolean> SETEX = new RedisCommand("SETEX", (Convertor)new BooleanReplayConvertor());
    private static final RedisCommand<Boolean> PSETEX = new RedisCommand("PSETEX", (Convertor)new BooleanReplayConvertor());
    private static final RedisCommand<Boolean> MSET = new RedisCommand("MSET", (Convertor)new BooleanReplayConvertor());
    private static final RedisStrictCommand<Long> DECRBY = new RedisStrictCommand("DECRBY");
    private static final RedisStrictCommand<Long> APPEND = new RedisStrictCommand("APPEND");
    private static final RedisCommand<Object> GETRANGE = new RedisCommand("GETRANGE");
    private static final RedisCommand<Void> SETRANGE = new RedisCommand("SETRANGE", (Convertor)new VoidReplayConvertor());
    private static final RedisStrictCommand<Long> BITOP = new RedisStrictCommand("BITOP");
    private static final RedisStrictCommand<Long> RPUSH = new RedisStrictCommand("RPUSH");
    private static final RedisStrictCommand<Long> LPUSH = new RedisStrictCommand("LPUSH");
    private static final RedisStrictCommand<Long> RPUSHX = new RedisStrictCommand("RPUSHX");
    private static final RedisStrictCommand<Long> LPUSHX = new RedisStrictCommand("LPUSHX");
    private static final RedisStrictCommand<Long> LLEN = new RedisStrictCommand("LLEN");
    private static final RedisStrictCommand<Long> LINSERT = new RedisStrictCommand("LINSERT");
    private final List<String> commandsToRemove = Arrays.asList("SET", "RESTORE", "LTRIM", "SETEX", "SETRANGE", "FLUSHDB", "LSET", "MSET", "HMSET", "RENAME");
    private final List<Integer> indexToRemove = new ArrayList<Integer>();
    private int index = -1;
    private static final RedisStrictCommand<Long> LREM = new RedisStrictCommand("LREM");
    private static final RedisCommand<List<Long>> LPOS = new RedisCommand("LPOS", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<Long> SADD = new RedisCommand("SADD");
    private static final RedisStrictCommand<Long> SREM = new RedisStrictCommand("SREM");
    private static final RedisCommand<List<Object>> SPOP = new RedisCommand("SPOP", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisStrictCommand<Long> SCARD = new RedisStrictCommand("SCARD");
    private static final RedisCommand<List<Object>> SRANDMEMBER = new RedisCommand("SRANDMEMBER", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<Set<Object>> ZRANGE = new RedisCommand("ZRANGE", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZRANGE_ENTRY = new RedisCommand("ZRANGE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZRANGE_ENTRY_V2 = new RedisCommand("ZRANGE", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ObjectSetReplayDecoder(), new ScoredSortedSetReplayDecoderV2()}));
    private static final RedisCommand<Set<Tuple>> ZRANGEBYSCORE = new RedisCommand("ZRANGEBYSCORE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZRANGEBYSCORE_V2 = new RedisCommand("ZRANGEBYSCORE", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ObjectSetReplayDecoder(), new ScoredSortedSetReplayDecoderV2()}));
    private static final RedisCommand<Set<Object>> ZREVRANGE = new RedisCommand("ZREVRANGE", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZREVRANGE_ENTRY = new RedisCommand("ZREVRANGE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZREVRANGE_ENTRY_V2 = new RedisCommand("ZREVRANGE", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ObjectSetReplayDecoder(), new ScoredSortedSetReplayDecoderV2()}));
    private static final RedisCommand<Set<byte[]>> ZREVRANGEBYSCORE = new RedisCommand("ZREVRANGEBYSCORE", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZREVRANGEBYSCOREWITHSCORES = new RedisCommand("ZREVRANGEBYSCORE", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZREVRANGEBYSCOREWITHSCORES_V2 = new RedisCommand("ZREVRANGEBYSCORE", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ObjectSetReplayDecoder(), new ScoredSortedSetReplayDecoderV2()}));
    private static final RedisStrictCommand<Long> ZCOUNT = new RedisStrictCommand("ZCOUNT");
    private static final RedisStrictCommand<Long> ZREMRANGEBYRANK = new RedisStrictCommand("ZREMRANGEBYRANK");
    private static final RedisStrictCommand<Long> ZREMRANGEBYSCORE = new RedisStrictCommand("ZREMRANGEBYSCORE");
    private static final RedisStrictCommand<Long> ZUNIONSTORE = new RedisStrictCommand("ZUNIONSTORE");
    private static final RedisStrictCommand<Long> ZINTERSTORE = new RedisStrictCommand("ZINTERSTORE");
    private static final RedisCommand<ListScanResult<Object>> ZSCAN = new RedisCommand("ZSCAN", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ListScanResultReplayDecoder(), new ScoredSortedListReplayDecoder()}));
    private static final RedisCommand<Set<Object>> ZRANGEBYLEX = new RedisCommand("ZRANGEBYLEX", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<List<Object>> HMGET = new RedisCommand("HMGET", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<Long> HINCRBY = new RedisCommand("HINCRBY");
    private static final RedisCommand<Double> HINCRBYFLOAT = new RedisCommand("HINCRBYFLOAT", (Convertor)new DoubleReplayConvertor());
    private static final RedisStrictCommand<Long> HLEN = new RedisStrictCommand("HLEN");
    private static final RedisCommand<Object> ECHO = new RedisCommand("ECHO");
    private static final RedisStrictCommand<Void> SAVE = new RedisStrictCommand("SAVE", (Convertor)new VoidReplayConvertor());
    private static final RedisStrictCommand<Properties> INFO_DEFAULT = new RedisStrictCommand("INFO", "DEFAULT", (MultiDecoder)new ObjectDecoder((Decoder)new PropertiesDecoder()));
    private static final RedisStrictCommand<Properties> INFO = new RedisStrictCommand("INFO", (MultiDecoder)new ObjectDecoder((Decoder)new PropertiesDecoder()));
    private static final RedisStrictCommand<Properties> CONFIG_GET = new RedisStrictCommand("CONFIG", "GET", (MultiDecoder)new PropertiesListDecoder());
    private static final RedisCommand<List<Object>> GEOHASH = new RedisCommand("GEOHASH", (MultiDecoder)new ObjectListReplayDecoder());
    private final MultiDecoder<Map<Object, Object>> geoDecoder = new ListMultiDecoder2(new MultiDecoder[]{new ObjectListReplayDecoder2(), new PointDecoder()});
    private final MultiDecoder<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> postitionDecoder = new ListMultiDecoder2(new MultiDecoder[]{new GeoResultsDecoder(), new CodecDecoder(), new PointDecoder(), new ObjectListReplayDecoder()});
    private static final RedisCommand<GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> GEORADIUSBYMEMBER = new RedisCommand("GEORADIUSBYMEMBER_RO", (MultiDecoder)new GeoResultsDecoder());
    private static final RedisCommand<Long> PFADD = new RedisCommand("PFADD");
    private static final RedisCommand<Long> HSTRLEN = new RedisCommand("HSTRLEN");
    private static final RedisStrictCommand<List<Object>> BITFIELD = new RedisStrictCommand("BITFIELD", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisStrictCommand<ValueEncoding> OBJECT_ENCODING = new RedisStrictCommand("OBJECT", "ENCODING", (Convertor)new Convertor<ValueEncoding>(){

        public ValueEncoding convert(Object obj) {
            return ValueEncoding.of((String)((String)obj));
        }
    });
    private static final RedisStrictCommand<Duration> OBJECT_IDLETIME = new RedisStrictCommand("OBJECT", "IDLETIME", (Convertor)new Convertor<Duration>(){

        public Duration convert(Object obj) {
            return Duration.ofSeconds((Long)obj);
        }
    });
    private static final RedisStrictCommand<Long> OBJECT_REFCOUNT = new RedisStrictCommand("OBJECT", "REFCOUNT");
    private static final RedisStrictCommand<Long> BITPOS = new RedisStrictCommand("BITPOS");
    private static final RedisCommand<List<Object>> ZRANDMEMBER_LIST = new RedisCommand("ZRANDMEMBER", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<Tuple> ZRANDMEMBER_SCORE = new RedisCommand("ZRANDMEMBER", (MultiDecoder)new ScoredSortedSingleReplayDecoder());
    private static final RedisCommand<List<Tuple>> ZRANDMEMBER_SCORE_LIST = new RedisCommand("ZRANDMEMBER", (MultiDecoder)new ScoredSortedListReplayDecoder());
    private static final RedisCommand<Tuple> ZPOPMIN = new RedisCommand("ZPOPMIN", (MultiDecoder)new ScoredSortedSingleReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZPOPMIN_FOR_SET = new RedisCommand("ZPOPMIN", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Tuple> BZPOPMIN = new RedisCommand("BZPOPMIN", (MultiDecoder)new ScoredSortedSingleBlockingReplayDecoder());
    private static final RedisCommand<Tuple> ZPOPMAX = new RedisCommand("ZPOPMAX", (MultiDecoder)new ScoredSortedSingleReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZPOPMAX_FOR_SET = new RedisCommand("ZPOPMAX", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Tuple> BZPOPMAX = new RedisCommand("BZPOPMAX", (MultiDecoder)new ScoredSortedSingleBlockingReplayDecoder());
    private static final RedisCommand<List<Object>> ZMSCORE = new RedisCommand("ZMSCORE", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<Set<Object>> ZDIFF = new RedisCommand("ZDIFF", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZDIFF_SCORE = new RedisCommand("ZDIFF", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisStrictCommand<Long> ZDIFFSTORE = new RedisStrictCommand("ZDIFFSTORE");
    private static final RedisCommand<Set<Object>> ZINTER = new RedisCommand("ZINTER", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZINTER_SCORE = new RedisCommand("ZINTER", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Set<Object>> ZUNION = new RedisCommand("ZUNION", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisCommand<Set<Tuple>> ZUNION_SCORE = new RedisCommand("ZUNION", (MultiDecoder)new ScoredSortedSetReplayDecoder());
    private static final RedisCommand<Object> HRANDFIELD = new RedisCommand("HRANDFIELD");
    private static final RedisCommand<Map.Entry<Object, Object>> HRANDFIELD_SINGLE_V2 = new RedisCommand("HRANDFIELD", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ListFirstObjectDecoder(), new SingleMapEntryDecoder()}));
    private static final RedisCommand<Map.Entry<Object, Object>> HRANDFIELD_SINGLE = new RedisCommand("HRANDFIELD", (MultiDecoder)new SingleMapEntryDecoder());
    private static final RedisCommand<List<Object>> HRANDFIELD_LIST = new RedisCommand("HRANDFIELD", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<List<Map.Entry<Object, Object>>> HRANDFIELD_VALUES_V2 = new RedisCommand("HRANDFIELD", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ListMergeDecoder(), new ObjectMapEntryReplayDecoder()}), (Convertor)new EmptyListConvertor());
    private static final RedisCommand<List<Map.Entry<Object, Object>>> HRANDFIELD_VALUES = new RedisCommand("HRANDFIELD", (MultiDecoder)new ObjectMapEntryReplayDecoder(), (Convertor)new EmptyListConvertor());
    private static final RedisCommand<List<Boolean>> SMISMEMBER = new RedisCommand("SMISMEMBER", (MultiDecoder)new ObjectListReplayDecoder(), (Convertor)new BooleanReplayConvertor());
    private static final RedisCommand<Object> GETEX = new RedisCommand("GETEX");
    private static final RedisCommand<Object> GETDEL = new RedisCommand("GETDEL");
    private static final RedisCommand<Set<byte[]>> ZREVRANGEBYLEX = new RedisCommand("ZREVRANGEBYLEX", (MultiDecoder)new ObjectSetReplayDecoder());
    private static final RedisStrictCommand<Long> ZREMRANGEBYLEX = new RedisStrictCommand("ZREMRANGEBYLEX");
    private static final RedisStrictCommand<Long> ZLEXCOUNT = new RedisStrictCommand("ZLEXCOUNT");
    public static final RedisCommand<Long> ZRANGESTORE = new RedisCommand("ZRANGESTORE");
    private static final RedisStrictCommand<Void> REPLICAOF = new RedisStrictCommand("REPLICAOF");
    private static final RedisCommand<Object> SET_VALUE = new RedisCommand("SET");
    private static final RedisCommand<List<Long>> HEXPIRE = new RedisCommand("HEXPIRE", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisStrictCommand<List<Long>> HPEXPIRE = new RedisStrictCommand("HPEXPIRE", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<List<Long>> HEXPIREAT = new RedisCommand("HEXPIREAT", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisStrictCommand<List<Long>> HPEXPIREAT = new RedisStrictCommand("HPEXPIREAT", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisStrictCommand<List<Long>> HPERSIST = new RedisStrictCommand("HPERSIST", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<List<Long>> HTTL = new RedisCommand("HTTL", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<List<Long>> HPTTL = new RedisCommand("HPTTL", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<List<Object>> HGETDEL = new RedisCommand("HGETDEL", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisCommand<List<Object>> HGETEX = new RedisCommand("HGETEX", (MultiDecoder)new ObjectListReplayDecoder());
    private static final RedisStrictCommand<Boolean> HSETEX = new RedisStrictCommand("HSETEX", (Convertor)new BooleanReplayConvertor());
    private static final RedisStrictCommand<Long> SINTERCARD = new RedisStrictCommand("SINTERCARD");

    public RedissonConnection(RedissonClient redisson) {
        this.redisson = (Redisson)redisson;
        this.executorService = this.redisson.getCommandExecutor();
    }

    public RedissonConnection(RedissonClient redisson, boolean filterOkResponses) {
        this.redisson = (Redisson)redisson;
        this.filterOkResponses = filterOkResponses;
        this.executorService = this.redisson.getCommandExecutor();
    }

    public boolean isFilterOkResponses() {
        return this.filterOkResponses;
    }

    public void setFilterOkResponses(boolean filterOkResponses) {
        this.filterOkResponses = filterOkResponses;
    }

    public void close() throws DataAccessException {
        CommandBatchService es;
        super.close();
        if (this.isQueueing() && !(es = (CommandBatchService)this.executorService).isExecuted()) {
            this.discard();
        }
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Object getNativeConnection() {
        return this.redisson;
    }

    public boolean isQueueing() {
        if (this.executorService instanceof CommandBatchService) {
            CommandBatchService es = (CommandBatchService)this.executorService;
            return es.getOptions().getExecutionMode() == BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC;
        }
        return false;
    }

    public boolean isPipelined() {
        if (this.executorService instanceof CommandBatchService) {
            CommandBatchService es = (CommandBatchService)this.executorService;
            return es.getOptions().getExecutionMode() == BatchOptions.ExecutionMode.IN_MEMORY || es.getOptions().getExecutionMode() == BatchOptions.ExecutionMode.IN_MEMORY_ATOMIC;
        }
        return false;
    }

    public boolean isPipelinedAtomic() {
        if (this.executorService instanceof CommandBatchService) {
            CommandBatchService es = (CommandBatchService)this.executorService;
            return es.getOptions().getExecutionMode() == BatchOptions.ExecutionMode.IN_MEMORY_ATOMIC;
        }
        return false;
    }

    public void openPipeline() {
        BatchOptions options = BatchOptions.defaults().executionMode(BatchOptions.ExecutionMode.IN_MEMORY);
        this.executorService = this.executorService.createCommandBatchService(options);
    }

    public List<Object> closePipeline() throws RedisPipelineException {
        if (this.isPipelined()) {
            CommandBatchService es = (CommandBatchService)this.executorService;
            try {
                BatchResult result = es.execute();
                this.filterResults(result);
                if (this.isPipelinedAtomic()) {
                    List<Object> list = Arrays.asList(result.getResponses());
                    return list;
                }
                List list = result.getResponses();
                return list;
            }
            catch (Exception ex) {
                throw new RedisPipelineException(ex);
            }
            finally {
                this.resetConnection();
            }
        }
        return Collections.emptyList();
    }

    public Object execute(String command, byte[] ... args) {
        for (Method method : ((Object)((Object)this)).getClass().getDeclaredMethods()) {
            if (!method.getName().equalsIgnoreCase(command) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != args.length) continue;
            try {
                Object t = this.execute(method, args);
                if (t instanceof String) {
                    return ((String)t).getBytes();
                }
                return t;
            }
            catch (IllegalArgumentException e) {
                if (this.isPipelined()) {
                    throw new RedisPipelineException((Exception)e);
                }
                throw new InvalidDataAccessApiUsageException(e.getMessage(), (Throwable)e);
            }
        }
        throw new UnsupportedOperationException();
    }

    private Object execute(Method method, byte[] ... args) {
        if (method.getParameterTypes().length > 0 && method.getParameterTypes()[0] == byte[][].class) {
            return ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this), (Object[])args);
        }
        if (args == null) {
            return ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this));
        }
        return ReflectionUtils.invokeMethod((Method)method, (Object)((Object)this), (Object[])Arrays.asList(args).toArray());
    }

    <V> V syncFuture(RFuture<V> future) {
        try {
            return (V)this.executorService.get(future);
        }
        catch (Exception ex) {
            throw this.transform(ex);
        }
    }

    protected RuntimeException transform(Exception ex) {
        DataAccessException exception = RedissonConnectionFactory.EXCEPTION_TRANSLATION.translate(ex);
        if (exception != null) {
            return exception;
        }
        return new RedisSystemException(ex.getMessage(), (Throwable)ex);
    }

    public Boolean exists(byte[] key) {
        return (Boolean)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.EXISTS, new Object[]{key});
    }

    public Long del(byte[] ... keys) {
        return (Long)this.write(keys[0], (Codec)LongCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.DEL, Arrays.asList(keys).toArray());
    }

    public Long unlink(byte[] ... keys) {
        return (Long)this.write(keys[0], (Codec)LongCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.UNLINK, Arrays.asList(keys).toArray());
    }

    public DataType type(byte[] key) {
        return (DataType)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)TYPE, new Object[]{key});
    }

    public Set<byte[]> keys(byte[] pattern) {
        if (this.isQueueing()) {
            return (Set)this.read(null, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand<?>)KEYS, new Object[]{pattern});
        }
        List futures = this.executorService.readAllAsync((Codec)ByteArrayCodec.INSTANCE, KEYS, new Object[]{pattern});
        CompletableFuture<Void> ff = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletableFuture future = ((CompletableFuture)ff.thenApply(r -> futures.stream().flatMap(f -> ((Set)f.getNow(new HashSet())).stream()).collect(Collectors.toSet()))).toCompletableFuture();
        return (Set)this.sync((RFuture)new CompletableFutureWrapper(future));
    }

    public Cursor<byte[]> scan(ScanOptions options) {
        return new ScanCursor<byte[]>(Cursor.CursorId.initial(), options){
            private RedisClient client;
            private Iterator<MasterSlaveEntry> entries;
            private MasterSlaveEntry entry;
            {
                this.entries = RedissonConnection.this.executorService.getConnectionManager().getEntrySet().iterator();
                this.entry = this.entries.next();
            }

            protected ScanIteration<byte[]> doScan(Cursor.CursorId cursorId, ScanOptions options) {
                if (RedissonConnection.this.isQueueing() || RedissonConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                if (this.entry == null) {
                    return null;
                }
                ArrayList<Object> args = new ArrayList<Object>();
                if (Cursor.CursorId.of((String)"101010101010101010").equals((Object)cursorId)) {
                    cursorId = Cursor.CursorId.initial();
                }
                args.add(cursorId);
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonConnection.this.executorService.readAsync(this.client, this.entry, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SCAN, args.toArray());
                ListScanResult res = (ListScanResult)RedissonConnection.this.syncFuture(f);
                String pos = res.getPos();
                this.client = res.getRedisClient();
                if (Cursor.CursorId.isInitial((String)pos)) {
                    if (this.entries.hasNext()) {
                        pos = "101010101010101010";
                        this.entry = this.entries.next();
                        this.client = null;
                    } else {
                        this.entry = null;
                    }
                }
                return new ScanIteration(Cursor.CursorId.of((String)pos), (Collection)res.getValues());
            }
        }.open();
    }

    public byte[] randomKey() {
        if (this.isQueueing()) {
            return (byte[])this.read(null, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.RANDOM_KEY, new Object[0]);
        }
        RFuture f = this.executorService.readRandomAsync((Codec)ByteArrayCodec.INSTANCE, (RedisCommand)org.redisson.client.protocol.RedisCommands.RANDOM_KEY, new Object[0]);
        return (byte[])this.sync(f);
    }

    public void rename(byte[] oldName, byte[] newName) {
        this.write(oldName, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.RENAME, oldName, newName);
    }

    public Boolean renameNX(byte[] oldName, byte[] newName) {
        return (Boolean)this.write(oldName, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.RENAMENX, oldName, newName);
    }

    public Boolean expire(byte[] key, long seconds) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)EXPIRE, key, seconds);
    }

    public Boolean pExpire(byte[] key, long millis) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.PEXPIRE, key, millis);
    }

    public Boolean expireAt(byte[] key, long unixTime) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)EXPIREAT, key, unixTime);
    }

    public Boolean pExpireAt(byte[] key, long unixTimeInMillis) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.PEXPIREAT, key, unixTimeInMillis);
    }

    public Boolean persist(byte[] key) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.PERSIST, new Object[]{key});
    }

    public Boolean move(byte[] key, int dbIndex) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.MOVE, key, dbIndex);
    }

    public Long ttl(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)TTL, new Object[]{key});
    }

    protected <T> T sync(RFuture<T> f) {
        if (this.isPipelined()) {
            return null;
        }
        if (this.isQueueing()) {
            ((BatchPromise)f.toCompletableFuture()).getSentPromise().join();
            return null;
        }
        return this.syncFuture(f);
    }

    public Long ttl(byte[] key, TimeUnit timeUnit) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)new RedisStrictCommand("TTL", (Convertor)new SecondsConvertor(timeUnit, TimeUnit.SECONDS){

            @Override
            public Long convert(Object obj) {
                if ((Long)obj < 0L) {
                    return (Long)obj;
                }
                return super.convert(obj);
            }
        }), new Object[]{key});
    }

    public Long pTtl(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.PTTL, new Object[]{key});
    }

    public Long pTtl(byte[] key, TimeUnit timeUnit) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)new RedisStrictCommand("PTTL", (Convertor)new SecondsConvertor(timeUnit, TimeUnit.MILLISECONDS){

            @Override
            public Long convert(Object obj) {
                if ((Long)obj < 0L) {
                    return (Long)obj;
                }
                return super.convert(obj);
            }
        }), new Object[]{key});
    }

    public List<byte[]> sort(byte[] key, SortParameters sortParams) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        if (sortParams != null) {
            Boolean isAlpha;
            if (sortParams.getByPattern() != null) {
                params.add("BY");
                params.add(sortParams.getByPattern());
            }
            if (sortParams.getLimit() != null) {
                params.add("LIMIT");
                if (sortParams.getLimit().getStart() != -1L) {
                    params.add(sortParams.getLimit().getStart());
                }
                if (sortParams.getLimit().getCount() != -1L) {
                    params.add(sortParams.getLimit().getCount());
                }
            }
            if (sortParams.getGetPattern() != null) {
                for (byte[] pattern : sortParams.getGetPattern()) {
                    params.add("GET");
                    params.add(pattern);
                }
            }
            if (sortParams.getOrder() != null) {
                params.add(sortParams.getOrder());
            }
            if ((isAlpha = sortParams.isAlphabetic()) != null && isAlpha.booleanValue()) {
                params.add("ALPHA");
            }
        }
        return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SORT_LIST, params.toArray());
    }

    public Long sort(byte[] key, SortParameters sortParams, byte[] storeKey) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        if (sortParams != null) {
            Boolean isAlpha;
            if (sortParams.getByPattern() != null) {
                params.add("BY");
                params.add(sortParams.getByPattern());
            }
            if (sortParams.getLimit() != null) {
                params.add("LIMIT");
                if (sortParams.getLimit().getStart() != -1L) {
                    params.add(sortParams.getLimit().getStart());
                }
                if (sortParams.getLimit().getCount() != -1L) {
                    params.add(sortParams.getLimit().getCount());
                }
            }
            if (sortParams.getGetPattern() != null) {
                for (byte[] pattern : sortParams.getGetPattern()) {
                    params.add("GET");
                    params.add(pattern);
                }
            }
            if (sortParams.getOrder() != null) {
                params.add(sortParams.getOrder());
            }
            if ((isAlpha = sortParams.isAlphabetic()) != null && isAlpha.booleanValue()) {
                params.add("ALPHA");
            }
        }
        params.add("STORE");
        params.add(storeKey);
        return (Long)this.read(key, (Codec)ByteArrayCodec.INSTANCE, SORT_TO, params.toArray());
    }

    public byte[] dump(byte[] key) {
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.DUMP, new Object[]{key});
    }

    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue) {
        this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.RESTORE, key, ttlInMillis, serializedValue);
    }

    public byte[] get(byte[] key) {
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.GET, new Object[]{key});
    }

    public byte[] getSet(byte[] key, byte[] value) {
        return (byte[])this.write(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.GETSET, key, value);
    }

    public List<byte[]> mGet(byte[] ... keys) {
        return (List)this.read(keys[0], (Codec)ByteArrayCodec.INSTANCE, MGET, Arrays.asList(keys).toArray());
    }

    public Boolean set(byte[] key, byte[] value) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value);
    }

    public Boolean set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        if (expiration == null) {
            return this.set(key, value);
        }
        if (expiration.isPersistent()) {
            if (option == null || option == RedisStringCommands.SetOption.UPSERT) {
                return this.set(key, value);
            }
            if (option == RedisStringCommands.SetOption.SET_IF_ABSENT) {
                return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value, "NX");
            }
            if (option == RedisStringCommands.SetOption.SET_IF_PRESENT) {
                return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value, "XX");
            }
        } else {
            if (option == null || option == RedisStringCommands.SetOption.UPSERT) {
                return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value, "PX", expiration.getExpirationTimeInMilliseconds());
            }
            if (option == RedisStringCommands.SetOption.SET_IF_ABSENT) {
                return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value, "PX", expiration.getExpirationTimeInMilliseconds(), "NX");
            }
            if (option == RedisStringCommands.SetOption.SET_IF_PRESENT) {
                return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, SET, key, value, "PX", expiration.getExpirationTimeInMilliseconds(), "XX");
            }
        }
        throw new IllegalArgumentException();
    }

    public Boolean setNX(byte[] key, byte[] value) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SETNX, key, value);
    }

    public Boolean setEx(byte[] key, long seconds, byte[] value) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, SETEX, key, seconds, value);
    }

    public Boolean pSetEx(byte[] key, long milliseconds, byte[] value) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, PSETEX, key, milliseconds, value);
    }

    public Boolean mSet(Map<byte[], byte[]> tuple) {
        List<byte[]> params = this.convert(tuple);
        return (Boolean)this.write(tuple.keySet().iterator().next(), (Codec)StringCodec.INSTANCE, MSET, params.toArray());
    }

    protected List<byte[]> convert(Map<byte[], byte[]> tuple) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(tuple.size() * 2);
        for (Map.Entry<byte[], byte[]> entry : tuple.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        return params;
    }

    public Boolean mSetNX(Map<byte[], byte[]> tuple) {
        List<byte[]> params = this.convert(tuple);
        return (Boolean)this.write(tuple.keySet().iterator().next(), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.MSETNX, params.toArray());
    }

    public Long incr(byte[] key) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.INCR, new Object[]{key});
    }

    public Long incrBy(byte[] key, long value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.INCRBY, key, value);
    }

    public Double incrBy(byte[] key, double value) {
        return (Double)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.INCRBYFLOAT, key, BigDecimal.valueOf(value).toPlainString());
    }

    public Long decr(byte[] key) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.DECR, new Object[]{key});
    }

    public Long decrBy(byte[] key, long value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)DECRBY, key, value);
    }

    public Long append(byte[] key, byte[] value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)APPEND, key, value);
    }

    public byte[] getRange(byte[] key, long begin, long end) {
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, GETRANGE, key, begin, end);
    }

    public void setRange(byte[] key, byte[] value, long offset) {
        this.write(key, (Codec)ByteArrayCodec.INSTANCE, SETRANGE, key, offset, value);
    }

    public Boolean getBit(byte[] key, long offset) {
        return (Boolean)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.GETBIT, key, offset);
    }

    public Boolean setBit(byte[] key, long offset, boolean value) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.SETBIT, key, offset, value ? 1 : 0);
    }

    public Long bitCount(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.BITCOUNT, new Object[]{key});
    }

    public Long bitCount(byte[] key, long begin, long end) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.BITCOUNT, key, begin, end);
    }

    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new UnsupportedOperationException("NOT operation doesn't support more than single source key");
        }
        ArrayList<Object> params = new ArrayList<Object>(keys.length + 2);
        params.add(op);
        params.add(destination);
        params.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)BITOP, params.toArray());
    }

    public Long strLen(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.STRLEN, new Object[]{key});
    }

    public Long rPush(byte[] key, byte[] ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RPUSH, args.toArray());
    }

    public Long lPush(byte[] key, byte[] ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LPUSH, args.toArray());
    }

    public Long rPushX(byte[] key, byte[] value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RPUSHX, key, value);
    }

    public Long lPushX(byte[] key, byte[] value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LPUSHX, key, value);
    }

    public Long lLen(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LLEN, new Object[]{key});
    }

    public List<byte[]> lRange(byte[] key, long start, long end) {
        return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LRANGE, key, start, end);
    }

    public void lTrim(byte[] key, long start, long end) {
        this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.LTRIM, key, start, end);
    }

    public byte[] lIndex(byte[] key, long index) {
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LINDEX, key, index);
    }

    public Long lInsert(byte[] key, RedisListCommands.Position where, byte[] pivot, byte[] value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LINSERT, key, where, pivot, value);
    }

    <T> T write(byte[] key, Codec codec, RedisCommand<?> command, Object ... params) {
        RFuture f = this.executorService.writeAsync(key, codec, command, params);
        this.indexCommand(command);
        return this.sync(f);
    }

    protected void indexCommand(RedisCommand<?> command) {
        if (this.isQueueing() || this.isPipelined()) {
            ++this.index;
            if (this.filterOkResponses && this.commandsToRemove.contains(command.getName())) {
                this.indexToRemove.add(this.index);
            }
        }
    }

    <T> T read(byte[] key, Codec codec, RedisCommand<?> command, Object ... params) {
        RFuture f = this.executorService.readAsync(key, codec, command, params);
        this.indexCommand(command);
        return this.sync(f);
    }

    public void lSet(byte[] key, long index, byte[] value) {
        this.write(key, (Codec)StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LSET, key, index, value);
    }

    public Long lRem(byte[] key, long count, byte[] value) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)LREM, key, count, value);
    }

    public byte[] lPop(byte[] key) {
        return (byte[])this.write(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LPOP, new Object[]{key});
    }

    public byte[] rPop(byte[] key) {
        return (byte[])this.write(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.RPOP, new Object[]{key});
    }

    public List<byte[]> bLPop(int timeout, byte[] ... keys) {
        ArrayList<Object> params = new ArrayList<Object>(keys.length + 1);
        params.addAll(Arrays.asList(keys));
        params.add(timeout);
        return (List)this.write(keys[0], (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.BLPOP, params.toArray());
    }

    public List<byte[]> bRPop(int timeout, byte[] ... keys) {
        ArrayList<Object> params = new ArrayList<Object>(keys.length + 1);
        params.addAll(Arrays.asList(keys));
        params.add(timeout);
        return (List)this.write(keys[0], (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.BRPOP, params.toArray());
    }

    public byte[] rPopLPush(byte[] srcKey, byte[] dstKey) {
        return (byte[])this.write(srcKey, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.RPOPLPUSH, srcKey, dstKey);
    }

    public byte[] bRPopLPush(int timeout, byte[] srcKey, byte[] dstKey) {
        return (byte[])this.write(srcKey, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.BRPOPLPUSH, srcKey, dstKey, timeout);
    }

    public List<Long> lPos(byte[] key, byte[] element, Integer rank, Integer count) {
        Object read;
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(element);
        if (rank != null) {
            args.add("RANK");
            args.add(rank);
        }
        if (count != null) {
            args.add("COUNT");
            args.add(count);
        }
        if ((read = this.read(key, (Codec)ByteArrayCodec.INSTANCE, LPOS, args.toArray())) == null) {
            return Collections.emptyList();
        }
        if (read instanceof Long) {
            return Collections.singletonList((Long)read);
        }
        return (List)read;
    }

    public Long sAdd(byte[] key, byte[] ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, SADD, args.toArray());
    }

    public Long sRem(byte[] key, byte[] ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)SREM, args.toArray());
    }

    public byte[] sPop(byte[] key) {
        return (byte[])this.write(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SPOP_SINGLE, new Object[]{key});
    }

    public List<byte[]> sPop(byte[] key, long count) {
        return (List)this.write(key, (Codec)ByteArrayCodec.INSTANCE, SPOP, key, count);
    }

    public Boolean sMove(byte[] srcKey, byte[] destKey, byte[] value) {
        return (Boolean)this.write(srcKey, (Codec)StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SMOVE, srcKey, destKey, value);
    }

    public Long sCard(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)SCARD, new Object[]{key});
    }

    public Boolean sIsMember(byte[] key, byte[] value) {
        return (Boolean)this.read(key, (Codec)StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SISMEMBER, key, value);
    }

    public Set<byte[]> sInter(byte[] ... keys) {
        return (Set)this.write(keys[0], (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SINTER, Arrays.asList(keys).toArray());
    }

    public Long sInterStore(byte[] destKey, byte[] ... keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.length + 1);
        args.add(destKey);
        args.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.SINTERSTORE, args.toArray());
    }

    public Set<byte[]> sUnion(byte[] ... keys) {
        return (Set)this.write(keys[0], (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SUNION, Arrays.asList(keys).toArray());
    }

    public Long sUnionStore(byte[] destKey, byte[] ... keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.length + 1);
        args.add(destKey);
        args.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.SUNIONSTORE, args.toArray());
    }

    public Set<byte[]> sDiff(byte[] ... keys) {
        return (Set)this.write(keys[0], (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SDIFF, Arrays.asList(keys).toArray());
    }

    public Long sDiffStore(byte[] destKey, byte[] ... keys) {
        ArrayList<Object> args = new ArrayList<Object>(keys.length + 1);
        args.add(destKey);
        args.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.SDIFFSTORE, args.toArray());
    }

    public Set<byte[]> sMembers(byte[] key) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SMEMBERS, new Object[]{key});
    }

    public byte[] sRandMember(byte[] key) {
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SRANDMEMBER_SINGLE, new Object[]{key});
    }

    public List<byte[]> sRandMember(byte[] key, long count) {
        return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, SRANDMEMBER, key, count);
    }

    public Cursor<byte[]> sScan(byte[] key, ScanOptions options) {
        return new KeyBoundCursor<byte[]>(key, 0L, options){
            private RedisClient client;

            protected ScanIteration<byte[]> doScan(byte[] key, Cursor.CursorId cursorId, ScanOptions options) {
                if (RedissonConnection.this.isQueueing() || RedissonConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'SSCAN' cannot be called in pipeline / transaction mode.");
                }
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(key);
                args.add(cursorId.getCursorId());
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonConnection.this.executorService.readAsync(this.client, key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.SSCAN, args.toArray());
                ListScanResult res = (ListScanResult)RedissonConnection.this.syncFuture(f);
                this.client = res.getRedisClient();
                return new ScanIteration(Cursor.CursorId.of((String)res.getPos()), (Collection)res.getValues());
            }
        }.open();
    }

    public Boolean zAdd(byte[] key, double score, byte[] value, RedisZSetCommands.ZAddArgs args) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.XX)) {
            params.add("XX");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.NX)) {
            params.add("NX");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.GT)) {
            params.add("GT");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.LT)) {
            params.add("LT");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.CH)) {
            params.add("CH");
        }
        params.add(BigDecimal.valueOf(score).toPlainString());
        params.add(value);
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZADD_BOOL, params.toArray());
    }

    public Long zAdd(byte[] key, Set<Tuple> tuples, RedisZSetCommands.ZAddArgs args) {
        ArrayList<Object> params = new ArrayList<Object>(tuples.size() * 2 + 1);
        params.add(key);
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.XX)) {
            params.add("XX");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.NX)) {
            params.add("NX");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.GT)) {
            params.add("GT");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.LT)) {
            params.add("LT");
        }
        if (args.contains(RedisZSetCommands.ZAddArgs.Flag.CH)) {
            params.add("CH");
        }
        for (Tuple entry : tuples) {
            params.add(BigDecimal.valueOf(entry.getScore()).toPlainString());
            params.add(entry.getValue());
        }
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZADD, params.toArray());
    }

    public Long zRem(byte[] key, byte[] ... values) {
        ArrayList<Object> params = new ArrayList<Object>(values.length + 1);
        params.add(key);
        params.addAll(Arrays.asList(values));
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.ZREM_LONG, params.toArray());
    }

    public Double zIncrBy(byte[] key, double increment, byte[] value) {
        return (Double)this.write(key, (Codec)DoubleCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.ZINCRBY, key, new BigDecimal(increment).toPlainString(), value);
    }

    public Long zRank(byte[] key, byte[] value) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.ZRANK, key, value);
    }

    public Long zRevRank(byte[] key, byte[] value) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.ZREVRANK, key, value);
    }

    public Set<byte[]> zRange(byte[] key, long start, long end) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZRANGE, key, start, end);
    }

    public Set<Tuple> zRangeWithScores(byte[] key, long start, long end) {
        if (this.executorService.getServiceManager().isResp3()) {
            return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZRANGE_ENTRY_V2, key, start, end, "WITHSCORES");
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZRANGE_ENTRY, key, start, end, "WITHSCORES");
    }

    private String value(Range.Bound<?> boundary, String defaultValue) {
        if (boundary == null) {
            return defaultValue;
        }
        Object score = boundary.getValue().orElse(null);
        if (score == null) {
            return defaultValue;
        }
        StringBuilder element = new StringBuilder();
        if (!boundary.isInclusive()) {
            element.append("(");
        } else if (!(score instanceof Double)) {
            element.append("[");
        }
        if (score instanceof Double) {
            if (Double.isInfinite((Double)score)) {
                element.append((Double)score > 0.0 ? "+inf" : "-inf");
            } else {
                element.append(BigDecimal.valueOf((Double)score).toPlainString());
            }
        } else if (score instanceof byte[]) {
            element.append(new String((byte[])score, StandardCharsets.UTF_8));
        } else {
            element.append((Object)score);
        }
        return element.toString();
    }

    public Set<Tuple> zRangeByScoreWithScores(byte[] key, Range range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(min);
        args.add(max);
        args.add("WITHSCORES");
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        if (this.executorService.getServiceManager().isResp3()) {
            return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZRANGEBYSCORE_V2, args.toArray());
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZRANGEBYSCORE, args.toArray());
    }

    public Set<byte[]> zRevRange(byte[] key, long start, long end) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGE, key, start, end);
    }

    public Set<Tuple> zRevRangeWithScores(byte[] key, long start, long end) {
        if (this.executorService.getServiceManager().isResp3()) {
            return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGE_ENTRY_V2, key, start, end, "WITHSCORES");
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGE_ENTRY, key, start, end, "WITHSCORES");
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, double min, double max) {
        return this.zRevRangeByScore(key, Range.closed((Object)min, (Object)max));
    }

    public Set<byte[]> zRevRangeByScore(byte[] key, Range range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(max);
        args.add(min);
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGEBYSCORE, args.toArray());
    }

    public Set<Tuple> zRevRangeByScoreWithScores(byte[] key, Range range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(max);
        args.add(min);
        args.add("WITHSCORES");
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        if (this.executorService.getServiceManager().isResp3()) {
            return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGEBYSCOREWITHSCORES_V2, args.toArray());
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGEBYSCOREWITHSCORES, args.toArray());
    }

    public Long zCount(byte[] key, double min, double max) {
        return this.zCount(key, Range.closed((Object)min, (Object)max));
    }

    public Long zCount(byte[] key, Range range) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZCOUNT, key, min, max);
    }

    public Long zCard(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.ZCARD, new Object[]{key});
    }

    public Double zScore(byte[] key, byte[] value) {
        return (Double)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.ZSCORE, key, value);
    }

    public Long zRemRange(byte[] key, long start, long end) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZREMRANGEBYRANK, key, start, end);
    }

    public Long zRemRangeByScore(byte[] key, double min, double max) {
        return this.zRemRangeByScore(key, Range.closed((Object)min, (Object)max));
    }

    public Long zRemRangeByScore(byte[] key, Range range) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZREMRANGEBYSCORE, key, min, max);
    }

    public Long zUnionStore(byte[] destKey, byte[] ... sets) {
        return this.zUnionStore(destKey, null, (Weights)null, sets);
    }

    public Long zUnionStore(byte[] destKey, Aggregate aggregate, Weights weights, byte[] ... sets) {
        ArrayList<Object> args = new ArrayList<Object>(sets.length * 2 + 5);
        args.add(destKey);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        if (weights != null) {
            args.add("WEIGHTS");
            for (double weight : weights.toArray()) {
                args.add(BigDecimal.valueOf(weight).toPlainString());
            }
        }
        if (aggregate != null) {
            args.add("AGGREGATE");
            args.add(aggregate.name());
        }
        return (Long)this.write(destKey, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)ZUNIONSTORE, args.toArray());
    }

    public Long zInterStore(byte[] destKey, byte[] ... sets) {
        return this.zInterStore(destKey, null, (Weights)null, sets);
    }

    public Long zInterStore(byte[] destKey, Aggregate aggregate, Weights weights, byte[] ... sets) {
        ArrayList<Object> args = new ArrayList<Object>(sets.length * 2 + 5);
        args.add(destKey);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        if (weights != null) {
            args.add("WEIGHTS");
            for (double weight : weights.toArray()) {
                args.add(BigDecimal.valueOf(weight).toPlainString());
            }
        }
        if (aggregate != null) {
            args.add("AGGREGATE");
            args.add(aggregate.name());
        }
        return (Long)this.write(destKey, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZINTERSTORE, args.toArray());
    }

    public Cursor<Tuple> zScan(byte[] key, ScanOptions options) {
        return new KeyBoundCursor<Tuple>(key, 0L, options){
            private RedisClient client;

            protected ScanIteration<Tuple> doScan(byte[] key, Cursor.CursorId cursorId, ScanOptions options) {
                if (RedissonConnection.this.isQueueing() || RedissonConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'ZSCAN' cannot be called in pipeline / transaction mode.");
                }
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(key);
                args.add(cursorId.getCursorId());
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonConnection.this.executorService.readAsync(this.client, key, (Codec)ByteArrayCodec.INSTANCE, ZSCAN, args.toArray());
                ListScanResult res = (ListScanResult)RedissonConnection.this.syncFuture(f);
                this.client = res.getRedisClient();
                return new ScanIteration(Cursor.CursorId.of((String)res.getPos()), (Collection)res.getValues());
            }
        }.open();
    }

    public Set<byte[]> zRangeByScore(byte[] key, String min, String max) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZRANGEBYSCORE, key, min, max);
    }

    public Set<byte[]> zRangeByScore(byte[] key, String min, String max, long offset, long count) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZRANGEBYSCORE, key, min, max, "LIMIT", offset, count);
    }

    public Set<byte[]> zRangeByScore(byte[] key, Range range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(min);
        args.add(max);
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZRANGEBYSCORE, args.toArray());
    }

    public Set<byte[]> zRangeByLex(byte[] key, Range<byte[]> range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-");
        String max = this.value(range.getUpperBound(), "+");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(min);
        args.add(max);
        if (limit != null) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZRANGEBYLEX, args.toArray());
    }

    public Boolean hSet(byte[] key, byte[] field, byte[] value) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.HSET, key, field, value);
    }

    public Boolean hSetNX(byte[] key, byte[] field, byte[] value) {
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.HSETNX, key, field, value);
    }

    public byte[] hGet(byte[] key, byte[] field) {
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HGET, key, field);
    }

    public List<byte[]> hMGet(byte[] key, byte[] ... fields) {
        ArrayList<Object> args = new ArrayList<Object>(fields.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(fields));
        return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, HMGET, args.toArray());
    }

    public void hMSet(byte[] key, Map<byte[], byte[]> hashes) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(hashes.size() * 2 + 1);
        params.add(key);
        for (Map.Entry<byte[], byte[]> entry : hashes.entrySet()) {
            params.add(entry.getKey());
            params.add(entry.getValue());
        }
        this.write(key, (Codec)StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HMSET, params.toArray());
    }

    public Long hIncrBy(byte[] key, byte[] field, long delta) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, HINCRBY, key, field, delta);
    }

    public Double hIncrBy(byte[] key, byte[] field, double delta) {
        return (Double)this.write(key, (Codec)StringCodec.INSTANCE, HINCRBYFLOAT, key, field, BigDecimal.valueOf(delta).toPlainString());
    }

    public Boolean hExists(byte[] key, byte[] field) {
        return (Boolean)this.read(key, (Codec)StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HEXISTS, key, field);
    }

    public Long hDel(byte[] key, byte[] ... fields) {
        ArrayList<Object> args = new ArrayList<Object>(fields.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(fields));
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HDEL, args.toArray());
    }

    public Long hLen(byte[] key) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)HLEN, new Object[]{key});
    }

    public Set<byte[]> hKeys(byte[] key) {
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HKEYS, new Object[]{key});
    }

    public List<byte[]> hVals(byte[] key) {
        return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HVALS, new Object[]{key});
    }

    public Map<byte[], byte[]> hGetAll(byte[] key) {
        return (Map)this.read(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HGETALL, new Object[]{key});
    }

    public Cursor<Map.Entry<byte[], byte[]>> hScan(byte[] key, ScanOptions options) {
        return new KeyBoundCursor<Map.Entry<byte[], byte[]>>(key, 0L, options){
            private RedisClient client;

            protected ScanIteration<Map.Entry<byte[], byte[]>> doScan(byte[] key, Cursor.CursorId cursorId, ScanOptions options) {
                if (RedissonConnection.this.isQueueing() || RedissonConnection.this.isPipelined()) {
                    throw new UnsupportedOperationException("'HSCAN' cannot be called in pipeline / transaction mode.");
                }
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(key);
                args.add(cursorId.getCursorId());
                if (options.getPattern() != null) {
                    args.add("MATCH");
                    args.add(options.getPattern());
                }
                if (options.getCount() != null) {
                    args.add("COUNT");
                    args.add(options.getCount());
                }
                RFuture f = RedissonConnection.this.executorService.readAsync(this.client, key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.HSCAN, args.toArray());
                MapScanResult res = (MapScanResult)RedissonConnection.this.syncFuture(f);
                this.client = res.getRedisClient();
                return new ScanIteration(Cursor.CursorId.of((String)res.getPos()), res.getValues());
            }
        }.open();
    }

    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        if (this.isPipelined()) {
            BatchOptions options = BatchOptions.defaults().executionMode(BatchOptions.ExecutionMode.IN_MEMORY_ATOMIC);
            this.executorService = this.executorService.createCommandBatchService(options);
            return;
        }
        BatchOptions options = BatchOptions.defaults().executionMode(BatchOptions.ExecutionMode.REDIS_WRITE_ATOMIC);
        this.executorService = this.executorService.createCommandBatchService(options);
    }

    public List<Object> exec() {
        if (this.isPipelinedAtomic()) {
            return null;
        }
        if (this.isQueueing()) {
            try {
                BatchResult result = ((CommandBatchService)this.executorService).execute();
                this.filterResults(result);
                List list = result.getResponses();
                return list;
            }
            catch (Exception ex) {
                throw this.transform(ex);
            }
            finally {
                this.resetConnection();
            }
        }
        throw new InvalidDataAccessApiUsageException("Not in transaction mode. Please invoke multi method");
    }

    protected void filterResults(BatchResult<?> result) {
        if (result.getResponses().isEmpty()) {
            return;
        }
        int t = 0;
        for (Integer index : this.indexToRemove) {
            index = index - t;
            result.getResponses().remove(index);
            ++t;
        }
        ListIterator<byte[]> iterator = result.getResponses().listIterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof String)) continue;
            iterator.set(((String)object).getBytes());
        }
    }

    protected void resetConnection() {
        this.executorService = this.redisson.getCommandExecutor();
        this.index = -1;
        this.indexToRemove.clear();
    }

    public void discard() {
        if (!this.isQueueing()) {
            throw new InvalidDataAccessApiUsageException("Not in transaction mode. Please invoke multi method");
        }
        this.syncFuture(this.executorService.writeAsync(null, (RedisCommand)org.redisson.client.protocol.RedisCommands.DISCARD, new Object[0]));
        this.resetConnection();
    }

    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        this.syncFuture(this.executorService.writeAsync(null, (RedisCommand)org.redisson.client.protocol.RedisCommands.WATCH, (Object[])keys));
    }

    public void unwatch() {
        this.syncFuture(this.executorService.writeAsync(null, (RedisCommand)org.redisson.client.protocol.RedisCommands.UNWATCH, new Object[0]));
    }

    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public Long publish(byte[] channel, byte[] message) {
        return (Long)this.write(channel, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.PUBLISH, channel, message);
    }

    public void subscribe(MessageListener listener, byte[] ... channels) {
        this.checkSubscription();
        this.subscription = new RedissonSubscription(this.executorService, listener);
        this.subscription.subscribe(channels);
    }

    private void checkSubscription() {
        if (this.subscription != null) {
            throw new RedisSubscribedConnectionException("Connection already subscribed");
        }
        if (this.isQueueing()) {
            throw new UnsupportedOperationException("Not supported in queueing mode");
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException("Not supported in pipelined mode");
        }
    }

    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        this.checkSubscription();
        this.subscription = new RedissonSubscription(this.executorService, listener);
        this.subscription.pSubscribe(patterns);
    }

    public void select(int dbIndex) {
        throw new UnsupportedOperationException();
    }

    public byte[] echo(byte[] message) {
        return (byte[])this.read(null, (Codec)ByteArrayCodec.INSTANCE, ECHO, new Object[]{message});
    }

    public String ping() {
        return (String)this.read(null, (Codec)StringCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.PING, new Object[0]);
    }

    public void bgReWriteAof() {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.BGREWRITEAOF, new Object[0]);
    }

    public void bgSave() {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.BGSAVE, new Object[0]);
    }

    public Long lastSave() {
        return (Long)this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.LASTSAVE, new Object[0]);
    }

    public void save() {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)SAVE, new Object[0]);
    }

    public Long dbSize() {
        if (this.isQueueing()) {
            return (Long)this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.DBSIZE, new Object[0]);
        }
        List futures = this.executorService.readAllAsync((RedisCommand)org.redisson.client.protocol.RedisCommands.DBSIZE, new Object[0]);
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage s = f.thenApply(r -> futures.stream().mapToLong(v -> v.getNow(0L)).sum());
        CompletableFutureWrapper ff = new CompletableFutureWrapper((CompletableFuture)s);
        return (Long)this.sync((RFuture)ff);
    }

    public void flushDb() {
        if (this.isQueueing() || this.isPipelined()) {
            this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.FLUSHDB, new Object[0]);
            return;
        }
        RFuture f = this.executorService.writeAllVoidAsync((RedisCommand)org.redisson.client.protocol.RedisCommands.FLUSHDB, new Object[0]);
        this.sync(f);
    }

    public void flushAll() {
        RFuture f = this.executorService.writeAllVoidAsync((RedisCommand)org.redisson.client.protocol.RedisCommands.FLUSHALL, new Object[0]);
        this.sync(f);
    }

    public Properties info() {
        return (Properties)this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)INFO_DEFAULT, new Object[0]);
    }

    public Properties info(String section) {
        return (Properties)this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)INFO, section);
    }

    public void shutdown() {
        throw new UnsupportedOperationException();
    }

    public void shutdown(RedisServerCommands.ShutdownOption option) {
        throw new UnsupportedOperationException();
    }

    public Properties getConfig(String pattern) {
        return (Properties)this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)CONFIG_GET, pattern);
    }

    public void setConfig(String param, String value) {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.CONFIG_SET, param, value);
    }

    public void resetConfigStats() {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.CONFIG_RESETSTAT, new Object[0]);
    }

    public void killClient(String host, int port) {
        throw new UnsupportedOperationException();
    }

    public void setClientName(byte[] name) {
        throw new UnsupportedOperationException("Should be defined through Redisson Config object");
    }

    public String getClientName() {
        throw new UnsupportedOperationException();
    }

    public List<RedisClientInfo> getClientList() {
        return (List)this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.CLIENT_LIST, new Object[0]);
    }

    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option) {
        this.migrate(key, target, dbIndex, option, Long.MAX_VALUE);
    }

    public void migrate(byte[] key, RedisNode target, int dbIndex, RedisServerCommands.MigrateOption option, long timeout) {
        this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.MIGRATE, target.getHost(), target.getPort(), key, dbIndex, timeout);
    }

    public void scriptFlush() {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        RFuture f = this.executorService.writeAllVoidAsync((RedisCommand)org.redisson.client.protocol.RedisCommands.SCRIPT_FLUSH, new Object[0]);
        this.sync(f);
    }

    public void scriptKill() {
        throw new UnsupportedOperationException();
    }

    public String scriptLoad(byte[] script) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        List futures = this.executorService.executeAllAsync((RedisCommand)org.redisson.client.protocol.RedisCommands.SCRIPT_LOAD, new Object[]{script});
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage s = f.thenApply(r -> ((CompletableFuture)futures.get(0)).getNow(null));
        return (String)this.sync((RFuture)new CompletableFutureWrapper((CompletableFuture)s));
    }

    public List<Boolean> scriptExists(String ... scriptShas) {
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        List futures = this.executorService.writeAllAsync((RedisCommand)org.redisson.client.protocol.RedisCommands.SCRIPT_EXISTS, (Object[])scriptShas);
        CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        CompletionStage s = f.thenApply(r -> {
            List result = ((CompletableFuture)futures.get(0)).getNow(new ArrayList());
            for (CompletableFuture future : futures.subList(1, futures.size())) {
                List l = future.getNow(new ArrayList());
                for (int i = 0; i < l.size(); ++i) {
                    result.set(i, (Boolean)result.get(i) | (Boolean)l.get(i));
                }
            }
            return result;
        });
        return (List)this.sync((RFuture)new CompletableFutureWrapper((CompletableFuture)s));
    }

    public <T> T eval(byte[] script, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        RedisCommand<?> c = this.toCommand(returnType, "EVAL");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(script);
        params.add(numKeys);
        params.addAll(Arrays.asList(keysAndArgs));
        byte[] key = RedissonConnection.getKey(numKeys, keysAndArgs);
        return this.write(key, (Codec)ByteArrayCodec.INSTANCE, c, params.toArray());
    }

    protected RedisCommand<?> toCommand(ReturnType returnType, String name) {
        RedisCommand c = null;
        if (returnType == ReturnType.BOOLEAN) {
            c = RScript.ReturnType.BOOLEAN.getCommand();
        } else if (returnType == ReturnType.INTEGER) {
            c = RScript.ReturnType.LONG.getCommand();
        } else {
            if (returnType == ReturnType.MULTI) {
                c = RScript.ReturnType.LIST.getCommand();
                return new RedisCommand(c, name, (Convertor)new BinaryConvertor());
            }
            if (returnType == ReturnType.STATUS) {
                c = RScript.ReturnType.STRING.getCommand();
            } else if (returnType == ReturnType.VALUE) {
                c = RScript.ReturnType.VALUE.getCommand();
                return new RedisCommand(c, name, (Convertor)new BinaryConvertor());
            }
        }
        return new RedisCommand(c, name);
    }

    public <T> T evalSha(String scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        if (this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        RedisCommand<?> c = this.toCommand(returnType, "EVALSHA");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(scriptSha);
        params.add(numKeys);
        params.addAll(Arrays.asList(keysAndArgs));
        byte[] key = RedissonConnection.getKey(numKeys, keysAndArgs);
        return this.write(key, (Codec)ByteArrayCodec.INSTANCE, c, params.toArray());
    }

    public <T> T evalSha(byte[] scriptSha, ReturnType returnType, int numKeys, byte[] ... keysAndArgs) {
        RedisCommand<?> c = this.toCommand(returnType, "EVALSHA");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(scriptSha);
        params.add(numKeys);
        params.addAll(Arrays.asList(keysAndArgs));
        byte[] key = RedissonConnection.getKey(numKeys, keysAndArgs);
        return this.write(key, (Codec)ByteArrayCodec.INSTANCE, c, params.toArray());
    }

    private static byte[] getKey(int numKeys, byte[][] keysAndArgs) {
        if (numKeys > 0 && keysAndArgs.length > 0) {
            return keysAndArgs[0];
        }
        return null;
    }

    public Long geoAdd(byte[] key, Point point, byte[] member) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.GEOADD, key, point.getX(), point.getY(), member);
    }

    public Long geoAdd(byte[] key, RedisGeoCommands.GeoLocation<byte[]> location) {
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.GEOADD, key, location.getPoint().getX(), location.getPoint().getY(), location.getName());
    }

    public Long geoAdd(byte[] key, Map<byte[], Point> memberCoordinateMap) {
        ArrayList<Object> params = new ArrayList<Object>(memberCoordinateMap.size() * 3 + 1);
        params.add(key);
        for (Map.Entry<byte[], Point> entry : memberCoordinateMap.entrySet()) {
            params.add(entry.getValue().getX());
            params.add(entry.getValue().getY());
            params.add(entry.getKey());
        }
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.GEOADD, params.toArray());
    }

    public Long geoAdd(byte[] key, Iterable<RedisGeoCommands.GeoLocation<byte[]>> locations) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        for (RedisGeoCommands.GeoLocation<byte[]> location : locations) {
            params.add(location.getPoint().getX());
            params.add(location.getPoint().getY());
            params.add(location.getName());
        }
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.GEOADD, params.toArray());
    }

    public Distance geoDist(byte[] key, byte[] member1, byte[] member2) {
        return this.geoDist(key, member1, member2, (Metric)RedisGeoCommands.DistanceUnit.METERS);
    }

    public Distance geoDist(byte[] key, byte[] member1, byte[] member2, Metric metric) {
        return (Distance)this.read(key, (Codec)DoubleCodec.INSTANCE, new RedisCommand("GEODIST", (Convertor)new DistanceConvertor(metric)), key, member1, member2, this.getAbbreviation(metric));
    }

    public List<String> geoHash(byte[] key, byte[] ... members) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(members.length + 1);
        params.add(key);
        for (byte[] member : members) {
            params.add(member);
        }
        return (List)this.read(key, (Codec)StringCodec.INSTANCE, GEOHASH, params.toArray());
    }

    public List<Point> geoPos(byte[] key, byte[] ... members) {
        ArrayList<Object> params = new ArrayList<Object>(members.length + 1);
        params.add(key);
        params.addAll(Arrays.asList(members));
        RedisCommand command = new RedisCommand("GEOPOS", this.geoDecoder);
        return (List)this.read(key, (Codec)StringCodec.INSTANCE, command, params.toArray());
    }

    private String convert(double longitude) {
        return BigDecimal.valueOf(longitude).toPlainString();
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within) {
        RedisCommand command = new RedisCommand("GEORADIUS_RO", (MultiDecoder)new GeoResultsDecoder());
        return (GeoResults)this.read(key, (Codec)ByteArrayCodec.INSTANCE, command, key, this.convert(within.getCenter().getX()), this.convert(within.getCenter().getY()), within.getRadius().getValue(), this.getAbbreviation(within.getRadius().getMetric()));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadius(byte[] key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        RedisCommand command;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(this.convert(within.getCenter().getX()));
        params.add(this.convert(within.getCenter().getY()));
        params.add(within.getRadius().getValue());
        params.add(this.getAbbreviation(within.getRadius().getMetric()));
        if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
            command = new RedisCommand("GEORADIUS_RO", this.postitionDecoder);
            params.add("WITHCOORD");
        } else {
            ListMultiDecoder2 distanceDecoder = new ListMultiDecoder2(new MultiDecoder[]{new GeoResultsDecoder(within.getRadius().getMetric()), new GeoDistanceDecoder()});
            command = new RedisCommand("GEORADIUS_RO", (MultiDecoder)distanceDecoder);
            params.add("WITHDIST");
        }
        if (args.getLimit() != null) {
            params.add("COUNT");
            params.add(args.getLimit());
        }
        if (args.getSortDirection() != null) {
            params.add(args.getSortDirection().name());
        }
        return (GeoResults)this.read(key, (Codec)ByteArrayCodec.INSTANCE, command, params.toArray());
    }

    private String getAbbreviation(Metric metric) {
        if (ObjectUtils.nullSafeEquals((Object)Metrics.NEUTRAL, (Object)metric)) {
            return RedisGeoCommands.DistanceUnit.METERS.getAbbreviation();
        }
        return metric.getAbbreviation();
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, double radius) {
        return this.geoRadiusByMember(key, member, new Distance(radius, (Metric)RedisGeoCommands.DistanceUnit.METERS));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius) {
        return (GeoResults)this.read(key, (Codec)ByteArrayCodec.INSTANCE, GEORADIUSBYMEMBER, key, member, radius.getValue(), this.getAbbreviation(radius.getMetric()));
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoRadiusByMember(byte[] key, byte[] member, Distance radius, RedisGeoCommands.GeoRadiusCommandArgs args) {
        RedisCommand command;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(member);
        params.add(radius.getValue());
        params.add(this.getAbbreviation(radius.getMetric()));
        if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
            command = new RedisCommand("GEORADIUSBYMEMBER_RO", this.postitionDecoder);
            params.add("WITHCOORD");
        } else {
            ListMultiDecoder2 distanceDecoder = new ListMultiDecoder2(new MultiDecoder[]{new GeoResultsDecoder(radius.getMetric()), new GeoDistanceDecoder()});
            command = new RedisCommand("GEORADIUSBYMEMBER_RO", (MultiDecoder)distanceDecoder);
            params.add("WITHDIST");
        }
        if (args.getLimit() != null) {
            params.add("COUNT");
            params.add(args.getLimit());
        }
        if (args.getSortDirection() != null) {
            params.add(args.getSortDirection().name());
        }
        return (GeoResults)this.read(key, (Codec)ByteArrayCodec.INSTANCE, command, params.toArray());
    }

    public Long geoRemove(byte[] key, byte[] ... members) {
        return this.zRem(key, members);
    }

    public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> geoSearch(byte[] key, GeoReference<byte[]> reference, GeoShape predicate, RedisGeoCommands.GeoSearchCommandArgs args) {
        RedisCommand cmd;
        BoxShape shape;
        GeoReference.GeoCoordinateReference ref;
        Assert.notNull((Object)args, (String)"Args must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)predicate, (String)"Shape must not be null!");
        Assert.notNull(reference, (String)"Reference must not be null!");
        ArrayList<Object> commandParams = new ArrayList<Object>();
        commandParams.add(key);
        if (reference instanceof GeoReference.GeoCoordinateReference) {
            ref = (GeoReference.GeoCoordinateReference)reference;
            commandParams.add("FROMLONLAT");
            commandParams.add(this.convert(ref.getLongitude()));
            commandParams.add(this.convert(ref.getLatitude()));
        } else if (reference instanceof GeoReference.GeoMemberReference) {
            ref = (GeoReference.GeoMemberReference)reference;
            commandParams.add("FROMMEMBER");
            commandParams.add(this.encode(ref.getMember()));
        }
        if (predicate instanceof RadiusShape) {
            commandParams.add("BYRADIUS");
            shape = (RadiusShape)predicate;
            commandParams.add(shape.getRadius().getValue());
            commandParams.add(this.convert(shape.getMetric()).getAbbreviation());
        } else if (predicate instanceof BoxShape) {
            shape = (BoxShape)predicate;
            commandParams.add("BYBOX");
            commandParams.add(shape.getBoundingBox().getWidth().getValue());
            commandParams.add(shape.getBoundingBox().getHeight().getValue());
            commandParams.add(this.convert(shape.getMetric()).getAbbreviation());
        }
        if (args.hasSortDirection()) {
            commandParams.add(args.getSortDirection());
        }
        if (args.getLimit() != null) {
            commandParams.add("COUNT");
            commandParams.add(args.getLimit());
            if (args.hasAnyLimit()) {
                commandParams.add("ANY");
            }
        }
        if (args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
            cmd = new RedisCommand("GEOSEARCH", this.postitionDecoder);
            commandParams.add("WITHCOORD");
        } else {
            ListMultiDecoder2 distanceDecoder = new ListMultiDecoder2(new MultiDecoder[]{new GeoResultsDecoder(predicate.getMetric()), new GeoDistanceDecoder()});
            cmd = new RedisCommand("GEOSEARCH", (MultiDecoder)distanceDecoder);
            commandParams.add("WITHDIST");
        }
        return (GeoResults)this.read(key, (Codec)ByteArrayCodec.INSTANCE, cmd, commandParams.toArray());
    }

    public Long geoSearchStore(byte[] destKey, byte[] key, GeoReference<byte[]> reference, GeoShape predicate, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        RadiusShape shape;
        GeoReference.GeoCoordinateReference ref;
        Assert.notNull((Object)args, (String)"Args must not be null!");
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)destKey, (String)"DestKey must not be null!");
        Assert.notNull((Object)predicate, (String)"Shape must not be null!");
        Assert.notNull(reference, (String)"Reference must not be null!");
        ArrayList<Object> commandParams = new ArrayList<Object>();
        commandParams.add(destKey);
        commandParams.add(key);
        if (reference instanceof GeoReference.GeoCoordinateReference) {
            ref = (GeoReference.GeoCoordinateReference)reference;
            commandParams.add("FROMLONLAT");
            commandParams.add(this.convert(ref.getLongitude()));
            commandParams.add(this.convert(ref.getLatitude()));
        } else if (reference instanceof GeoReference.GeoMemberReference) {
            ref = (GeoReference.GeoMemberReference)reference;
            commandParams.add("FROMMEMBER");
            commandParams.add(this.encode(ref.getMember()));
        }
        if (predicate instanceof RadiusShape) {
            shape = (RadiusShape)predicate;
            commandParams.add("BYRADIUS");
            commandParams.add(shape.getRadius().getValue());
            commandParams.add(this.convert(shape.getMetric()).getAbbreviation());
        } else if (predicate instanceof BoxShape) {
            shape = (BoxShape)predicate;
            commandParams.add("BYBOX");
            commandParams.add(shape.getBoundingBox().getWidth().getValue());
            commandParams.add(shape.getBoundingBox().getHeight().getValue());
            commandParams.add(this.convert(shape.getMetric()).getAbbreviation());
        }
        if (args.hasSortDirection()) {
            commandParams.add(args.getSortDirection());
        }
        if (args.getLimit() != null) {
            commandParams.add("COUNT");
            commandParams.add(args.getLimit());
            if (args.hasAnyLimit()) {
                commandParams.add("ANY");
            }
        }
        if (args.isStoreDistance()) {
            commandParams.add("STOREDIST");
        }
        return (Long)this.write(key, (Codec)LongCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.GEOSEARCHSTORE_STORE, commandParams.toArray());
    }

    private Metric convert(Metric metric) {
        if (metric == Metrics.NEUTRAL) {
            return RedisGeoCommands.DistanceUnit.METERS;
        }
        return metric;
    }

    private ByteBuf encode(Object value) {
        return this.executorService.encode((Codec)ByteArrayCodec.INSTANCE, value);
    }

    public Long pfAdd(byte[] key, byte[] ... values) {
        ArrayList<byte[]> params = new ArrayList<byte[]>(values.length + 1);
        params.add(key);
        for (byte[] member : values) {
            params.add(member);
        }
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, PFADD, params.toArray());
    }

    public Long pfCount(byte[] ... keys) {
        Assert.notEmpty((Object[])keys, (String)"PFCOUNT requires at least one non 'null' key.");
        Assert.noNullElements((Object[])keys, (String)"Keys for PFOUNT must not contain 'null'.");
        return (Long)this.write(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.PFCOUNT, Arrays.asList(keys).toArray());
    }

    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        ArrayList<Object> args = new ArrayList<Object>(sourceKeys.length + 1);
        args.add(destinationKey);
        args.addAll(Arrays.asList(sourceKeys));
        this.write(destinationKey, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.PFMERGE, args.toArray());
    }

    public Long hStrLen(byte[] key, byte[] field) {
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, HSTRLEN, key, field);
    }

    public RedisStreamCommands streamCommands() {
        return new RedissonStreamCommands(this, this.executorService);
    }

    public List<Long> bitField(byte[] key, BitFieldSubCommands subCommands) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        boolean writeOp = false;
        for (BitFieldSubCommands.BitFieldSubCommand subCommand : subCommands) {
            String size = "u";
            if (subCommand.getType().isSigned()) {
                size = "i";
            }
            size = size + subCommand.getType().getBits();
            String offset = "#";
            if (subCommand.getOffset().isZeroBased()) {
                offset = "";
            }
            offset = offset + subCommand.getOffset().getValue();
            if (subCommand instanceof BitFieldSubCommands.BitFieldGet) {
                params.add("GET");
                params.add(size);
                params.add(offset);
                continue;
            }
            if (subCommand instanceof BitFieldSubCommands.BitFieldSet) {
                writeOp = true;
                params.add("SET");
                params.add(size);
                params.add(offset);
                params.add(((BitFieldSubCommands.BitFieldSet)subCommand).getValue());
                continue;
            }
            if (!(subCommand instanceof BitFieldSubCommands.BitFieldIncrBy)) continue;
            writeOp = true;
            params.add("INCRBY");
            params.add(size);
            params.add(offset);
            params.add(((BitFieldSubCommands.BitFieldIncrBy)subCommand).getValue());
            BitFieldSubCommands.BitFieldIncrBy.Overflow overflow = ((BitFieldSubCommands.BitFieldIncrBy)subCommand).getOverflow();
            if (overflow == null) continue;
            params.add("OVERFLOW");
            params.add(overflow);
        }
        if (writeOp) {
            return (List)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)BITFIELD, params.toArray());
        }
        return (List)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)BITFIELD, params.toArray());
    }

    public Long exists(byte[] ... keys) {
        return (Long)this.read(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.EXISTS_LONG, Arrays.asList(keys).toArray());
    }

    public Long touch(byte[] ... keys) {
        return (Long)this.read(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.TOUCH_LONG, Arrays.asList(keys).toArray());
    }

    public ValueEncoding encodingOf(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (ValueEncoding)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)OBJECT_ENCODING, new Object[]{key});
    }

    public Duration idletime(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Duration)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)OBJECT_IDLETIME, new Object[]{key});
    }

    public Long refcount(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)OBJECT_REFCOUNT, new Object[]{key});
    }

    public Long bitPos(byte[] key, boolean bit, Range<Long> range) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null! Use Range.unbounded() instead.");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        if (bit) {
            params.add(1);
        } else {
            params.add(0);
        }
        if (range.getLowerBound().isBounded()) {
            params.add(range.getLowerBound().getValue().get());
            if (range.getUpperBound().isBounded()) {
                params.add(range.getUpperBound().getValue().get());
            }
        }
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)BITPOS, params.toArray());
    }

    public void restore(byte[] key, long ttlInMillis, byte[] serializedValue, boolean replace) {
        if (replace) {
            this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.RESTORE, key, ttlInMillis, serializedValue, "REPLACE");
            return;
        }
        this.restore(key, ttlInMillis, serializedValue);
    }

    public byte[] zRandMember(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (byte[])this.write(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.ZRANDMEMBER_SINGLE, new Object[]{key});
    }

    public List<byte[]> zRandMember(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (List)this.write(key, (Codec)ByteArrayCodec.INSTANCE, ZRANDMEMBER_LIST, key, count);
    }

    public Tuple zRandMemberWithScore(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Tuple)this.write(key, (Codec)ByteArrayCodec.INSTANCE, ZRANDMEMBER_SCORE, key, "WITHSCORES");
    }

    public List<Tuple> zRandMemberWithScore(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (List)this.write(key, (Codec)ByteArrayCodec.INSTANCE, ZRANDMEMBER_SCORE_LIST, key, count, "WITHSCORES");
    }

    public Tuple zPopMin(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Tuple)this.write(key, (Codec)ByteArrayCodec.INSTANCE, ZPOPMIN, new Object[]{key});
    }

    public Set<Tuple> zPopMin(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Set)this.write(key, (Codec)ByteArrayCodec.INSTANCE, ZPOPMIN_FOR_SET, key, count);
    }

    public Tuple bZPopMin(byte[] key, long timeout, TimeUnit unit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        long seconds = unit.toSeconds(timeout);
        return (Tuple)this.write(key, (Codec)ByteArrayCodec.INSTANCE, BZPOPMIN, key, seconds);
    }

    public Tuple zPopMax(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Tuple)this.write(key, (Codec)ByteArrayCodec.INSTANCE, ZPOPMAX, new Object[]{key});
    }

    public Set<Tuple> zPopMax(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Set)this.write(key, (Codec)ByteArrayCodec.INSTANCE, ZPOPMAX_FOR_SET, key, count);
    }

    public Tuple bZPopMax(byte[] key, long timeout, TimeUnit unit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        long seconds = unit.toSeconds(timeout);
        return (Tuple)this.write(key, (Codec)ByteArrayCodec.INSTANCE, BZPOPMAX, key, seconds);
    }

    public List<Double> zMScore(byte[] key, byte[] ... values) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(key);
        args.addAll(Arrays.asList(values));
        return (List)this.write(key, (Codec)DoubleCodec.INSTANCE, ZMSCORE, args.toArray());
    }

    public Set<byte[]> zDiff(byte[] ... sets) {
        ArrayList<Integer> args = new ArrayList<Integer>(sets.length + 1);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        return (Set)this.write(sets[0], (Codec)ByteArrayCodec.INSTANCE, ZDIFF, args.toArray());
    }

    public Set<Tuple> zDiffWithScores(byte[] ... sets) {
        ArrayList<Object> args = new ArrayList<Object>(sets.length + 1);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        args.add("WITHSCORES");
        return (Set)this.write(sets[0], (Codec)ByteArrayCodec.INSTANCE, ZDIFF_SCORE, args.toArray());
    }

    public Long zDiffStore(byte[] destKey, byte[] ... sets) {
        Assert.notNull((Object)destKey, (String)"Key must not be null!");
        ArrayList<Object> args = new ArrayList<Object>(sets.length + 2);
        args.add(destKey);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        return (Long)this.write(destKey, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)ZDIFFSTORE, args.toArray());
    }

    public Set<byte[]> zInter(byte[] ... sets) {
        ArrayList<Integer> args = new ArrayList<Integer>(sets.length + 1);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        return (Set)this.write(sets[0], (Codec)ByteArrayCodec.INSTANCE, ZINTER, args.toArray());
    }

    public Set<Tuple> zInterWithScores(Aggregate aggregate, Weights weights, byte[] ... sets) {
        ArrayList<Object> args = new ArrayList<Object>(sets.length * 2 + 6);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        if (weights != null) {
            args.add("WEIGHTS");
            for (double weight : weights.toArray()) {
                args.add(BigDecimal.valueOf(weight).toPlainString());
            }
        }
        if (aggregate != null) {
            args.add("AGGREGATE");
            args.add(aggregate.name());
        }
        args.add("WITHSCORES");
        return (Set)this.write(sets[0], (Codec)ByteArrayCodec.INSTANCE, ZINTER_SCORE, args.toArray());
    }

    public Set<Tuple> zInterWithScores(byte[] ... sets) {
        return this.zInterWithScores(null, (Weights)null, sets);
    }

    public Set<byte[]> zUnion(byte[] ... sets) {
        ArrayList<Integer> args = new ArrayList<Integer>(sets.length + 1);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        return (Set)this.write(sets[0], (Codec)ByteArrayCodec.INSTANCE, ZUNION, args.toArray());
    }

    public Set<Tuple> zUnionWithScores(Aggregate aggregate, Weights weights, byte[] ... sets) {
        ArrayList<Object> args = new ArrayList<Object>(sets.length * 2 + 6);
        args.add(sets.length);
        args.addAll(Arrays.asList(sets));
        if (weights != null) {
            args.add("WEIGHTS");
            for (double weight : weights.toArray()) {
                args.add(BigDecimal.valueOf(weight).toPlainString());
            }
        }
        if (aggregate != null) {
            args.add("AGGREGATE");
            args.add(aggregate.name());
        }
        args.add("WITHSCORES");
        return (Set)this.write(sets[0], (Codec)ByteArrayCodec.INSTANCE, ZUNION_SCORE, args.toArray());
    }

    public Set<Tuple> zUnionWithScores(byte[] ... sets) {
        return this.zUnionWithScores(null, (Weights)null, sets);
    }

    public byte[] hRandField(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, HRANDFIELD, new Object[]{key});
    }

    public Map.Entry<byte[], byte[]> hRandFieldWithValues(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (this.executorService.getServiceManager().isResp3()) {
            return (Map.Entry)this.read(key, (Codec)ByteArrayCodec.INSTANCE, HRANDFIELD_SINGLE_V2, key, 1, "WITHVALUES");
        }
        return (Map.Entry)this.read(key, (Codec)ByteArrayCodec.INSTANCE, HRANDFIELD_SINGLE, key, 1, "WITHVALUES");
    }

    public List<byte[]> hRandField(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, HRANDFIELD_LIST, key, count);
    }

    public List<Map.Entry<byte[], byte[]>> hRandFieldWithValues(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (this.executorService.getServiceManager().isResp3()) {
            return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, HRANDFIELD_VALUES_V2, key, count, "WITHVALUES");
        }
        return (List)this.read(key, (Codec)ByteArrayCodec.INSTANCE, HRANDFIELD_VALUES, key, count, "WITHVALUES");
    }

    public Boolean copy(byte[] sourceKey, byte[] targetKey, boolean replace) {
        Assert.notNull((Object)sourceKey, (String)"Key must not be null!");
        Assert.notNull((Object)targetKey, (String)"Target must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(sourceKey);
        params.add(targetKey);
        if (replace) {
            params.add("REPLACE");
        }
        return (Boolean)this.write(sourceKey, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.COPY, params.toArray());
    }

    public byte[] lMove(byte[] sourceKey, byte[] destinationKey, RedisListCommands.Direction from, RedisListCommands.Direction to) {
        Assert.notNull((Object)sourceKey, (String)"Key must not be null!");
        Assert.notNull((Object)destinationKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)from, (String)"From must not be null!");
        Assert.notNull((Object)from, (String)"To must not be null!");
        return (byte[])this.write(sourceKey, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LMOVE, sourceKey, destinationKey, from, to);
    }

    public byte[] bLMove(byte[] sourceKey, byte[] destinationKey, RedisListCommands.Direction from, RedisListCommands.Direction to, double timeout) {
        Assert.notNull((Object)sourceKey, (String)"Key must not be null!");
        Assert.notNull((Object)destinationKey, (String)"Destination key must not be null!");
        Assert.notNull((Object)from, (String)"From must not be null!");
        Assert.notNull((Object)to, (String)"To must not be null!");
        Assert.notNull((Object)timeout, (String)"Timeout must not be null!");
        return (byte[])this.write(sourceKey, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.BLMOVE, sourceKey, destinationKey, from, to, destinationKey);
    }

    public List<byte[]> lPop(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (List)this.write(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.LPOP_LIST, key, count);
    }

    public List<byte[]> rPop(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (List)this.write(key, (Codec)ByteArrayCodec.INSTANCE, org.redisson.client.protocol.RedisCommands.RPOP_LIST, key, count);
    }

    public List<Boolean> sMIsMember(byte[] key, byte[] ... value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.addAll(Arrays.asList(value));
        return (List)this.read(key, (Codec)StringCodec.INSTANCE, SMISMEMBER, args.toArray());
    }

    public byte[] getEx(byte[] key, Expiration expiration) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (byte[])this.write(key, (Codec)ByteArrayCodec.INSTANCE, GETEX, key, "PX", expiration.getExpirationTimeInMilliseconds());
    }

    public byte[] getDel(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (byte[])this.write(key, (Codec)ByteArrayCodec.INSTANCE, GETDEL, new Object[]{key});
    }

    public Set<byte[]> zRevRangeByLex(byte[] key, Range range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-");
        String max = this.value(range.getUpperBound(), "+");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(max);
        args.add(min);
        if (!limit.isUnlimited()) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Set)this.read(key, (Codec)ByteArrayCodec.INSTANCE, ZREVRANGEBYLEX, args.toArray());
    }

    public Long time(TimeUnit timeUnit) {
        return (Long)this.read(null, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)new RedisStrictCommand("TIME", (MultiDecoder)new TimeLongObjectDecoder(timeUnit)), new Object[0]);
    }

    public Long zRemRangeByLex(byte[] key, Range range) {
        String min = this.value(range.getLowerBound(), "-");
        String max = this.value(range.getUpperBound(), "+");
        return (Long)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZREMRANGEBYLEX, key, min, max);
    }

    public Long zLexCount(byte[] key, Range range) {
        String min = this.value(range.getLowerBound(), "-");
        String max = this.value(range.getUpperBound(), "+");
        return (Long)this.read(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)ZLEXCOUNT, key, min, max);
    }

    public void rewriteConfig() {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.CONFIG_REWRITE, new Object[0]);
    }

    public Long zRangeStoreByLex(byte[] dstKey, byte[] srcKey, Range<byte[]> range, Limit limit) {
        String max = this.value(range.getUpperBound(), "+");
        String min = this.value(range.getLowerBound(), "-");
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(dstKey);
        args.add(srcKey);
        args.add(min);
        args.add(max);
        args.add("BYLEX");
        if (!limit.isUnlimited()) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Long)this.write(srcKey, (Codec)LongCodec.INSTANCE, ZRANGESTORE, args.toArray());
    }

    public Long zRangeStoreRevByLex(byte[] dstKey, byte[] srcKey, Range<byte[]> range, Limit limit) {
        String max = this.value(range.getUpperBound(), "+");
        String min = this.value(range.getLowerBound(), "-");
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(dstKey);
        args.add(srcKey);
        args.add(min);
        args.add(max);
        args.add("BYLEX");
        args.add("REV");
        if (!limit.isUnlimited()) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Long)this.write(srcKey, (Codec)LongCodec.INSTANCE, ZRANGESTORE, args.toArray());
    }

    public Long zRangeStoreByScore(byte[] dstKey, byte[] srcKey, Range<? extends Number> range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(dstKey);
        args.add(srcKey);
        args.add(min);
        args.add(max);
        args.add("BYSCORE");
        if (!limit.isUnlimited()) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Long)this.write(srcKey, (Codec)LongCodec.INSTANCE, ZRANGESTORE, args.toArray());
    }

    public Long zRangeStoreRevByScore(byte[] dstKey, byte[] srcKey, Range<? extends Number> range, Limit limit) {
        String min = this.value(range.getLowerBound(), "-inf");
        String max = this.value(range.getUpperBound(), "+inf");
        LinkedList<Object> args = new LinkedList<Object>();
        args.add(dstKey);
        args.add(srcKey);
        args.add(min);
        args.add(max);
        args.add("BYSCORE");
        args.add("REV");
        if (!limit.isUnlimited()) {
            args.add("LIMIT");
            args.add(limit.getOffset());
            args.add(limit.getCount());
        }
        return (Long)this.write(srcKey, (Codec)LongCodec.INSTANCE, ZRANGESTORE, args.toArray());
    }

    public void flushDb(RedisServerCommands.FlushOption option) {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.FLUSHDB, option.toString());
    }

    public void flushAll(RedisServerCommands.FlushOption option) {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.FLUSHALL, option.toString());
    }

    public void replicaOf(String host, int port) {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)REPLICAOF, host, port);
    }

    public void replicaOfNoOne() {
        this.write(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)REPLICAOF, "NO", "ONE");
    }

    public byte[] setGet(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)value, (String)"Value must not be null");
        Assert.notNull((Object)expiration, (String)"Expiration must not be null");
        Assert.notNull((Object)option, (String)"Option must not be null");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(value);
        switch (option) {
            case SET_IF_ABSENT: {
                params.add("NX");
                break;
            }
            case SET_IF_PRESENT: {
                params.add("XX");
            }
        }
        params.add("GET");
        if (expiration.isUnixTimestamp()) {
            if (expiration.getTimeUnit() == TimeUnit.MILLISECONDS) {
                params.add("PXAT");
                params.add(expiration.getExpirationTimeInMilliseconds());
            } else {
                params.add("EXAT");
                params.add(expiration.getExpirationTimeInSeconds());
            }
        } else if (!expiration.isPersistent()) {
            if (expiration.isKeepTtl()) {
                params.add("KEEPTTL");
            } else if (expiration.getTimeUnit() == TimeUnit.MILLISECONDS) {
                params.add("PX");
                params.add(expiration.getExpirationTime());
            } else {
                params.add("EX");
                params.add(expiration.getConverted(TimeUnit.SECONDS));
            }
        }
        return (byte[])this.read(key, (Codec)ByteArrayCodec.INSTANCE, SET_VALUE, params.toArray());
    }

    public Boolean expire(byte[] key, long seconds, ExpirationOptions.Condition condition) {
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        if (condition == ExpirationOptions.Condition.ALWAYS) {
            return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)EXPIRE, key, seconds);
        }
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)EXPIRE, key, seconds, condition);
    }

    public Boolean pExpire(byte[] key, long millis, ExpirationOptions.Condition condition) {
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        if (condition == ExpirationOptions.Condition.ALWAYS) {
            return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.PEXPIRE, key, millis);
        }
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.PEXPIRE, key, millis, condition);
    }

    public Boolean expireAt(byte[] key, long unixTime, ExpirationOptions.Condition condition) {
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        if (condition == ExpirationOptions.Condition.ALWAYS) {
            return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)EXPIREAT, key, unixTime);
        }
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)EXPIREAT, key, unixTime, condition);
    }

    public Boolean pExpireAt(byte[] key, long unixTimeInMillis, ExpirationOptions.Condition condition) {
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        if (condition == ExpirationOptions.Condition.ALWAYS) {
            return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.PEXPIREAT, key, unixTimeInMillis);
        }
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)org.redisson.client.protocol.RedisCommands.PEXPIREAT, key, unixTimeInMillis, condition);
    }

    public List<Long> hExpire(byte[] key, long seconds, ExpirationOptions.Condition condition, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"key must not be null");
        if (fields.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(seconds);
        if (condition != ExpirationOptions.Condition.ALWAYS) {
            params.add(condition.name());
        }
        params.add("FIELDS");
        params.add(fields.length);
        Collections.addAll(params, fields);
        return (List)this.write(key, (Codec)LongCodec.INSTANCE, HEXPIRE, params.toArray());
    }

    public List<Long> hpExpire(byte[] key, long millis, ExpirationOptions.Condition condition, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"key must not be null");
        if (fields.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(millis);
        if (condition != ExpirationOptions.Condition.ALWAYS) {
            args.add(condition.name());
        }
        args.add("FIELDS");
        args.add(fields.length);
        Collections.addAll(args, fields);
        return (List)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)HPEXPIRE, args.toArray());
    }

    public List<Long> hExpireAt(byte[] key, long unixTime, ExpirationOptions.Condition condition, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        Assert.notNull((Object)condition, (String)"Condition must not be null");
        if (fields.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(unixTime);
        if (condition != ExpirationOptions.Condition.ALWAYS) {
            args.add(condition.name());
        }
        args.add("FIELDS");
        args.add(fields.length);
        args.addAll(Arrays.asList(fields));
        return (List)this.read(key, (Codec)LongCodec.INSTANCE, HEXPIREAT, args.toArray());
    }

    public List<Long> hpExpireAt(byte[] key, long unixTimeInMillis, ExpirationOptions.Condition condition, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"Key must not be null");
        if (fields.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(key);
        args.add(unixTimeInMillis);
        if (condition != null && condition != ExpirationOptions.Condition.ALWAYS) {
            args.add(condition.name());
        }
        args.add("FIELDS");
        args.add(fields.length);
        args.addAll(Arrays.asList(fields));
        return (List)this.write(key, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)HPEXPIREAT, args.toArray());
    }

    public List<Long> hPersist(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"key must not be null");
        if (fields.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add("FIELDS");
        params.add(fields.length);
        Collections.addAll(params, fields);
        return (List)this.write(key, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)HPERSIST, params.toArray());
    }

    public List<Long> hTtl(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"key must not be null");
        if (fields.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add("FIELDS");
        params.add(fields.length);
        Collections.addAll(params, fields);
        return (List)this.write(key, (Codec)LongCodec.INSTANCE, HTTL, params.toArray());
    }

    public List<Long> hTtl(byte[] key, TimeUnit timeUnit, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"key must not be null");
        Assert.notNull((Object)((Object)timeUnit), (String)"timeUnit must not be null");
        if (fields.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add("FIELDS");
        params.add(fields.length);
        Collections.addAll(params, fields);
        RedisCommand command = new RedisCommand("HTTL", (MultiDecoder)new ObjectListReplayDecoder(), (Convertor)new SecondsConvertor(timeUnit, TimeUnit.SECONDS){

            @Override
            public Long convert(Object obj) {
                if ((Long)obj < 0L) {
                    return (Long)obj;
                }
                return super.convert(obj);
            }
        });
        return (List)this.write(key, (Codec)LongCodec.INSTANCE, command, params.toArray());
    }

    public List<Long> hpTtl(byte[] key, byte[] ... fields) {
        Assert.notNull((Object)key, (String)"key must not be null");
        if (fields.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add("FIELDS");
        params.add(fields.length);
        Collections.addAll(params, fields);
        return (List)this.write(key, (Codec)LongCodec.INSTANCE, HPTTL, params.toArray());
    }

    public List<byte[]> hGetDel(byte[] key, byte[] ... fields) {
        ArrayList<Object> args = new ArrayList<Object>(fields.length + 1);
        args.add(key);
        args.add("FIELDS");
        args.add(fields.length);
        args.addAll(Arrays.asList(fields));
        return (List)this.write(key, (Codec)ByteArrayCodec.INSTANCE, HGETDEL, args.toArray());
    }

    public List<byte[]> hGetEx(byte[] key, Expiration expiration, byte[] ... fields) {
        ArrayList<Object> args = new ArrayList<Object>(fields.length + 1);
        args.add(key);
        if (expiration != null) {
            if (expiration.isUnixTimestamp()) {
                if (expiration.getTimeUnit() == TimeUnit.MILLISECONDS) {
                    args.add("PXAT");
                    args.add(expiration.getExpirationTimeInMilliseconds());
                } else {
                    args.add("EXAT");
                    args.add(expiration.getExpirationTimeInSeconds());
                }
            } else if (!expiration.isPersistent()) {
                if (expiration.getTimeUnit() == TimeUnit.MILLISECONDS) {
                    args.add("PX");
                    args.add(expiration.getExpirationTime());
                } else {
                    args.add("EX");
                    args.add(expiration.getConverted(TimeUnit.SECONDS));
                }
            } else if (expiration.isPersistent()) {
                args.add("PERSIST");
            }
        }
        args.add("FIELDS");
        args.add(fields.length);
        args.addAll(Arrays.asList(fields));
        return (List)this.write(key, (Codec)ByteArrayCodec.INSTANCE, HGETDEL, args.toArray());
    }

    public Boolean hSetEx(byte[] key, Map<byte[], byte[]> hashes, RedisHashCommands.HashFieldSetOption condition, Expiration expiration) {
        ArrayList<Object> params = new ArrayList<Object>(hashes.size() * 2 + 3);
        params.add(key);
        if (condition == RedisHashCommands.HashFieldSetOption.IF_NONE_EXIST) {
            params.add("FNX");
        }
        if (condition == RedisHashCommands.HashFieldSetOption.IF_ALL_EXIST) {
            params.add("FXX");
        }
        if (expiration != null) {
            if (expiration.isUnixTimestamp()) {
                if (expiration.getTimeUnit() == TimeUnit.MILLISECONDS) {
                    params.add("PXAT");
                    params.add(expiration.getExpirationTimeInMilliseconds());
                } else {
                    params.add("EXAT");
                    params.add(expiration.getExpirationTimeInSeconds());
                }
            } else if (!expiration.isPersistent()) {
                if (expiration.isKeepTtl()) {
                    params.add("KEEPTTL");
                } else if (expiration.getTimeUnit() == TimeUnit.MILLISECONDS) {
                    params.add("PX");
                    params.add(expiration.getExpirationTime());
                } else {
                    params.add("EX");
                    params.add(expiration.getConverted(TimeUnit.SECONDS));
                }
            }
        }
        params.add("FIELDS");
        params.add(hashes.size());
        hashes.forEach((k, v) -> {
            params.add(k);
            params.add(v);
        });
        return (Boolean)this.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)HSETEX, key, params.toArray());
    }

    public Long sInterCard(byte[] ... keys) {
        ArrayList<Integer> args = new ArrayList<Integer>(keys.length);
        args.add(keys.length);
        args.addAll(Arrays.asList(keys));
        return (Long)this.write(keys[0], (Codec)StringCodec.INSTANCE, (RedisCommand<?>)SINTERCARD, args.toArray());
    }

    public RedisCommands commands() {
        return this;
    }

    public RedisGeoCommands geoCommands() {
        return this;
    }

    public RedisHashCommands hashCommands() {
        return this;
    }

    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return this;
    }

    public RedisKeyCommands keyCommands() {
        return this;
    }

    public RedisListCommands listCommands() {
        return this;
    }

    public RedisSetCommands setCommands() {
        return this;
    }

    public RedisScriptingCommands scriptingCommands() {
        return this;
    }

    public RedisServerCommands serverCommands() {
        return this;
    }

    public RedisStringCommands stringCommands() {
        return this;
    }

    public RedisZSetCommands zSetCommands() {
        return this;
    }
}

