/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.Convertor;
import org.redisson.client.protocol.convertor.EmptyMapConvertor;
import org.redisson.client.protocol.decoder.CodecDecoder;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.MapEntriesDecoder;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectDecoder;
import org.redisson.client.protocol.decoder.StreamIdDecoder;
import org.redisson.client.protocol.decoder.StreamObjectMapReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.spring.data.connection.RedissonConnection;
import org.springframework.data.domain.Range;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.util.Assert;

public class RedissonStreamCommands
implements RedisStreamCommands {
    private final RedissonConnection connection;
    private final CommandAsyncExecutor executor;
    private static final RedisStrictCommand<RecordId> XADD = new RedisStrictCommand("XADD", obj -> RecordId.of((String)obj.toString()));
    private static final RedisStrictCommand<String> XGROUP_STRING = new RedisStrictCommand("XGROUP");
    private static final RedisStrictCommand<Boolean> XGROUP_BOOLEAN = new RedisStrictCommand("XGROUP", obj -> (Long)obj > 0L);
    private static final RedisCommand<List<ByteRecord>> XREAD = new RedisCommand("XREAD", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ByteRecordReplayDecoder2(), new ObjectDecoder(StringCodec.INSTANCE.getValueDecoder()), new ObjectDecoder((Decoder)new StreamIdDecoder()), new ObjectDecoder((Decoder)new StreamIdDecoder()), new MapEntriesDecoder((MultiDecoder)new StreamObjectMapReplayDecoder())}));
    private static final RedisCommand<List<ByteRecord>> XREAD_BLOCKING = new RedisCommand("XREAD", XREAD.getReplayMultiDecoder());
    private static final RedisCommand<List<ByteRecord>> XREADGROUP = new RedisCommand("XREADGROUP", XREAD.getReplayMultiDecoder());
    private static final RedisCommand<List<ByteRecord>> XREADGROUP_BLOCKING = new RedisCommand("XREADGROUP", XREADGROUP.getReplayMultiDecoder());
    private static final RedisCommand<List<ByteRecord>> XREAD_V2 = new RedisCommand("XREAD", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ByteRecordReplayDecoder2_V2(), new CodecDecoder(), new ObjectDecoder((Decoder)new StreamIdDecoder()), new StreamObjectMapReplayDecoder()}), (Convertor)new EmptyMapConvertor());
    private static final RedisCommand<List<ByteRecord>> XREAD_BLOCKING_V2 = new RedisCommand("XREAD", XREAD_V2.getReplayMultiDecoder());
    private static final RedisCommand<List<ByteRecord>> XREADGROUP_V2 = new RedisCommand("XREADGROUP", XREAD_V2.getReplayMultiDecoder());
    private static final RedisCommand<List<ByteRecord>> XREADGROUP_BLOCKING_V2 = new RedisCommand("XREADGROUP", XREADGROUP_V2.getReplayMultiDecoder());

    public RedissonStreamCommands(RedissonConnection connection, CommandAsyncExecutor executor) {
        this.connection = connection;
        this.executor = executor;
    }

    private static List<String> toStringList(RecordId ... recordIds) {
        if (recordIds.length == 1) {
            return Arrays.asList(recordIds[0].getValue());
        }
        return Arrays.stream(recordIds).map(RecordId::getValue).collect(Collectors.toList());
    }

    public Long xAck(byte[] key, String group, RecordId ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)group, (String)"Group must not be null!");
        Assert.notNull((Object)recordIds, (String)"recordIds must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.add(group);
        params.addAll(RedissonStreamCommands.toStringList(recordIds));
        return (Long)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.XACK, params.toArray());
    }

    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record) {
        Assert.notNull(record, (String)"record must not be null!");
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(record.getStream());
        params.add(record.getId().getValue());
        ((Map)record.getValue()).forEach((key, value) -> {
            params.add(key);
            params.add(value);
        });
        return (RecordId)this.connection.write((byte[])record.getStream(), (Codec)StringCodec.INSTANCE, (RedisCommand<?>)XADD, params.toArray());
    }

    public Long xDel(byte[] key, RecordId ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)recordIds, (String)"recordIds must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(key);
        params.addAll(RedissonStreamCommands.toStringList(recordIds));
        return (Long)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.XDEL, params.toArray());
    }

    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)groupName, (String)"GroupName must not be null!");
        Assert.notNull((Object)readOffset, (String)"ReadOffset must not be null!");
        return (String)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)XGROUP_STRING, "CREATE", key, groupName, readOffset.getOffset(), "MKSTREAM");
    }

    public Boolean xGroupDelConsumer(byte[] key, Consumer consumer) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)consumer, (String)"Consumer must not be null!");
        Assert.notNull((Object)consumer.getName(), (String)"Consumer name must not be null!");
        Assert.notNull((Object)consumer.getGroup(), (String)"Consumer group must not be null!");
        return (Boolean)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)XGROUP_BOOLEAN, "DELCONSUMER", key, consumer.getGroup(), consumer.getName());
    }

    public Boolean xGroupDestroy(byte[] key, String groupName) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)groupName, (String)"GroupName must not be null!");
        return (Boolean)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)XGROUP_BOOLEAN, "DESTROY", key, groupName);
    }

    public Long xLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return (Long)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.XLEN, new Object[]{key});
    }

    private List<ByteRecord> range(RedisCommand<?> rangeCommand, byte[] key, Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(key);
        if (rangeCommand.getName().equals(RedisCommands.XRANGE.getName())) {
            params.add(this.toLowerBound(range));
            params.add(this.toUpperBound(range));
        } else {
            params.add(this.toUpperBound(range));
            params.add(this.toLowerBound(range));
        }
        if (limit.getCount() > 0) {
            params.add("COUNT");
            params.add(limit.getCount());
        }
        return (List)this.connection.write(key, (Codec)ByteArrayCodec.INSTANCE, rangeCommand, params.toArray());
    }

    String toLowerBound(Range range) {
        StringBuilder s = new StringBuilder();
        if (!range.getLowerBound().isInclusive()) {
            s.append("(");
        }
        if (!range.getLowerBound().getValue().isPresent() || range.getLowerBound().getValue().get().toString().isEmpty()) {
            s.append("-");
        } else {
            s.append(range.getLowerBound().getValue().get());
        }
        return s.toString();
    }

    String toUpperBound(Range range) {
        StringBuilder s = new StringBuilder();
        if (!range.getUpperBound().isInclusive()) {
            s.append("(");
        }
        if (!range.getUpperBound().getValue().isPresent() || range.getUpperBound().getValue().get().toString().isEmpty()) {
            s.append("+");
        } else {
            s.append(range.getUpperBound().getValue().get());
        }
        return s.toString();
    }

    public List<ByteRecord> xRange(byte[] key, Range<String> range, RedisZSetCommands.Limit limit) {
        return this.range(new RedisCommand("XRANGE", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ByteRecordReplayDecoder(key), new ObjectDecoder((Decoder)new StreamIdDecoder()), new MapEntriesDecoder((MultiDecoder)new StreamObjectMapReplayDecoder())})), key, range, limit);
    }

    public List<ByteRecord> xRead(StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, (String)"ReadOptions must not be null!");
        Assert.notNull(streams, (String)"StreamOffsets must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        if (readOptions.getCount() != null && readOptions.getCount() > 0L) {
            params.add("COUNT");
            params.add(readOptions.getCount());
        }
        if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
            params.add("BLOCK");
            params.add(readOptions.getBlock());
        }
        params.add("STREAMS");
        for (StreamOffset<byte[]> streamOffset : streams) {
            params.add(streamOffset.getKey());
        }
        for (StreamOffset<byte[]> streamOffset : streams) {
            params.add(streamOffset.getOffset().getOffset());
        }
        if (this.executor.getServiceManager().isResp3()) {
            if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
                return (List)this.connection.read((byte[])streams[0].getKey(), (Codec)ByteArrayCodec.INSTANCE, XREAD_BLOCKING_V2, params.toArray());
            }
            return (List)this.connection.read((byte[])streams[0].getKey(), (Codec)ByteArrayCodec.INSTANCE, XREAD_V2, params.toArray());
        }
        if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
            return (List)this.connection.read((byte[])streams[0].getKey(), (Codec)ByteArrayCodec.INSTANCE, XREAD_BLOCKING, params.toArray());
        }
        return (List)this.connection.read((byte[])streams[0].getKey(), (Codec)ByteArrayCodec.INSTANCE, XREAD, params.toArray());
    }

    public List<ByteRecord> xReadGroup(Consumer consumer, StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, (String)"Consumer must not be null!");
        Assert.notNull((Object)readOptions, (String)"ReadOptions must not be null!");
        Assert.notNull(streams, (String)"StreamOffsets must not be null!");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("GROUP");
        params.add(consumer.getGroup());
        params.add(consumer.getName());
        if (readOptions.getCount() != null && readOptions.getCount() > 0L) {
            params.add("COUNT");
            params.add(readOptions.getCount());
        }
        if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
            params.add("BLOCK");
            params.add(readOptions.getBlock());
        }
        if (readOptions.isNoack()) {
            params.add("NOACK");
        }
        params.add("STREAMS");
        for (StreamOffset<byte[]> streamOffset : streams) {
            params.add(streamOffset.getKey());
        }
        for (StreamOffset<byte[]> streamOffset : streams) {
            params.add(streamOffset.getOffset().getOffset());
        }
        if (this.executor.getServiceManager().isResp3()) {
            if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
                return (List)this.connection.write((byte[])streams[0].getKey(), (Codec)ByteArrayCodec.INSTANCE, XREADGROUP_BLOCKING_V2, params.toArray());
            }
            return (List)this.connection.write((byte[])streams[0].getKey(), (Codec)ByteArrayCodec.INSTANCE, XREADGROUP_V2, params.toArray());
        }
        if (readOptions.getBlock() != null && readOptions.getBlock() > 0L) {
            return (List)this.connection.write((byte[])streams[0].getKey(), (Codec)ByteArrayCodec.INSTANCE, XREADGROUP_BLOCKING, params.toArray());
        }
        return (List)this.connection.write((byte[])streams[0].getKey(), (Codec)ByteArrayCodec.INSTANCE, XREADGROUP, params.toArray());
    }

    public List<ByteRecord> xRevRange(byte[] key, Range<String> range, RedisZSetCommands.Limit limit) {
        return this.range(new RedisCommand("XREVRANGE", (MultiDecoder)new ListMultiDecoder2(new MultiDecoder[]{new ByteRecordReplayDecoder(key), new ObjectDecoder((Decoder)new StreamIdDecoder()), new MapEntriesDecoder((MultiDecoder)new StreamObjectMapReplayDecoder())})), key, range, limit);
    }

    public Long xTrim(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)count, (String)"Count must not be null!");
        return (Long)this.connection.write(key, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)RedisCommands.XTRIM, key, "MAXLEN", count);
    }

    static {
        RedisCommands.BLOCKING_COMMANDS.add(XREAD_BLOCKING);
        RedisCommands.BLOCKING_COMMANDS.add(XREADGROUP_BLOCKING);
        RedisCommands.BLOCKING_COMMANDS.add(XREAD_BLOCKING_V2);
        RedisCommands.BLOCKING_COMMANDS.add(XREADGROUP_BLOCKING_V2);
    }

    private static class ByteRecordReplayDecoder
    implements MultiDecoder<List<ByteRecord>> {
        private final byte[] key;

        ByteRecordReplayDecoder(byte[] key) {
            this.key = key;
        }

        public List<ByteRecord> decode(List<Object> parts, State state) {
            List<Object> list = parts;
            ArrayList<ByteRecord> result = new ArrayList<ByteRecord>(parts.size() / 2);
            for (List list2 : list) {
                ByteRecord record = StreamRecords.newRecord().in((Object)this.key).withId(RecordId.of((String)list2.get(0).toString())).ofBytes((Map)list2.get(1));
                result.add(record);
            }
            return result;
        }
    }

    private static class ByteRecordReplayDecoder2
    implements MultiDecoder<List<ByteRecord>> {
        private ByteRecordReplayDecoder2() {
        }

        public List<ByteRecord> decode(List<Object> parts, State state) {
            List<Object> list = parts;
            ArrayList<ByteRecord> result = new ArrayList<ByteRecord>(parts.size() / 2);
            for (List list2 : list) {
                List streamEntries = (List)list2.get(1);
                if (streamEntries.isEmpty()) continue;
                String name = (String)list2.get(0);
                for (List se : streamEntries) {
                    ByteRecord record = StreamRecords.newRecord().in((Object)name.getBytes()).withId(RecordId.of((String)se.get(0).toString())).ofBytes((Map)se.get(1));
                    result.add(record);
                }
            }
            return result;
        }
    }

    private static class ByteRecordReplayDecoder2_V2
    implements MultiDecoder<List<ByteRecord>> {
        private ByteRecordReplayDecoder2_V2() {
        }

        public List<ByteRecord> decode(List<Object> parts, State state) {
            List<Object> list = parts;
            ArrayList<ByteRecord> result = new ArrayList<ByteRecord>(parts.size() / 2);
            for (int i = 0; i < list.size(); i += 2) {
                List streamEntries = (List)list.get(i + 1);
                if (streamEntries.isEmpty()) continue;
                byte[] name = (byte[])list.get(0);
                for (List se : streamEntries) {
                    ByteRecord record = StreamRecords.newRecord().in((Object)name).withId(RecordId.of((String)se.get(0).toString())).ofBytes((Map)se.get(1));
                    result.add(record);
                }
            }
            return result;
        }
    }
}

