/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.api.RedissonClient;
import org.redisson.client.RedisException;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.decoder.MultiDecoder;
import org.redisson.client.protocol.decoder.ObjectListReplayDecoder;
import org.redisson.client.protocol.decoder.StringMapDataDecoder;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.spring.data.connection.RedisClusterNodeDecoder;
import org.redisson.spring.data.connection.RedissonConnection;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.connection.ClusterInfo;
import org.springframework.data.redis.connection.RedisClusterCommands;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.convert.StringToRedisClientInfoConverter;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.util.Assert;

public class RedissonClusterConnection
extends RedissonConnection
implements RedisClusterConnection {
    private static final RedisStrictCommand<List<RedisClusterNode>> CLUSTER_NODES = new RedisStrictCommand("CLUSTER", "NODES", (Decoder)new RedisClusterNodeDecoder());
    private static final RedisStrictCommand<List<String>> CLUSTER_GETKEYSINSLOT = new RedisStrictCommand("CLUSTER", "GETKEYSINSLOT", (MultiDecoder)new ObjectListReplayDecoder());
    private static final StringToRedisClientInfoConverter CONVERTER = new StringToRedisClientInfoConverter();

    public RedissonClusterConnection(RedissonClient redisson) {
        super(redisson);
    }

    public Iterable<RedisClusterNode> clusterGetNodes() {
        return (Iterable)this.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand<?>)CLUSTER_NODES, new Object[0]);
    }

    public Collection<RedisClusterNode> clusterGetSlaves(RedisClusterNode master) {
        Iterable<RedisClusterNode> res = this.clusterGetNodes();
        RedisClusterNode masterNode = null;
        for (RedisClusterNode redisClusterNode : res) {
            if (!master.getHost().equals(redisClusterNode.getHost()) || !master.getPort().equals(redisClusterNode.getPort())) continue;
            masterNode = redisClusterNode;
            break;
        }
        if (masterNode == null) {
            throw new IllegalStateException("Unable to find master node: " + master);
        }
        Iterator<RedisClusterNode> iterator = res.iterator();
        while (iterator.hasNext()) {
            RedisClusterNode redisClusterNode;
            redisClusterNode = iterator.next();
            if (redisClusterNode.getMasterId() != null && redisClusterNode.getMasterId().equals(masterNode.getId())) continue;
            iterator.remove();
        }
        return (Collection)res;
    }

    public Map<RedisClusterNode, Collection<RedisClusterNode>> clusterGetMasterSlaveMap() {
        Iterable<RedisClusterNode> res = this.clusterGetNodes();
        HashSet<RedisClusterNode> masters = new HashSet<RedisClusterNode>();
        for (RedisClusterNode redisClusterNode : res) {
            if (!redisClusterNode.isMaster()) continue;
            masters.add(redisClusterNode);
        }
        HashMap<RedisClusterNode, Collection<RedisClusterNode>> result = new HashMap<RedisClusterNode, Collection<RedisClusterNode>>();
        for (RedisClusterNode redisClusterNode : res) {
            for (RedisClusterNode masterNode : masters) {
                if (redisClusterNode.getMasterId() == null || !redisClusterNode.getMasterId().equals(masterNode.getId())) continue;
                ArrayList<RedisClusterNode> list = (ArrayList<RedisClusterNode>)result.get(masterNode);
                if (list == null) {
                    list = new ArrayList<RedisClusterNode>();
                    result.put(masterNode, list);
                }
                list.add(redisClusterNode);
            }
        }
        return result;
    }

    public Integer clusterGetSlotForKey(byte[] key) {
        RFuture f = this.executorService.readAsync((String)null, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.KEYSLOT, new Object[]{key});
        return (Integer)this.syncFuture(f);
    }

    public RedisClusterNode clusterGetNodeForSlot(int slot) {
        Iterable<RedisClusterNode> res = this.clusterGetNodes();
        for (RedisClusterNode redisClusterNode : res) {
            if (!redisClusterNode.isMaster() || !redisClusterNode.getSlotRange().contains(slot)) continue;
            return redisClusterNode;
        }
        return null;
    }

    public RedisClusterNode clusterGetNodeForKey(byte[] key) {
        int slot = this.executorService.getConnectionManager().calcSlot(key);
        return this.clusterGetNodeForSlot(slot);
    }

    public ClusterInfo clusterGetClusterInfo() {
        RFuture f = this.executorService.readAsync((String)null, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_INFO, new Object[0]);
        this.syncFuture(f);
        Properties props = new Properties();
        for (Map.Entry entry : ((Map)f.getNow()).entrySet()) {
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return new ClusterInfo(props);
    }

    public void clusterAddSlots(RedisClusterNode node, int ... slots) {
        MasterSlaveEntry entry = this.getEntry(node);
        List<Integer> params = this.convert(slots);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_ADDSLOTS, params.toArray());
        this.syncFuture(f);
    }

    protected List<Integer> convert(int ... slots) {
        ArrayList<Integer> params = new ArrayList<Integer>();
        for (int slot : slots) {
            params.add(slot);
        }
        return params;
    }

    public void clusterAddSlots(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        this.clusterAddSlots(node, range.getSlotsArray());
    }

    public Long clusterCountKeysInSlot(int slot) {
        RedisClusterNode node = this.clusterGetNodeForSlot(slot);
        MasterSlaveEntry entry = this.executorService.getConnectionManager().getEntry(new InetSocketAddress(node.getHost(), (int)node.getPort()));
        RFuture f = this.executorService.readAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_COUNTKEYSINSLOT, new Object[]{slot});
        return (Long)this.syncFuture(f);
    }

    public void clusterDeleteSlots(RedisClusterNode node, int ... slots) {
        MasterSlaveEntry entry = this.getEntry(node);
        List<Integer> params = this.convert(slots);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_DELSLOTS, params.toArray());
        this.syncFuture(f);
    }

    public void clusterDeleteSlotsInRange(RedisClusterNode node, RedisClusterNode.SlotRange range) {
        this.clusterDeleteSlots(node, range.getSlotsArray());
    }

    public void clusterForget(RedisClusterNode node) {
        RFuture f = this.executorService.writeAsync((String)null, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_FORGET, new Object[]{node.getId()});
        this.syncFuture(f);
    }

    public void clusterMeet(RedisClusterNode node) {
        Assert.notNull((Object)node, (String)"Cluster node must not be null for CLUSTER MEET command!");
        Assert.hasText((String)node.getHost(), (String)"Node to meet cluster must have a host!");
        Assert.isTrue((node.getPort() > 0 ? 1 : 0) != 0, (String)"Node to meet cluster must have a port greater 0!");
        RFuture f = this.executorService.writeAsync((String)null, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_MEET, new Object[]{node.getHost(), node.getPort()});
        this.syncFuture(f);
    }

    public void clusterSetSlot(RedisClusterNode node, int slot, RedisClusterCommands.AddSlots mode) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_SETSLOT, new Object[]{slot, mode});
        this.syncFuture(f);
    }

    public List<byte[]> clusterGetKeysInSlot(int slot, Integer count) {
        RFuture f = this.executorService.readAsync((String)null, (Codec)ByteArrayCodec.INSTANCE, CLUSTER_GETKEYSINSLOT, new Object[]{slot, count});
        return (List)this.syncFuture(f);
    }

    public void clusterReplicate(RedisClusterNode master, RedisClusterNode slave) {
        MasterSlaveEntry entry = this.getEntry(master);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLUSTER_REPLICATE, new Object[]{slave.getId()});
        this.syncFuture(f);
    }

    public String ping(RedisClusterNode node) {
        return (String)this.execute(node, RedisCommands.PING);
    }

    public void bgReWriteAof(RedisClusterNode node) {
        this.execute(node, (RedisCommand)RedisCommands.BGREWRITEAOF);
    }

    public void bgSave(RedisClusterNode node) {
        this.execute(node, (RedisCommand)RedisCommands.BGSAVE);
    }

    public Long lastSave(RedisClusterNode node) {
        return (Long)this.execute(node, (RedisCommand)RedisCommands.LASTSAVE);
    }

    public void save(RedisClusterNode node) {
        this.execute(node, (RedisCommand)RedisCommands.SAVE);
    }

    public Long dbSize(RedisClusterNode node) {
        return (Long)this.execute(node, (RedisCommand)RedisCommands.DBSIZE);
    }

    private <T> T execute(RedisClusterNode node, RedisCommand<T> command) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, command, new Object[0]);
        return (T)this.syncFuture(f);
    }

    protected MasterSlaveEntry getEntry(RedisClusterNode node) {
        MasterSlaveEntry entry = this.executorService.getConnectionManager().getEntry(new InetSocketAddress(node.getHost(), (int)node.getPort()));
        return entry;
    }

    public void flushDb(RedisClusterNode node) {
        this.execute(node, (RedisCommand)RedisCommands.FLUSHDB);
    }

    public void flushAll(RedisClusterNode node) {
        this.execute(node, (RedisCommand)RedisCommands.FLUSHALL);
    }

    public Properties info(RedisClusterNode node) {
        Map info = (Map)this.execute(node, (RedisCommand)RedisCommands.INFO_ALL);
        Properties result = new Properties();
        for (Map.Entry entry : info.entrySet()) {
            result.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    public Properties info(RedisClusterNode node, String section) {
        RedisStrictCommand command = new RedisStrictCommand("INFO", section, (Decoder)new StringMapDataDecoder());
        Map info = (Map)this.execute(node, (RedisCommand)command);
        Properties result = new Properties();
        for (Map.Entry entry : info.entrySet()) {
            result.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return result;
    }

    public Set<byte[]> keys(RedisClusterNode node, byte[] pattern) {
        RFuture f = this.executorService.readAllAsync((RedisCommand)RedisCommands.KEYS, new Object[]{pattern});
        Collection keys = (Collection)this.syncFuture(f);
        HashSet<byte[]> result = new HashSet<byte[]>();
        for (String key : keys) {
            result.add(key.getBytes(CharsetUtil.UTF_8));
        }
        return result;
    }

    public byte[] randomKey(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readRandomAsync(entry, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.RANDOM_KEY, new Object[0]);
        return (byte[])this.syncFuture(f);
    }

    public void shutdown(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readAsync(entry, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.SHUTDOWN, new Object[0]);
        this.syncFuture(f);
    }

    public List<String> getConfig(RedisClusterNode node, String pattern) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CONFIG_GET, new Object[]{pattern});
        return (List)this.syncFuture(f);
    }

    public void setConfig(RedisClusterNode node, String param, String value) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CONFIG_SET, new Object[]{param, value});
        this.syncFuture(f);
    }

    public void resetConfigStats(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.writeAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CONFIG_RESETSTAT, new Object[0]);
        this.syncFuture(f);
    }

    public Long time(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readAsync(entry, (Codec)LongCodec.INSTANCE, (RedisCommand)RedisCommands.TIME_LONG, new Object[0]);
        return (Long)this.syncFuture(f);
    }

    public List<RedisClientInfo> getClientList(RedisClusterNode node) {
        MasterSlaveEntry entry = this.getEntry(node);
        RFuture f = this.executorService.readAsync(entry, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.CLIENT_LIST, new Object[0]);
        List list = (List)this.syncFuture(f);
        return CONVERTER.convert(list.toArray(new String[list.size()]));
    }

    @Override
    public void rename(byte[] oldName, byte[] newName) {
        if (this.isPipelined()) {
            throw new InvalidDataAccessResourceUsageException("Clustered rename is not supported in a pipeline");
        }
        if (this.redisson.getConnectionManager().calcSlot(oldName) == this.redisson.getConnectionManager().calcSlot(newName)) {
            super.rename(oldName, newName);
            return;
        }
        byte[] value = this.dump(oldName);
        if (null != value) {
            Long sourceTtlInSeconds = this.ttl(oldName);
            long ttlInMilliseconds = null != sourceTtlInSeconds && sourceTtlInSeconds > 0L ? sourceTtlInSeconds * 1000L : 0L;
            this.restore(newName, ttlInMilliseconds, value);
            this.del(new byte[][]{oldName});
        }
    }

    @Override
    public Boolean renameNX(byte[] oldName, byte[] newName) {
        if (this.isPipelined()) {
            throw new InvalidDataAccessResourceUsageException("Clustered rename is not supported in a pipeline");
        }
        if (this.redisson.getConnectionManager().calcSlot(oldName) == this.redisson.getConnectionManager().calcSlot(newName)) {
            return super.renameNX(oldName, newName);
        }
        byte[] value = this.dump(oldName);
        if (null != value && !this.exists(newName).booleanValue()) {
            Long sourceTtlInSeconds = this.ttl(oldName);
            long ttlInMilliseconds = null != sourceTtlInSeconds && sourceTtlInSeconds > 0L ? sourceTtlInSeconds * 1000L : 0L;
            this.restore(newName, ttlInMilliseconds, value);
            this.del(new byte[][]{oldName});
            return true;
        }
        return false;
    }

    private void checkExecution(RPromise<Long> result, AtomicReference<Throwable> failed, AtomicLong count, AtomicLong executed) {
        if (executed.decrementAndGet() == 0L) {
            if (failed.get() != null) {
                if (count.get() > 0L) {
                    RedisException ex = new RedisException("" + count.get() + " keys has been deleted. But one or more nodes has an error", failed.get());
                    result.tryFailure((Throwable)ex);
                } else {
                    result.tryFailure(failed.get());
                }
            } else {
                result.trySuccess((Object)count.get());
            }
        }
    }

    private RFuture<Long> executeAsync(RedisStrictCommand<Long> command, byte[] ... keys) {
        HashMap<MasterSlaveEntry, List> range2key = new HashMap<MasterSlaveEntry, List>();
        for (byte[] key : keys) {
            int slot = this.executorService.getConnectionManager().calcSlot(key);
            MasterSlaveEntry entry = this.executorService.getConnectionManager().getEntry(slot);
            List list = range2key.computeIfAbsent(entry, k -> new ArrayList());
            list.add(key);
        }
        RedissonPromise result = new RedissonPromise();
        AtomicReference failed = new AtomicReference();
        AtomicLong count = new AtomicLong();
        AtomicLong executed = new AtomicLong(range2key.size());
        BiConsumer<BatchResult, Throwable> listener = (arg_0, arg_1) -> this.lambda$executeAsync$1(count, failed, (RPromise)result, executed, arg_0, arg_1);
        for (Map.Entry entry : range2key.entrySet()) {
            CommandBatchService es = new CommandBatchService(this.executorService.getConnectionManager());
            for (byte[] key : (List)entry.getValue()) {
                es.writeAsync((MasterSlaveEntry)entry.getKey(), null, command, new Object[]{key});
            }
            RFuture future = es.executeAsync();
            future.onComplete(listener);
        }
        return result;
    }

    @Override
    public Long del(byte[] ... keys) {
        if (this.isQueueing() || this.isPipelined()) {
            for (byte[] key : keys) {
                this.write(key, (Codec)LongCodec.INSTANCE, (RedisCommand<?>)RedisCommands.DEL, new Object[]{key});
            }
            return null;
        }
        RFuture<Long> f = this.executeAsync((RedisStrictCommand<Long>)RedisCommands.DEL, keys);
        return this.sync(f);
    }

    private /* synthetic */ void lambda$executeAsync$1(AtomicLong count, AtomicReference failed, RPromise result, AtomicLong executed, BatchResult r, Throwable u) {
        if (u == null) {
            List result1 = r.getResponses();
            for (Long res : result1) {
                if (res == null) continue;
                count.addAndGet(res);
            }
        } else {
            failed.set(u);
        }
        this.checkExecution((RPromise<Long>)result, failed, count, executed);
    }
}

