/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.starter;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.RedissonRxClient;
import org.redisson.config.BaseConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.redisson.spring.starter.RedissonAutoConfigurationCustomizer;
import org.redisson.spring.starter.RedissonProperties;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.io.Resource;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.ReflectionUtils;

@Configuration
@ConditionalOnClass(value={Redisson.class, RedisOperations.class})
@AutoConfigureBefore(value={RedisAutoConfiguration.class})
@EnableConfigurationProperties(value={RedissonProperties.class, RedisProperties.class})
public class RedissonAutoConfiguration {
    private static final String REDIS_PROTOCOL_PREFIX = "redis://";
    private static final String REDISS_PROTOCOL_PREFIX = "rediss://";
    @Autowired(required=false)
    private List<RedissonAutoConfigurationCustomizer> redissonAutoConfigurationCustomizers;
    @Autowired
    private RedissonProperties redissonProperties;
    @Autowired
    private RedisProperties redisProperties;
    @Autowired
    private ApplicationContext ctx;

    @Bean
    @ConditionalOnMissingBean(name={"redisTemplate"})
    public RedisTemplate<Object, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(value={StringRedisTemplate.class})
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        StringRedisTemplate template = new StringRedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        return template;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public RedissonConnectionFactory redissonConnectionFactory(RedissonClient redisson) {
        return new RedissonConnectionFactory(redisson);
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(value={RedissonReactiveClient.class})
    public RedissonReactiveClient redissonReactive(RedissonClient redisson) {
        return redisson.reactive();
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean(value={RedissonRxClient.class})
    public RedissonRxClient redissonRxJava(RedissonClient redisson) {
        return redisson.rxJava();
    }

    private boolean hasConnectionDetails() {
        try {
            Class.forName("org.springframework.boot.autoconfigure.data.redis.RedisConnectionDetails");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={RedissonClient.class})
    public RedissonClient redisson() throws IOException {
        ClusterServersConfig c;
        ObjectProvider provider;
        RedisConnectionDetails b;
        Method nodesMethod;
        String[] nodes;
        Config config;
        ObjectProvider provider2;
        RedisConnectionDetails b2;
        Method clusterMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getCluster");
        Method usernameMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getUsername");
        Method timeoutMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getTimeout");
        Method connectTimeoutMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getConnectTimeout");
        Method clientNameMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getClientName");
        Object timeoutValue = ReflectionUtils.invokeMethod((Method)timeoutMethod, (Object)this.redisProperties);
        String prefix = this.getPrefix();
        String username = null;
        int database = this.redisProperties.getDatabase();
        String password = this.redisProperties.getPassword();
        boolean isSentinel = false;
        boolean isCluster = false;
        if (this.hasConnectionDetails() && (b2 = (RedisConnectionDetails)(provider2 = this.ctx.getBeanProvider(RedisConnectionDetails.class)).getIfAvailable()) != null) {
            password = b2.getPassword();
            username = b2.getUsername();
            if (b2.getSentinel() != null) {
                isSentinel = true;
            }
            if (b2.getCluster() != null) {
                isCluster = true;
            }
        }
        Integer timeout = null;
        if (timeoutValue instanceof Duration) {
            timeout = (int)((Duration)timeoutValue).toMillis();
        } else if (timeoutValue != null) {
            timeout = (Integer)timeoutValue;
        }
        Integer connectTimeout = null;
        if (connectTimeoutMethod != null) {
            Object connectTimeoutValue = ReflectionUtils.invokeMethod((Method)connectTimeoutMethod, (Object)this.redisProperties);
            if (connectTimeoutValue != null) {
                connectTimeout = (int)((Duration)connectTimeoutValue).toMillis();
            }
        } else {
            connectTimeout = timeout;
        }
        String clientName = null;
        if (clientNameMethod != null) {
            clientName = (String)ReflectionUtils.invokeMethod((Method)clientNameMethod, (Object)this.redisProperties);
        }
        if (usernameMethod != null) {
            username = (String)ReflectionUtils.invokeMethod((Method)usernameMethod, (Object)this.redisProperties);
        }
        if (this.redissonProperties.getConfig() != null) {
            try {
                config = Config.fromYAML((String)this.redissonProperties.getConfig());
            }
            catch (IOException e) {
                try {
                    config = Config.fromJSON((String)this.redissonProperties.getConfig());
                }
                catch (IOException e1) {
                    e1.addSuppressed(e);
                    throw new IllegalArgumentException("Can't parse config", e1);
                }
            }
        } else if (this.redissonProperties.getFile() != null) {
            try {
                InputStream is = this.getConfigStream();
                config = Config.fromYAML((InputStream)is);
            }
            catch (IOException e) {
                try {
                    InputStream is = this.getConfigStream();
                    config = Config.fromJSON((InputStream)is);
                }
                catch (IOException e1) {
                    e1.addSuppressed(e);
                    throw new IllegalArgumentException("Can't parse config", e1);
                }
            }
        } else if (this.redisProperties.getSentinel() != null || isSentinel) {
            ObjectProvider provider3;
            RedisConnectionDetails b3;
            nodes = new String[]{};
            String sentinelMaster = null;
            if (this.redisProperties.getSentinel() != null) {
                nodesMethod = ReflectionUtils.findMethod(RedisProperties.Sentinel.class, (String)"getNodes");
                Object nodesValue = ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)this.redisProperties.getSentinel());
                nodes = nodesValue instanceof String ? this.convert(prefix, Arrays.asList(((String)nodesValue).split(","))) : this.convert(prefix, (List)nodesValue);
                sentinelMaster = this.redisProperties.getSentinel().getMaster();
            }
            String sentinelUsername = null;
            String sentinelPassword = null;
            if (this.hasConnectionDetails() && (b3 = (RedisConnectionDetails)(provider3 = this.ctx.getBeanProvider(RedisConnectionDetails.class)).getIfAvailable()) != null && b3.getSentinel() != null) {
                database = b3.getSentinel().getDatabase();
                sentinelMaster = b3.getSentinel().getMaster();
                nodes = this.convertNodes(prefix, b3.getSentinel().getNodes());
                sentinelUsername = b3.getSentinel().getUsername();
                sentinelPassword = b3.getSentinel().getPassword();
            }
            config = new Config();
            SentinelServersConfig c2 = (SentinelServersConfig)((SentinelServersConfig)((SentinelServersConfig)config.useSentinelServers().setMasterName(sentinelMaster).addSentinelAddress(nodes).setSentinelPassword(sentinelPassword).setSentinelUsername(sentinelUsername).setDatabase(database).setUsername(username)).setPassword(password)).setClientName(clientName);
            if (connectTimeout != null) {
                c2.setConnectTimeout(connectTimeout.intValue());
            }
            if (connectTimeoutMethod != null && timeout != null) {
                c2.setTimeout(timeout.intValue());
            }
            this.initSSL((BaseConfig<?>)c2);
        } else if (clusterMethod != null && ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties) != null || isCluster) {
            nodes = new String[]{};
            if (clusterMethod != null && ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties) != null) {
                Object clusterObject = ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties);
                nodesMethod = ReflectionUtils.findMethod(clusterObject.getClass(), (String)"getNodes");
                List nodesObject = (List)ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)clusterObject);
                nodes = this.convert(prefix, nodesObject);
            }
            if (this.hasConnectionDetails() && (b = (RedisConnectionDetails)(provider = this.ctx.getBeanProvider(RedisConnectionDetails.class)).getIfAvailable()) != null && b.getCluster() != null) {
                nodes = this.convertNodes(prefix, b.getCluster().getNodes());
            }
            config = new Config();
            c = (ClusterServersConfig)((ClusterServersConfig)((ClusterServersConfig)config.useClusterServers().addNodeAddress(nodes).setUsername(username)).setPassword(password)).setClientName(clientName);
            if (connectTimeout != null) {
                c.setConnectTimeout(connectTimeout.intValue());
            }
            if (connectTimeoutMethod != null && timeout != null) {
                c.setTimeout(timeout.intValue());
            }
            this.initSSL((BaseConfig<?>)c);
        } else {
            config = new Config();
            String singleAddr = prefix + this.redisProperties.getHost() + ":" + this.redisProperties.getPort();
            if (this.hasConnectionDetails() && (b = (RedisConnectionDetails)(provider = this.ctx.getBeanProvider(RedisConnectionDetails.class)).getIfAvailable()) != null && b.getStandalone() != null) {
                database = b.getStandalone().getDatabase();
                singleAddr = prefix + b.getStandalone().getHost() + ":" + b.getStandalone().getPort();
            }
            c = (SingleServerConfig)((SingleServerConfig)((SingleServerConfig)config.useSingleServer().setAddress(singleAddr).setDatabase(database).setUsername(username)).setPassword(password)).setClientName(clientName);
            if (connectTimeout != null) {
                c.setConnectTimeout(connectTimeout.intValue());
            }
            if (connectTimeoutMethod != null && timeout != null) {
                c.setTimeout(timeout.intValue());
            }
            this.initSSL((BaseConfig<?>)c);
        }
        if (this.redissonAutoConfigurationCustomizers != null) {
            for (RedissonAutoConfigurationCustomizer customizer : this.redissonAutoConfigurationCustomizers) {
                customizer.customize(config);
            }
        }
        return Redisson.create((Config)config);
    }

    private void initSSL(BaseConfig<?> config) {
        Method getSSLMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getSsl");
        if (getSSLMethod == null) {
            return;
        }
        RedisProperties.Ssl ssl = this.redisProperties.getSsl();
        if (ssl.getBundle() == null) {
            return;
        }
        ObjectProvider provider = this.ctx.getBeanProvider(SslBundles.class);
        SslBundles bundles = (SslBundles)provider.getIfAvailable();
        if (bundles == null) {
            return;
        }
        SslBundle b = bundles.getBundle(ssl.getBundle());
        if (b == null) {
            return;
        }
        config.setSslCiphers(b.getOptions().getCiphers());
        config.setSslProtocols(b.getOptions().getEnabledProtocols());
        config.setSslTrustManagerFactory(b.getManagers().getTrustManagerFactory());
        config.setSslKeyManagerFactory(b.getManagers().getKeyManagerFactory());
    }

    private String getPrefix() {
        Method isEnabledMethod;
        Boolean enabled;
        Object ss;
        String prefix = REDIS_PROTOCOL_PREFIX;
        Method isSSLMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"isSsl");
        Method getSSLMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getSsl");
        if (isSSLMethod != null) {
            if (((Boolean)ReflectionUtils.invokeMethod((Method)isSSLMethod, (Object)this.redisProperties)).booleanValue()) {
                prefix = REDISS_PROTOCOL_PREFIX;
            }
        } else if (getSSLMethod != null && (ss = ReflectionUtils.invokeMethod((Method)getSSLMethod, (Object)this.redisProperties)) != null && (enabled = (Boolean)ReflectionUtils.invokeMethod((Method)(isEnabledMethod = ReflectionUtils.findMethod(ss.getClass(), (String)"isEnabled")), (Object)ss)).booleanValue()) {
            prefix = REDISS_PROTOCOL_PREFIX;
        }
        return prefix;
    }

    private String[] convertNodes(String prefix, List<Object> nodesObject) {
        ArrayList<String> nodes = new ArrayList<String>(nodesObject.size());
        for (Object node : nodesObject) {
            Field hostField = ReflectionUtils.findField(node.getClass(), (String)"host");
            Field portField = ReflectionUtils.findField(node.getClass(), (String)"port");
            ReflectionUtils.makeAccessible((Field)hostField);
            ReflectionUtils.makeAccessible((Field)portField);
            String host = (String)ReflectionUtils.getField((Field)hostField, (Object)node);
            int port = (Integer)ReflectionUtils.getField((Field)portField, (Object)node);
            nodes.add(prefix + host + ":" + port);
        }
        return nodes.toArray(new String[0]);
    }

    private String[] convert(String prefix, List<String> nodesObject) {
        ArrayList<String> nodes = new ArrayList<String>(nodesObject.size());
        for (String node : nodesObject) {
            if (!node.startsWith(REDIS_PROTOCOL_PREFIX) && !node.startsWith(REDISS_PROTOCOL_PREFIX)) {
                nodes.add(prefix + node);
                continue;
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[0]);
    }

    private InputStream getConfigStream() throws IOException {
        Resource resource = this.ctx.getResource(this.redissonProperties.getFile());
        return resource.getInputStream();
    }
}

