/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.bucket;

import java.util.Map;
import org.redisson.RedissonBuckets;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;

public class BucketsTrySetOperation
extends TransactionalOperation {
    private String transactionId;
    private Map<String, Object> values;

    public BucketsTrySetOperation(Codec codec, Map<String, Object> values, String transactionId) {
        super(null, codec);
        this.values = values;
        this.transactionId = transactionId;
    }

    @Override
    public void commit(CommandAsyncExecutor commandExecutor) {
        RedissonBuckets bucket = new RedissonBuckets(this.codec, commandExecutor);
        bucket.trySetAsync(this.values);
        this.unlock(commandExecutor);
    }

    protected void unlock(CommandAsyncExecutor commandExecutor) {
        for (String key : this.values.keySet()) {
            RedissonTransactionalLock lock = new RedissonTransactionalLock(commandExecutor, this.getLockName(key), this.transactionId);
            lock.unlockAsync();
        }
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        this.unlock(commandExecutor);
    }

    public Map<String, Object> getValues() {
        return this.values;
    }

    private String getLockName(String name) {
        return name + ":transaction_lock";
    }
}

