/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.renewal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CompletionStage;
import org.redisson.api.RFuture;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.AsyncChunkProcessor;
import org.redisson.renewal.FastMultilockEntry;
import org.redisson.renewal.LockTask;

public class FastMultilockTask
extends LockTask {
    public FastMultilockTask(long internalLockLeaseTime, CommandAsyncExecutor executor) {
        super(internalLockLeaseTime, executor, 1);
    }

    @Override
    CompletionStage<Void> renew(Iterator<String> iter, int chunkSize) {
        return AsyncChunkProcessor.processAll(iter, chunkSize, this::buildChunk);
    }

    private AsyncChunkProcessor.ChunkExecution<Boolean> buildChunk(Iterator<String> iter, int chunkSize) {
        HashMap<String, Long> name2lockName = new HashMap<String, Long>();
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.internalLockLeaseTime);
        args.add(System.currentTimeMillis());
        ArrayList<String> keys = new ArrayList<String>(chunkSize);
        while (iter.hasNext() && keys.size() < chunkSize) {
            Long threadId;
            String key = iter.next();
            FastMultilockEntry entry = (FastMultilockEntry)this.name2entry.get(key);
            if (entry == null || (threadId = entry.getFirstThreadId()) == null) continue;
            keys.add(key);
            args.add(entry.getLockName(threadId));
            args.addAll(entry.getFields());
            name2lockName.put(key, threadId);
        }
        if (keys.isEmpty()) {
            return null;
        }
        String firstName = (String)keys.get(0);
        RFuture<Boolean> f = this.executor.syncedEval(firstName, LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local leaseTime = tonumber(ARGV[1]);local currentTime = tonumber(ARGV[2]);local currentThread = ARGV[3];if (redis.call('exists',KEYS[1]) > 0) then   local newExpireTime = leaseTime + currentTime;   for i=4, #ARGV, 1 do        local lockThread = redis.call('hget', KEYS[1], ARGV[i]);       if(lockThread ~= false and lockThread == currentThread) then            local expireFieldName = ARGV[i]..':'..lockThread..':expire_time';           local expireTime = redis.call('hget', KEYS[1], expireFieldName);           if(tonumber(expireTime) < newExpireTime) then                redis.call('hset', KEYS[1],expireFieldName, newExpireTime);           end;       else           return 0;       end;   end;    local expireTime = redis.call('pttl',KEYS[1]);   if(tonumber(expireTime) < tonumber(leaseTime)) then        redis.call('pexpire',KEYS[1], leaseTime);   end;   return 1;end;return 0;", Collections.singletonList(firstName), args.toArray());
        return new AsyncChunkProcessor.ChunkExecution<Boolean>(f, exists -> {
            if (!exists.booleanValue()) {
                this.cancelExpirationRenewal(firstName, (Long)name2lockName.get(firstName));
            }
        });
    }

    public void add(String rawName, String lockName, long threadId, Collection<String> fields) {
        FastMultilockEntry entry = new FastMultilockEntry(fields);
        entry.addThreadId(threadId, lockName);
        this.add(rawName, lockName, threadId, entry);
    }
}

