/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.redisson.ScanResult;
import org.redisson.api.AsyncIterator;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;

public abstract class BaseAsyncIterator<V, E>
implements AsyncIterator<V> {
    private Iterator<E> lastIt;
    protected String nextItPos = "0";
    protected RedisClient client;

    @Override
    public CompletionStage<Boolean> hasNext() {
        CompletableFuture<Boolean> result = new CompletableFuture<Boolean>();
        if (!(this.nextItPos != null || this.lastIt != null && this.lastIt.hasNext())) {
            result.complete(false);
            return result;
        }
        if (this.lastIt == null || !this.lastIt.hasNext()) {
            this.iterator(this.client, this.nextItPos).whenComplete((v, e) -> {
                if (e != null || v == null) {
                    this.client = null;
                    this.nextItPos = null;
                    result.complete(false);
                } else {
                    this.client = v.getRedisClient();
                    this.nextItPos = v.getPos();
                    this.lastIt = v.getValues().iterator();
                    if ("0".equals(this.nextItPos)) {
                        this.nextItPos = null;
                    }
                    result.complete(this.lastIt.hasNext());
                }
            });
        } else {
            result.complete(true);
        }
        return result;
    }

    @Override
    public CompletionStage<V> next() {
        CompletableFuture result = new CompletableFuture();
        this.hasNext().thenAccept(v -> {
            if (!v.booleanValue()) {
                result.completeExceptionally(new NoSuchElementException());
                return;
            }
            E next = this.lastIt.next();
            result.complete(this.getValue(next));
        });
        return result;
    }

    protected abstract RFuture<ScanResult<E>> iterator(RedisClient var1, String var2);

    protected V getValue(E entry) {
        return (V)entry;
    }
}

