/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.redisson.config.DelayStrategy;

public class FullJitterDelay
implements DelayStrategy {
    private final Duration baseDelay;
    private final Duration maxDelay;

    public FullJitterDelay(Duration baseDelay, Duration maxDelay) {
        Objects.requireNonNull(baseDelay);
        Objects.requireNonNull(maxDelay);
        this.baseDelay = baseDelay;
        this.maxDelay = maxDelay;
    }

    @Override
    public Duration calcDelay(int attempt) {
        long shifted;
        long baseMs = this.baseDelay.toMillis();
        long maxMs = this.maxDelay.toMillis();
        long exponentialDelayMs = attempt >= 63 || baseMs <= 0L ? maxMs : (baseMs > maxMs / (shifted = 1L << attempt) ? maxMs : Math.min(baseMs * shifted, maxMs));
        exponentialDelayMs = Math.max(exponentialDelayMs, 1L);
        long jitteredDelayMs = ThreadLocalRandom.current().nextLong(0L, exponentialDelayMs + 1L);
        return Duration.ofMillis(jitteredDelayMs);
    }
}

