/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.redisson.config.DelayStrategy;

public class EqualJitterDelay
implements DelayStrategy {
    final Duration baseDelay;
    final Duration maxDelay;

    public EqualJitterDelay(Duration baseDelay, Duration maxDelay) {
        Objects.requireNonNull(baseDelay);
        Objects.requireNonNull(maxDelay);
        this.baseDelay = baseDelay;
        this.maxDelay = maxDelay;
    }

    @Override
    public Duration calcDelay(int attempt) {
        long shifted;
        long baseMs = this.baseDelay.toMillis();
        long maxMs = this.maxDelay.toMillis();
        long exponentialDelayMs = attempt >= 63 || baseMs >= maxMs ? maxMs : ((shifted = 1L << attempt) > maxMs / baseMs ? maxMs : Math.min(baseMs * shifted, maxMs));
        long halfDelay = exponentialDelayMs / 2L;
        long randomComponent = 0L;
        if (halfDelay != 0L) {
            randomComponent = ThreadLocalRandom.current().nextLong(0L, halfDelay + 1L);
        }
        return Duration.ofMillis(halfDelay + randomComponent);
    }

    public Duration getBaseDelay() {
        return this.baseDelay;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }
}

