/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;
import org.redisson.codec.JsonCodec;
import tools.jackson.core.JacksonException;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.MapperFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.type.TypeFactory;

public class Jackson3Codec<T>
implements JsonCodec {
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream os = new ByteBufOutputStream(out);
                Jackson3Codec.this.mapObjectMapper.writeValue((OutputStream)os, in);
                return os.buffer();
            }
            catch (JacksonException e) {
                out.release();
                throw e;
            }
        }
    };
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) {
            if (Jackson3Codec.this.valueClass != null) {
                return Jackson3Codec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), Jackson3Codec.this.valueClass);
            }
            return Jackson3Codec.this.mapObjectMapper.readValue((InputStream)new ByteBufInputStream(buf), Jackson3Codec.this.valueTypeReference);
        }
    };
    private Class<T> valueClass;
    private TypeReference<T> valueTypeReference;
    private final ObjectMapper mapObjectMapper;

    public Jackson3Codec(Class<T> valueClass) {
        if (valueClass == null) {
            throw new NullPointerException("valueClass isn't defined");
        }
        this.valueClass = valueClass;
        this.mapObjectMapper = this.createDefaultMapper();
    }

    public Jackson3Codec(TypeReference<T> valueTypeReference) {
        if (valueTypeReference == null) {
            throw new NullPointerException("valueTypeReference isn't defined");
        }
        this.valueTypeReference = valueTypeReference;
        this.mapObjectMapper = this.createDefaultMapper();
    }

    public Jackson3Codec(ObjectMapper mapObjectMapper, TypeReference<T> valueTypeReference) {
        if (mapObjectMapper == null) {
            throw new NullPointerException("mapObjectMapper isn't defined");
        }
        if (valueTypeReference == null) {
            throw new NullPointerException("valueTypeReference isn't defined");
        }
        this.mapObjectMapper = mapObjectMapper;
        this.valueTypeReference = valueTypeReference;
    }

    public Jackson3Codec(ObjectMapper mapObjectMapper, Class<T> valueClass) {
        if (mapObjectMapper == null) {
            throw new NullPointerException("mapObjectMapper isn't defined");
        }
        if (valueClass == null) {
            throw new NullPointerException("valueClass isn't defined");
        }
        this.mapObjectMapper = mapObjectMapper;
        this.valueClass = valueClass;
    }

    public Jackson3Codec(ClassLoader classLoader, Jackson3Codec<T> codec) {
        this.valueClass = codec.valueClass;
        this.valueTypeReference = codec.valueTypeReference;
        this.mapObjectMapper = Jackson3Codec.createObjectMapper(classLoader, codec.mapObjectMapper.rebuild().build());
    }

    protected static ObjectMapper createObjectMapper(ClassLoader classLoader, ObjectMapper sourceMapper) {
        TypeFactory tf = TypeFactory.createDefaultInstance().withClassLoader(classLoader);
        return sourceMapper.rebuild().typeFactory(tf).build();
    }

    ObjectMapper createDefaultMapper() {
        return this.init(JsonMapper.builder()).build();
    }

    protected JsonMapper.Builder init(JsonMapper.Builder builder) {
        return (JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)builder.changeDefaultPropertyInclusion(incl -> incl.withValueInclusion(JsonInclude.Include.NON_NULL).withContentInclusion(JsonInclude.Include.NON_NULL))).disable(new SerializationFeature[]{SerializationFeature.FAIL_ON_EMPTY_BEANS})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).changeDefaultVisibility(vc -> vc.withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE))).enable(new StreamWriteFeature[]{StreamWriteFeature.WRITE_BIGDECIMAL_AS_PLAIN})).enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});
    }

    @Override
    public Encoder getEncoder() {
        return this.encoder;
    }

    @Override
    public Decoder<Object> getDecoder() {
        return this.decoder;
    }
}

