/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Set;
import org.apache.fory.Fory;
import org.apache.fory.ThreadSafeFory;
import org.apache.fory.config.ForyBuilder;
import org.apache.fory.config.Language;
import org.apache.fory.io.ForyStreamReader;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.MemoryUtils;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class ForyCodec
extends BaseCodec {
    private final ThreadSafeFory fory;
    private final Set<String> allowedClasses;
    private final Language language;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            if (buf.nioBufferCount() == 1) {
                MemoryBuffer furyBuffer = MemoryUtils.wrap((ByteBuffer)buf.nioBuffer());
                try {
                    Object object = ForyCodec.this.fory.deserialize(furyBuffer);
                    return object;
                }
                finally {
                    buf.readerIndex(buf.readerIndex() + furyBuffer.readerIndex());
                }
            }
            return ForyCodec.this.fory.deserialize(ForyStreamReader.of((InputStream)new ByteBufInputStream(buf)));
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            MemoryBuffer furyBuffer = null;
            int remainingSize = out.capacity() - out.writerIndex();
            if (out.hasArray()) {
                furyBuffer = MemoryUtils.wrap((byte[])out.array(), (int)(out.arrayOffset() + out.writerIndex()), (int)remainingSize);
            } else if (out.hasMemoryAddress()) {
                furyBuffer = MemoryUtils.buffer((long)(out.memoryAddress() + (long)out.writerIndex()), (int)remainingSize);
            }
            if (furyBuffer != null) {
                int size = furyBuffer.size();
                ForyCodec.this.fory.serialize(furyBuffer, in);
                if (furyBuffer.size() > size) {
                    out.writeBytes(furyBuffer.getHeapMemory(), 0, furyBuffer.size());
                } else {
                    out.writerIndex(out.writerIndex() + furyBuffer.writerIndex());
                }
                return out;
            }
            try {
                ByteBufOutputStream baos = new ByteBufOutputStream(out);
                ForyCodec.this.fory.serialize((OutputStream)baos, in);
                return baos.buffer();
            }
            catch (Exception e) {
                out.release();
                throw e;
            }
        }
    };

    public ForyCodec() {
        this(null, Collections.emptySet(), Language.JAVA);
    }

    public ForyCodec(Set<String> allowedClasses) {
        this(null, allowedClasses, Language.JAVA);
    }

    public ForyCodec(Language language) {
        this(null, Collections.emptySet(), language);
    }

    public ForyCodec(Set<String> allowedClasses, Language language) {
        this(null, allowedClasses, language);
    }

    public ForyCodec(ClassLoader classLoader, ForyCodec codec) {
        this(classLoader, codec.allowedClasses, codec.language);
    }

    public ForyCodec(ClassLoader classLoader) {
        this(classLoader, Collections.emptySet(), Language.JAVA);
    }

    public ForyCodec(ClassLoader classLoader, Set<String> allowedClasses, Language language) {
        this.allowedClasses = allowedClasses;
        this.language = language;
        ForyBuilder builder = Fory.builder();
        if (classLoader != null) {
            builder.withClassLoader(classLoader);
        }
        builder.withLanguage(language);
        builder.requireClassRegistration(!allowedClasses.isEmpty());
        this.fory = this.create(builder);
        for (String allowedClass : allowedClasses) {
            try {
                this.fory.register(Class.forName(allowedClass));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected ThreadSafeFory create(ForyBuilder builder) {
        return builder.buildThreadSafeForyPool(10, 512);
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

