/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.resolver.AddressResolverGroup;
import io.netty.util.Timer;
import java.net.InetSocketAddress;
import java.net.URL;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.redisson.client.DefaultCredentialsResolver;
import org.redisson.client.DefaultNettyHook;
import org.redisson.client.FailedConnectionDetector;
import org.redisson.client.FailedNodeDetector;
import org.redisson.client.NettyHook;
import org.redisson.config.CommandMapper;
import org.redisson.config.CredentialsResolver;
import org.redisson.config.DefaultCommandMapper;
import org.redisson.config.DelayStrategy;
import org.redisson.config.EqualJitterDelay;
import org.redisson.config.Protocol;
import org.redisson.config.SslProvider;
import org.redisson.config.SslVerificationMode;
import org.redisson.config.ValkeyCapability;
import org.redisson.misc.RedisURI;

public class RedisClientConfig {
    private RedisURI address;
    private InetSocketAddress addr;
    private Timer timer;
    private ExecutorService executor;
    private EventLoopGroup group;
    private AddressResolverGroup<InetSocketAddress> resolverGroup;
    private Class<? extends DuplexChannel> socketChannelClass = NioSocketChannel.class;
    private int connectTimeout = 10000;
    private int commandTimeout = 10000;
    private String username;
    private String password;
    private int database;
    private String clientName;
    private boolean readOnly;
    private boolean keepPubSubOrder = true;
    private int pingConnectionInterval;
    private boolean keepAlive;
    private int tcpKeepAliveCount;
    private int tcpKeepAliveIdle;
    private int tcpKeepAliveInterval;
    private int tcpUserTimeout;
    private boolean tcpNoDelay;
    private String sslHostname;
    private SslVerificationMode sslVerificationMode = SslVerificationMode.STRICT;
    private SslProvider sslProvider = SslProvider.JDK;
    private String sslKeystoreType;
    private URL sslTruststore;
    private String sslTruststorePassword;
    private URL sslKeystore;
    private String sslKeystorePassword;
    private String[] sslProtocols;
    private String[] sslCiphers;
    private TrustManagerFactory sslTrustManagerFactory;
    private KeyManagerFactory sslKeyManagerFactory;
    private NettyHook nettyHook = new DefaultNettyHook();
    private CredentialsResolver credentialsResolver = new DefaultCredentialsResolver();
    private Consumer<InetSocketAddress> connectedListener;
    private Consumer<InetSocketAddress> disconnectedListener;
    private CommandMapper commandMapper = new DefaultCommandMapper();
    private FailedNodeDetector failedNodeDetector = new FailedConnectionDetector();
    private Protocol protocol = Protocol.RESP2;
    private Set<ValkeyCapability> capabilities = Collections.emptySet();
    private DelayStrategy reconnectionDelay = new EqualJitterDelay(Duration.ofMillis(100L), Duration.ofSeconds(10L));

    public RedisClientConfig() {
    }

    RedisClientConfig(RedisClientConfig config) {
        this.nettyHook = config.nettyHook;
        this.addr = config.addr;
        this.address = config.address;
        this.timer = config.timer;
        this.executor = config.executor;
        this.group = config.group;
        this.socketChannelClass = config.socketChannelClass;
        this.connectTimeout = config.connectTimeout;
        this.commandTimeout = config.commandTimeout;
        this.password = config.password;
        this.username = config.username;
        this.database = config.database;
        this.clientName = config.clientName;
        this.readOnly = config.readOnly;
        this.keepPubSubOrder = config.keepPubSubOrder;
        this.pingConnectionInterval = config.pingConnectionInterval;
        this.keepAlive = config.keepAlive;
        this.tcpNoDelay = config.tcpNoDelay;
        this.sslProvider = config.sslProvider;
        this.sslTruststore = config.sslTruststore;
        this.sslTruststorePassword = config.sslTruststorePassword;
        this.sslKeystore = config.sslKeystore;
        this.sslKeystorePassword = config.sslKeystorePassword;
        this.sslProtocols = config.sslProtocols;
        this.sslCiphers = config.sslCiphers;
        this.resolverGroup = config.resolverGroup;
        this.sslHostname = config.sslHostname;
        this.credentialsResolver = config.credentialsResolver;
        this.connectedListener = config.connectedListener;
        this.disconnectedListener = config.disconnectedListener;
        this.sslKeyManagerFactory = config.sslKeyManagerFactory;
        this.sslTrustManagerFactory = config.sslTrustManagerFactory;
        this.commandMapper = config.commandMapper;
        this.failedNodeDetector = config.failedNodeDetector;
        this.tcpKeepAliveCount = config.tcpKeepAliveCount;
        this.tcpKeepAliveIdle = config.tcpKeepAliveIdle;
        this.tcpKeepAliveInterval = config.tcpKeepAliveInterval;
        this.tcpUserTimeout = config.tcpUserTimeout;
        this.protocol = config.protocol;
        this.sslKeystoreType = config.sslKeystoreType;
        this.sslVerificationMode = config.sslVerificationMode;
        this.capabilities = config.capabilities;
        this.reconnectionDelay = config.reconnectionDelay;
    }

    public NettyHook getNettyHook() {
        return this.nettyHook;
    }

    public RedisClientConfig setNettyHook(NettyHook nettyHook) {
        this.nettyHook = nettyHook;
        return this;
    }

    public String getSslHostname() {
        return this.sslHostname;
    }

    public RedisClientConfig setSslHostname(String sslHostname) {
        this.sslHostname = sslHostname;
        return this;
    }

    public RedisClientConfig setAddress(String host, int port) {
        this.address = new RedisURI("redis://" + host + ":" + port);
        return this;
    }

    public RedisClientConfig setAddress(String address) {
        this.address = new RedisURI(address);
        return this;
    }

    public RedisClientConfig setAddress(InetSocketAddress addr, RedisURI address) {
        this.addr = addr;
        this.address = address;
        return this;
    }

    public RedisClientConfig setAddress(RedisURI address) {
        this.address = address;
        return this;
    }

    public RedisURI getAddress() {
        return this.address;
    }

    public InetSocketAddress getAddr() {
        return this.addr;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public RedisClientConfig setTimer(Timer timer) {
        this.timer = timer;
        return this;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public RedisClientConfig setExecutor(ExecutorService executor) {
        this.executor = executor;
        return this;
    }

    public EventLoopGroup getGroup() {
        return this.group;
    }

    public RedisClientConfig setGroup(EventLoopGroup group) {
        this.group = group;
        return this;
    }

    public Class<? extends DuplexChannel> getSocketChannelClass() {
        return this.socketChannelClass;
    }

    public RedisClientConfig setSocketChannelClass(Class<? extends DuplexChannel> socketChannelClass) {
        this.socketChannelClass = socketChannelClass;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public RedisClientConfig setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getCommandTimeout() {
        return this.commandTimeout;
    }

    public RedisClientConfig setCommandTimeout(int commandTimeout) {
        this.commandTimeout = commandTimeout;
        return this;
    }

    public SslProvider getSslProvider() {
        return this.sslProvider;
    }

    public RedisClientConfig setSslProvider(SslProvider sslMode) {
        this.sslProvider = sslMode;
        return this;
    }

    public URL getSslTruststore() {
        return this.sslTruststore;
    }

    public RedisClientConfig setSslTruststore(URL sslTruststore) {
        this.sslTruststore = sslTruststore;
        return this;
    }

    public URL getSslKeystore() {
        return this.sslKeystore;
    }

    public RedisClientConfig setSslKeystore(URL sslKeystore) {
        this.sslKeystore = sslKeystore;
        return this;
    }

    public String getSslKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public RedisClientConfig setSslKeystorePassword(String sslKeystorePassword) {
        this.sslKeystorePassword = sslKeystorePassword;
        return this;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public RedisClientConfig setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
        return this;
    }

    @Deprecated
    public boolean isSslEnableEndpointIdentification() {
        return this.sslVerificationMode == SslVerificationMode.STRICT;
    }

    @Deprecated
    public RedisClientConfig setSslEnableEndpointIdentification(boolean enableEndpointIdentification) {
        this.sslVerificationMode = enableEndpointIdentification ? SslVerificationMode.STRICT : SslVerificationMode.NONE;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public RedisClientConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public int getDatabase() {
        return this.database;
    }

    public RedisClientConfig setDatabase(int database) {
        this.database = database;
        return this;
    }

    public String getClientName() {
        return this.clientName;
    }

    public RedisClientConfig setClientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public RedisClientConfig setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public boolean isKeepPubSubOrder() {
        return this.keepPubSubOrder;
    }

    public RedisClientConfig setKeepPubSubOrder(boolean keepPubSubOrder) {
        this.keepPubSubOrder = keepPubSubOrder;
        return this;
    }

    public int getPingConnectionInterval() {
        return this.pingConnectionInterval;
    }

    public RedisClientConfig setPingConnectionInterval(int pingConnectionInterval) {
        this.pingConnectionInterval = pingConnectionInterval;
        return this;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public RedisClientConfig setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public int getTcpKeepAliveCount() {
        return this.tcpKeepAliveCount;
    }

    public RedisClientConfig setTcpKeepAliveCount(int tcpKeepAliveCount) {
        this.tcpKeepAliveCount = tcpKeepAliveCount;
        return this;
    }

    public int getTcpKeepAliveIdle() {
        return this.tcpKeepAliveIdle;
    }

    public RedisClientConfig setTcpKeepAliveIdle(int tcpKeepAliveIdle) {
        this.tcpKeepAliveIdle = tcpKeepAliveIdle;
        return this;
    }

    public int getTcpKeepAliveInterval() {
        return this.tcpKeepAliveInterval;
    }

    public RedisClientConfig setTcpKeepAliveInterval(int tcpKeepAliveInterval) {
        this.tcpKeepAliveInterval = tcpKeepAliveInterval;
        return this;
    }

    public int getTcpUserTimeout() {
        return this.tcpUserTimeout;
    }

    public RedisClientConfig setTcpUserTimeout(int tcpUserTimeout) {
        this.tcpUserTimeout = tcpUserTimeout;
        return this;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public RedisClientConfig setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this;
    }

    public AddressResolverGroup<InetSocketAddress> getResolverGroup() {
        return this.resolverGroup;
    }

    public RedisClientConfig setResolverGroup(AddressResolverGroup<InetSocketAddress> resolverGroup) {
        this.resolverGroup = resolverGroup;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public RedisClientConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public String[] getSslProtocols() {
        return this.sslProtocols;
    }

    public RedisClientConfig setSslProtocols(String[] sslProtocols) {
        this.sslProtocols = sslProtocols;
        return this;
    }

    public String[] getSslCiphers() {
        return this.sslCiphers;
    }

    public RedisClientConfig setSslCiphers(String[] sslCiphers) {
        this.sslCiphers = sslCiphers;
        return this;
    }

    public CredentialsResolver getCredentialsResolver() {
        return this.credentialsResolver;
    }

    public RedisClientConfig setCredentialsResolver(CredentialsResolver credentialsResolver) {
        this.credentialsResolver = credentialsResolver;
        return this;
    }

    public Consumer<InetSocketAddress> getConnectedListener() {
        return this.connectedListener;
    }

    public RedisClientConfig setConnectedListener(Consumer<InetSocketAddress> connectedListener) {
        this.connectedListener = connectedListener;
        return this;
    }

    public Consumer<InetSocketAddress> getDisconnectedListener() {
        return this.disconnectedListener;
    }

    public RedisClientConfig setDisconnectedListener(Consumer<InetSocketAddress> disconnectedListener) {
        this.disconnectedListener = disconnectedListener;
        return this;
    }

    public TrustManagerFactory getSslTrustManagerFactory() {
        return this.sslTrustManagerFactory;
    }

    public RedisClientConfig setSslTrustManagerFactory(TrustManagerFactory sslTrustManagerFactory) {
        this.sslTrustManagerFactory = sslTrustManagerFactory;
        return this;
    }

    public KeyManagerFactory getSslKeyManagerFactory() {
        return this.sslKeyManagerFactory;
    }

    public RedisClientConfig setSslKeyManagerFactory(KeyManagerFactory sslKeyManagerFactory) {
        this.sslKeyManagerFactory = sslKeyManagerFactory;
        return this;
    }

    public CommandMapper getCommandMapper() {
        return this.commandMapper;
    }

    public RedisClientConfig setCommandMapper(CommandMapper commandMapper) {
        this.commandMapper = commandMapper;
        return this;
    }

    public FailedNodeDetector getFailedNodeDetector() {
        return this.failedNodeDetector;
    }

    public RedisClientConfig setFailedNodeDetector(FailedNodeDetector failedNodeDetector) {
        this.failedNodeDetector = failedNodeDetector;
        return this;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public RedisClientConfig setProtocol(Protocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public String getSslKeystoreType() {
        return this.sslKeystoreType;
    }

    public RedisClientConfig setSslKeystoreType(String sslKeystoreType) {
        this.sslKeystoreType = sslKeystoreType;
        return this;
    }

    public SslVerificationMode getSslVerificationMode() {
        return this.sslVerificationMode;
    }

    public RedisClientConfig setSslVerificationMode(SslVerificationMode sslVerificationMode) {
        this.sslVerificationMode = sslVerificationMode;
        return this;
    }

    public Set<ValkeyCapability> getCapabilities() {
        return this.capabilities;
    }

    public RedisClientConfig setCapabilities(Set<ValkeyCapability> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public DelayStrategy getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public RedisClientConfig setReconnectionDelay(DelayStrategy reconnectionDelay) {
        this.reconnectionDelay = reconnectionDelay;
        return this;
    }
}

