/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.queue;

import java.time.Duration;
import java.util.Objects;
import org.redisson.api.queue.ProcessingMode;
import org.redisson.api.queue.QueueConfig;

public final class QueueConfigParams
implements QueueConfig {
    private int deliveryLimit = 10;
    private Duration visibilityTimeout = Duration.ofSeconds(30L);
    private Duration ttl = Duration.ZERO;
    private String deadLetterQueueName;
    private int maxMessageSize;
    private int maxSize;
    private Duration delay = Duration.ZERO;
    private ProcessingMode processingMode = ProcessingMode.PARALLEL;

    @Override
    public QueueConfig deliveryLimit(int value) {
        if (value < 1) {
            throw new IllegalArgumentException("Delivery limit can't lower than 1");
        }
        this.deliveryLimit = value;
        return this;
    }

    @Override
    public QueueConfig visibility(Duration value) {
        Objects.requireNonNull(value);
        if (value.toMillis() < 1L) {
            throw new IllegalArgumentException("Delivery limit can't lower than 1 ms");
        }
        this.visibilityTimeout = value;
        return this;
    }

    @Override
    public QueueConfig timeToLive(Duration value) {
        Objects.requireNonNull(value);
        this.ttl = value;
        return this;
    }

    @Override
    public QueueConfig deadLetterQueueName(String value) {
        this.deadLetterQueueName = value;
        return this;
    }

    @Override
    public QueueConfig maxMessageSize(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Max message size limit can't lower than 0");
        }
        this.maxMessageSize = value;
        return this;
    }

    @Override
    public QueueConfig delay(Duration value) {
        Objects.requireNonNull(value);
        this.delay = value;
        return this;
    }

    @Override
    public QueueConfig maxSize(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Max size can't lower than 0");
        }
        this.maxSize = value;
        return this;
    }

    @Override
    public QueueConfig processingMode(ProcessingMode mode) {
        this.processingMode = mode;
        return this;
    }

    public int getDeliveryLimit() {
        return this.deliveryLimit;
    }

    public Duration getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public String getDeadLetterQueueName() {
        return this.deadLetterQueueName;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public ProcessingMode getProcessingMode() {
        return this.processingMode;
    }
}

