/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.pubsub;

import java.time.Duration;
import java.util.Objects;
import org.redisson.api.pubsub.RetentionMode;
import org.redisson.api.pubsub.TopicConfig;

public final class TopicConfigParams
implements TopicConfig {
    private RetentionMode retentionMode = RetentionMode.SUBSCRIPTION_OPTIONAL_RETAIN_ALL;
    private Duration visibilityTimeout = Duration.ofSeconds(30L);
    private Duration ttl = Duration.ZERO;
    private int maxMessageSize;
    private int maxSize;
    private Duration delay = Duration.ZERO;
    private int deliveryLimit = 10;

    @Override
    public TopicConfig visibility(Duration value) {
        Objects.requireNonNull(value);
        if (value.toMillis() < 1L) {
            throw new IllegalArgumentException("Delivery limit can't lower than 1 ms");
        }
        this.visibilityTimeout = value;
        return this;
    }

    @Override
    public TopicConfig timeToLive(Duration value) {
        Objects.requireNonNull(value);
        this.ttl = value;
        return this;
    }

    @Override
    public TopicConfig maxMessageSize(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Max message size limit can't lower than 0");
        }
        this.maxMessageSize = value;
        return this;
    }

    @Override
    public TopicConfig delay(Duration value) {
        Objects.requireNonNull(value);
        this.delay = value;
        return this;
    }

    @Override
    public TopicConfig maxSize(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Max size can't lower than 0");
        }
        this.maxSize = value;
        return this;
    }

    @Override
    public TopicConfig deliveryLimit(int value) {
        this.deliveryLimit = value;
        return this;
    }

    @Override
    public TopicConfig retentionMode(RetentionMode mode) {
        this.retentionMode = mode;
        return this;
    }

    public Duration getVisibilityTimeout() {
        return this.visibilityTimeout;
    }

    public Duration getTtl() {
        return this.ttl;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getDeliveryLimit() {
        return this.deliveryLimit;
    }

    public RetentionMode getRetentionMode() {
        return this.retentionMode;
    }
}

