/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.pubsub;

import java.time.Duration;
import org.redisson.api.pubsub.Position;
import org.redisson.api.pubsub.SubscriptionConfig;

public class SubscriptionConfigParams
implements SubscriptionConfig {
    private boolean retainAfterAck;
    private String deadLetterTopicName;
    private int deliveryLimit;
    private Duration visibility = Duration.ofSeconds(0L);
    private Position position = Position.latest();
    private final String name;

    public SubscriptionConfigParams(String name) {
        this.name = name;
    }

    @Override
    public SubscriptionConfig deadLetterTopicName(String value) {
        this.deadLetterTopicName = value;
        return this;
    }

    @Override
    public SubscriptionConfig deliveryLimit(int value) {
        this.deliveryLimit = value;
        return this;
    }

    @Override
    public SubscriptionConfig visibility(Duration value) {
        this.visibility = value;
        return this;
    }

    @Override
    public SubscriptionConfig position(Position value) {
        this.position = value;
        return this;
    }

    @Override
    public SubscriptionConfig retainAfterAck() {
        this.retainAfterAck = true;
        return this;
    }

    public String getDeadLetterTopicName() {
        return this.deadLetterTopicName;
    }

    public int getDeliveryLimit() {
        return this.deliveryLimit;
    }

    public Duration getVisibility() {
        return this.visibility;
    }

    public Position getPosition() {
        return this.position;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRetainAfterAck() {
        return this.retainAfterAck;
    }
}

