/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api;

import java.util.concurrent.TimeUnit;
import org.redisson.api.MapCacheOptions;
import org.redisson.api.MapOptions;
import org.redisson.api.map.MapLoader;
import org.redisson.api.map.MapLoaderAsync;
import org.redisson.api.map.MapWriter;
import org.redisson.api.map.MapWriterAsync;

public class LocalCachedMapCacheOptions<K, V>
extends MapCacheOptions<K, V> {
    private ReconnectionStrategy reconnectionStrategy;
    private SyncStrategy syncStrategy;
    private EvictionPolicy evictionPolicy;
    private int cacheSize;
    private long timeToLiveInMillis;
    private long maxIdleInMillis;
    private CacheProvider cacheProvider;
    private StoreMode storeMode;
    private boolean storeCacheMiss;
    private boolean useKeyEventsPattern;

    protected LocalCachedMapCacheOptions() {
    }

    protected LocalCachedMapCacheOptions(LocalCachedMapCacheOptions<K, V> copy) {
        this.reconnectionStrategy = copy.reconnectionStrategy;
        this.syncStrategy = copy.syncStrategy;
        this.evictionPolicy = copy.evictionPolicy;
        this.cacheSize = copy.cacheSize;
        this.timeToLiveInMillis = copy.timeToLiveInMillis;
        this.maxIdleInMillis = copy.maxIdleInMillis;
        this.cacheProvider = copy.cacheProvider;
        this.storeMode = copy.storeMode;
        this.storeCacheMiss = copy.storeCacheMiss;
    }

    public static <K, V> LocalCachedMapCacheOptions<K, V> defaults() {
        return new LocalCachedMapCacheOptions<K, V>().cacheSize(0).timeToLive(0L).maxIdle(0L).evictionPolicy(EvictionPolicy.NONE).reconnectionStrategy(ReconnectionStrategy.NONE).cacheProvider(CacheProvider.REDISSON).storeMode(StoreMode.LOCALCACHE_REDIS).syncStrategy(SyncStrategy.INVALIDATE).storeCacheMiss(false).useKeyEventsPattern(true);
    }

    public CacheProvider getCacheProvider() {
        return this.cacheProvider;
    }

    public EvictionPolicy getEvictionPolicy() {
        return this.evictionPolicy;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public long getTimeToLiveInMillis() {
        return this.timeToLiveInMillis;
    }

    public long getMaxIdleInMillis() {
        return this.maxIdleInMillis;
    }

    public LocalCachedMapCacheOptions<K, V> cacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    public ReconnectionStrategy getReconnectionStrategy() {
        return this.reconnectionStrategy;
    }

    public SyncStrategy getSyncStrategy() {
        return this.syncStrategy;
    }

    public LocalCachedMapCacheOptions<K, V> reconnectionStrategy(ReconnectionStrategy reconnectionStrategy) {
        if (reconnectionStrategy == null) {
            throw new NullPointerException("reconnectionStrategy can't be null");
        }
        this.reconnectionStrategy = reconnectionStrategy;
        return this;
    }

    public LocalCachedMapCacheOptions<K, V> syncStrategy(SyncStrategy syncStrategy) {
        if (syncStrategy == null) {
            throw new NullPointerException("syncStrategy can't be null");
        }
        this.syncStrategy = syncStrategy;
        return this;
    }

    public LocalCachedMapCacheOptions<K, V> evictionPolicy(EvictionPolicy evictionPolicy) {
        if (evictionPolicy == null) {
            throw new NullPointerException("evictionPolicy can't be null");
        }
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public LocalCachedMapCacheOptions<K, V> timeToLive(long timeToLiveInMillis) {
        this.timeToLiveInMillis = timeToLiveInMillis;
        return this;
    }

    public LocalCachedMapCacheOptions<K, V> timeToLive(long timeToLive, TimeUnit timeUnit) {
        return this.timeToLive(timeUnit.toMillis(timeToLive));
    }

    public LocalCachedMapCacheOptions<K, V> maxIdle(long maxIdleInMillis) {
        this.maxIdleInMillis = maxIdleInMillis;
        return this;
    }

    public LocalCachedMapCacheOptions<K, V> maxIdle(long maxIdle, TimeUnit timeUnit) {
        return this.maxIdle(timeUnit.toMillis(maxIdle));
    }

    public StoreMode getStoreMode() {
        return this.storeMode;
    }

    public LocalCachedMapCacheOptions<K, V> storeMode(StoreMode storeMode) {
        this.storeMode = storeMode;
        return this;
    }

    public LocalCachedMapCacheOptions<K, V> cacheProvider(CacheProvider cacheProvider) {
        this.cacheProvider = cacheProvider;
        return this;
    }

    public boolean isStoreCacheMiss() {
        return this.storeCacheMiss;
    }

    public LocalCachedMapCacheOptions<K, V> storeCacheMiss(boolean storeCacheMiss) {
        this.storeCacheMiss = storeCacheMiss;
        return this;
    }

    public boolean isUseKeyEventsPattern() {
        return this.useKeyEventsPattern;
    }

    public LocalCachedMapCacheOptions<K, V> useKeyEventsPattern(boolean useKeyEventsPattern) {
        this.useKeyEventsPattern = useKeyEventsPattern;
        return this;
    }

    @Override
    public LocalCachedMapCacheOptions<K, V> writeBehindBatchSize(int writeBehindBatchSize) {
        return (LocalCachedMapCacheOptions)super.writeBehindBatchSize(writeBehindBatchSize);
    }

    @Override
    public LocalCachedMapCacheOptions<K, V> writeBehindDelay(int writeBehindDelay) {
        return (LocalCachedMapCacheOptions)super.writeBehindDelay(writeBehindDelay);
    }

    @Override
    public LocalCachedMapCacheOptions<K, V> writer(MapWriter<K, V> writer) {
        return (LocalCachedMapCacheOptions)super.writer((MapWriter)writer);
    }

    @Override
    public LocalCachedMapCacheOptions<K, V> writerAsync(MapWriterAsync<K, V> writer) {
        return (LocalCachedMapCacheOptions)super.writerAsync((MapWriterAsync)writer);
    }

    @Override
    public LocalCachedMapCacheOptions<K, V> writeMode(MapOptions.WriteMode writeMode) {
        return (LocalCachedMapCacheOptions)super.writeMode(writeMode);
    }

    @Override
    public LocalCachedMapCacheOptions<K, V> loader(MapLoader<K, V> loader) {
        return (LocalCachedMapCacheOptions)super.loader((MapLoader)loader);
    }

    @Override
    public LocalCachedMapCacheOptions<K, V> loaderAsync(MapLoaderAsync<K, V> loaderAsync) {
        return (LocalCachedMapCacheOptions)super.loaderAsync((MapLoaderAsync)loaderAsync);
    }

    public static enum ReconnectionStrategy {
        NONE,
        CLEAR,
        LOAD;

    }

    public static enum SyncStrategy {
        NONE,
        INVALIDATE,
        UPDATE;

    }

    public static enum EvictionPolicy {
        NONE,
        LRU,
        LFU,
        SOFT,
        WEAK;

    }

    public static enum CacheProvider {
        REDISSON,
        CAFFEINE;

    }

    public static enum StoreMode {
        LOCALCACHE,
        LOCALCACHE_REDIS;

    }
}

