/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RVectorSet;
import org.redisson.api.vector.VectorAddArgs;
import org.redisson.api.vector.VectorAddParams;
import org.redisson.api.vector.VectorInfo;
import org.redisson.api.vector.VectorSimilarArgs;
import org.redisson.api.vector.VectorSimilarParams;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.ScoreAttributesEntry;
import org.redisson.client.protocol.ScoredEntry;
import org.redisson.codec.JsonCodec;
import org.redisson.codec.TypedJsonJacksonCodec;
import org.redisson.command.CommandAsyncExecutor;

public final class RedissonVectorSet
extends RedissonExpirable
implements RVectorSet {
    public RedissonVectorSet(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    @Override
    public boolean add(VectorAddArgs args) {
        return this.get(this.addAsync(args));
    }

    @Override
    public RFuture<Boolean> addAsync(VectorAddArgs vargs) {
        VectorAddParams params = (VectorAddParams)vargs;
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getName());
        if (params.getReduce() != null) {
            args.add("REDUCE");
            args.add(params.getReduce());
        }
        if (params.getVectorBytes() != null) {
            args.add("FP32");
            args.add(params.getVectorBytes());
        } else if (params.getVectorDoubles() != null) {
            args.add("VALUES");
            args.add(params.getVectorDoubles().length);
            Collections.addAll(args, params.getVectorDoubles());
        }
        args.add(params.getElement());
        if (params.isUseCheckAndSet()) {
            args.add("CAS");
        }
        if (params.getQuantizationType() != null) {
            args.add(params.getQuantizationType().name());
        }
        if (params.getEffort() != null) {
            args.add("EF");
            args.add(params.getEffort());
        }
        if (params.getAttributes() != null) {
            args.add("SETATTR");
            try {
                ByteBuf json = params.getAttributesJsonCodec().getEncoder().encode(params.getAttributes());
                args.add(json);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (params.getMaxConnections() != null) {
            args.add("M");
            args.add(params.getMaxConnections());
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VADD, args.toArray());
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VCARD, this.getName());
    }

    @Override
    public int dimensions() {
        return this.get(this.dimensionsAsync());
    }

    @Override
    public RFuture<Integer> dimensionsAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VDIM, this.getName());
    }

    @Override
    public List<Double> getVector(String element) {
        return this.get(this.getVectorAsync(element));
    }

    @Override
    public RFuture<List<Double>> getVectorAsync(String element) {
        return this.commandExecutor.readAsync(this.getName(), (Codec)DoubleCodec.INSTANCE, RedisCommands.VEMB, this.getName(), element);
    }

    @Override
    public List<Object> getRawVector(String element) {
        return this.get(this.getRawVectorAsync(element));
    }

    @Override
    public RFuture<List<Object>> getRawVectorAsync(String element) {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VEMB_RAW, this.getName(), element, "RAW");
    }

    @Override
    public <T> T getAttributes(String element, Class<T> clazz) {
        return this.get(this.getAttributesAsync(element, clazz));
    }

    @Override
    public <T> RFuture<T> getAttributesAsync(String element, Class<T> clazz) {
        return this.commandExecutor.readAsync(this.getName(), (Codec)new TypedJsonJacksonCodec(clazz), RedisCommands.VGETATTR, this.getName(), element);
    }

    @Override
    public VectorInfo getInfo() {
        return this.get(this.getInfoAsync());
    }

    @Override
    public RFuture<VectorInfo> getInfoAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VINFO, this.getName());
    }

    @Override
    public List<String> getNeighbors(String element) {
        return this.get(this.getNeighborsAsync(element));
    }

    @Override
    public RFuture<List<String>> getNeighborsAsync(String element) {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VLINKS, this.getName(), element);
    }

    @Override
    public List<ScoredEntry<String>> getNeighborEntries(String element) {
        return this.get(this.getNeighborEntriesAsync(element));
    }

    @Override
    public RFuture<List<ScoredEntry<String>>> getNeighborEntriesAsync(String element) {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VLINKS_WITHSCORES, this.getName(), element, "WITHSCORES");
    }

    @Override
    public String random() {
        return this.get(this.randomAsync());
    }

    @Override
    public RFuture<String> randomAsync() {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VRANDMEMBER, this.getName());
    }

    @Override
    public List<String> random(int count) {
        return this.get(this.randomAsync(count));
    }

    @Override
    public RFuture<List<String>> randomAsync(int count) {
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VRANDMEMBER_MULTI, this.getName(), count);
    }

    @Override
    public boolean remove(String element) {
        return this.get(this.removeAsync(element));
    }

    @Override
    public RFuture<Boolean> removeAsync(String element) {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VREM, this.getName(), element);
    }

    @Override
    public boolean setAttributes(String element, Object attributes, JsonCodec jsonCodec) {
        return this.get(this.setAttributesAsync(element, attributes, jsonCodec));
    }

    @Override
    public RFuture<Boolean> setAttributesAsync(String element, Object attributes, JsonCodec jsonCodec) {
        try {
            ByteBuf json = jsonCodec.getEncoder().encode(attributes);
            return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VSETATTR, this.getName(), element, json);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public List<String> getSimilar(VectorSimilarArgs args) {
        return this.get(this.getSimilarAsync(args));
    }

    @Override
    public RFuture<List<String>> getSimilarAsync(VectorSimilarArgs vargs) {
        VectorSimilarParams prms = (VectorSimilarParams)vargs;
        List<Object> args = this.createArgs(prms, false, false);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VSIM, args.toArray());
    }

    @Override
    public List<ScoredEntry<String>> getSimilarEntries(VectorSimilarArgs args) {
        return this.get(this.getSimilarEntriesAsync(args));
    }

    @Override
    public RFuture<List<ScoredEntry<String>>> getSimilarEntriesAsync(VectorSimilarArgs vargs) {
        VectorSimilarParams prms = (VectorSimilarParams)vargs;
        List<Object> args = this.createArgs(prms, true, false);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VSIM_WITHSCORES, args.toArray());
    }

    @Override
    public List<ScoreAttributesEntry<String>> getSimilarEntriesWithAttributes(VectorSimilarArgs args) {
        return this.get(this.getSimilarEntriesWithAttributesAsync(args));
    }

    @Override
    public RFuture<List<ScoreAttributesEntry<String>>> getSimilarEntriesWithAttributesAsync(VectorSimilarArgs vargs) {
        VectorSimilarParams prms = (VectorSimilarParams)vargs;
        List<Object> args = this.createArgs(prms, true, true);
        return this.commandExecutor.readAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.VSIM_WITHSCORESATTRIBS, args.toArray());
    }

    private List<Object> createArgs(VectorSimilarParams prms, boolean withscores, boolean withattribs) {
        ArrayList<Object> args = new ArrayList<Object>();
        args.add(this.getName());
        if (prms.getElement() != null) {
            args.add("ELE");
            args.add(prms.getElement());
        } else if (prms.getVectorBytes() != null) {
            args.add("FP32");
            args.add(prms.getVectorBytes());
        } else if (prms.getVectorDoubles() != null) {
            args.add("VALUES");
            args.add(prms.getVectorDoubles().length);
            args.addAll(Arrays.asList(prms.getVectorDoubles()));
        }
        if (withscores) {
            args.add("WITHSCORES");
        }
        if (withattribs) {
            args.add("WITHATTRIBS");
        }
        if (prms.getCount() != null) {
            args.add("COUNT");
            args.add(prms.getCount());
        }
        if (prms.getEpsilon() != null) {
            args.add("EPSILON");
            args.add(prms.getEpsilon());
        }
        if (prms.getEffort() != null) {
            args.add("EF");
            args.add(prms.getEffort());
        }
        if (prms.getFilter() != null) {
            args.add("FILTER");
            args.add(prms.getFilter());
        }
        if (prms.getFilterEffort() != null) {
            args.add("FILTER-EF");
            args.add(prms.getFilterEffort());
        }
        if (prms.isUseLinearScan()) {
            args.add("TRUTH");
        }
        if (prms.isUseMainThread()) {
            args.add("NOTHREAD");
        }
        return args;
    }
}

