/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonExpirable;
import org.redisson.api.ObjectListener;
import org.redisson.api.RBucket;
import org.redisson.api.RFuture;
import org.redisson.api.bucket.CompareAndDeleteArgs;
import org.redisson.api.bucket.CompareAndDeleteParams;
import org.redisson.api.bucket.CompareAndSetArgs;
import org.redisson.api.bucket.CompareAndSetParams;
import org.redisson.api.bucket.ConditionType;
import org.redisson.api.listener.SetObjectListener;
import org.redisson.api.listener.TrackingListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonBucket<V>
extends RedissonExpirable
implements RBucket<V> {
    public RedissonBucket(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    public RedissonBucket(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    public RedissonBucket(String name, Codec codec, CommandAsyncExecutor connectionManager) {
        super(codec, connectionManager, name);
        this.name = name;
    }

    @Override
    public boolean compareAndSet(V expect, V update) {
        return this.get(this.compareAndSetAsync(expect, update));
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(V expect, V update) {
        if (expect == null && update == null) {
            return this.trySetAsync(null);
        }
        if (expect == null) {
            return this.trySetAsync(update);
        }
        if (update == null) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('del', KEYS[1]); return 1 else return 0 end", Collections.singletonList(this.getRawName()), this.encode(expect));
        }
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "if redis.call('get', KEYS[1]) == ARGV[1] then redis.call('set', KEYS[1], ARGV[2]); return 1 else return 0 end", Collections.singletonList(this.getRawName()), this.encode(expect), this.encode(update));
    }

    @Override
    public V getAndSet(V newValue) {
        return this.get(this.getAndSetAsync(newValue));
    }

    @Override
    public RFuture<V> getAndSetAsync(V newValue) {
        if (newValue == null) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local v = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return v", Collections.singletonList(this.getRawName()), new Object[0]);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GETSET, this.getRawName(), this.encode(newValue));
    }

    @Override
    public V getAndExpire(Instant time) {
        return this.get(this.getAndExpireAsync(time));
    }

    @Override
    public RFuture<V> getAndExpireAsync(Instant time) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GETEX, this.getRawName(), "PXAT", time.toEpochMilli());
    }

    @Override
    public V getAndExpire(Duration duration) {
        return this.get(this.getAndExpireAsync(duration));
    }

    @Override
    public RFuture<V> getAndExpireAsync(Duration duration) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GETEX, this.getRawName(), "PX", duration.toMillis());
    }

    @Override
    public V getAndClearExpire() {
        return this.get(this.getAndClearExpireAsync());
    }

    @Override
    public RFuture<V> getAndClearExpireAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.GETEX, this.getRawName(), "PERSIST");
    }

    @Override
    public V get() {
        return this.get(this.getAsync());
    }

    @Override
    public RFuture<V> getAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.GET, this.getRawName());
    }

    @Override
    public V getAndDelete() {
        return this.get(this.getAndDeleteAsync());
    }

    @Override
    public RFuture<V> getAndDeleteAsync() {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return currValue; ", Collections.singletonList(this.getRawName()), new Object[0]);
    }

    @Override
    public long size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Long> sizeAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.STRLEN, this.getRawName());
    }

    @Override
    public void set(V value) {
        this.get(this.setAsync(value));
    }

    @Override
    public RFuture<Void> setAsync(V value) {
        if (value == null) {
            return this.commandExecutor.writeAsync(this.getRawName(), RedisCommands.DEL_VOID, this.getRawName());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SET, this.getRawName(), this.encode(value));
    }

    @Override
    public void set(V value, long timeToLive, TimeUnit timeUnit) {
        this.get(this.setAsync(value, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Void> setAsync(V value, long timeToLive, TimeUnit timeUnit) {
        if (value == null) {
            return this.commandExecutor.writeAsync(this.getRawName(), RedisCommands.DEL_VOID, this.getRawName());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.PSETEX, this.getRawName(), timeUnit.toMillis(timeToLive), this.encode(value));
    }

    @Override
    public void set(V value, Duration duration) {
        this.get(this.setAsync(value, duration));
    }

    @Override
    public RFuture<Void> setAsync(V value, Duration duration) {
        if (value == null) {
            return this.commandExecutor.writeAsync(this.getRawName(), RedisCommands.DEL_VOID, this.getRawName());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.PSETEX, this.getRawName(), duration.toMillis(), this.encode(value));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V value) {
        if (value == null) {
            return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.NOT_EXISTS, this.getRawName());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SETNX, this.getRawName(), this.encode(value));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null");
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SET_BOOLEAN, this.getRawName(), this.encode(value), "PX", timeUnit.toMillis(timeToLive), "NX");
    }

    @Override
    public boolean trySet(V value, long timeToLive, TimeUnit timeUnit) {
        return this.get(this.trySetAsync(value, timeToLive, timeUnit));
    }

    @Override
    public boolean trySet(V value) {
        return this.get(this.trySetAsync(value));
    }

    @Override
    public boolean setIfAbsent(V value) {
        return this.get(this.setIfAbsentAsync(value));
    }

    @Override
    public boolean setIfAbsent(V value, Duration duration) {
        return this.get(this.setIfAbsentAsync(value, duration));
    }

    @Override
    public RFuture<Boolean> setIfAbsentAsync(V value) {
        if (value == null) {
            return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.NOT_EXISTS, this.getRawName());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SETNX, this.getRawName(), this.encode(value));
    }

    @Override
    public RFuture<Boolean> setIfAbsentAsync(V value, Duration duration) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null");
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SET_BOOLEAN, this.getRawName(), this.encode(value), "PX", duration.toMillis(), "NX");
    }

    @Override
    public boolean setIfExists(V value) {
        return this.get(this.setIfExistsAsync(value));
    }

    @Override
    public RFuture<Boolean> setIfExistsAsync(V value) {
        if (value == null) {
            return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local currValue = redis.call('get', KEYS[1]); if currValue ~= false then redis.call('del', KEYS[1]); return 1;end;return 0; ", Collections.singletonList(this.getRawName()), new Object[0]);
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SET_BOOLEAN, this.getRawName(), this.encode(value), "XX");
    }

    @Override
    public void setAndKeepTTL(V value) {
        this.get(this.setAndKeepTTLAsync(value));
    }

    @Override
    public RFuture<Void> setAndKeepTTLAsync(V value) {
        if (value == null) {
            return this.commandExecutor.writeAsync(this.getRawName(), RedisCommands.DEL_VOID, this.getRawName());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SET, this.getRawName(), this.encode(value), "KEEPTTL");
    }

    @Override
    public boolean setIfExists(V value, long timeToLive, TimeUnit timeUnit) {
        return this.get(this.setIfExistsAsync(value, timeToLive, timeUnit));
    }

    @Override
    public RFuture<Boolean> setIfExistsAsync(V value, long timeToLive, TimeUnit timeUnit) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null");
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SET_BOOLEAN, this.getRawName(), this.encode(value), "PX", timeUnit.toMillis(timeToLive), "XX");
    }

    @Override
    public boolean setIfExists(V value, Duration duration) {
        return this.get(this.setIfExistsAsync(value, duration));
    }

    @Override
    public RFuture<Boolean> setIfExistsAsync(V value, Duration duration) {
        if (value == null) {
            throw new IllegalArgumentException("Value can't be null");
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.SET_BOOLEAN, this.getRawName(), this.encode(value), "PX", duration.toMillis(), "XX");
    }

    @Override
    public V getAndSet(V value, Duration duration) {
        return this.get(this.getAndSetAsync(value, duration));
    }

    @Override
    public RFuture<V> getAndSetAsync(V value, Duration duration) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('get', KEYS[1]); redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); return currValue; ", Collections.singletonList(this.getRawName()), this.encode(value), duration.toMillis());
    }

    @Override
    public RFuture<V> getAndSetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_OBJECT, "local currValue = redis.call('get', KEYS[1]); redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); return currValue; ", Collections.singletonList(this.getRawName()), this.encode(value), timeUnit.toMillis(timeToLive));
    }

    @Override
    public V getAndSet(V value, long timeToLive, TimeUnit timeUnit) {
        return this.get(this.getAndSetAsync(value, timeToLive, timeUnit));
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof SetObjectListener) {
            return this.addListener("__keyevent@*:set", (SetObjectListener)listener, SetObjectListener::onSet);
        }
        if (listener instanceof TrackingListener) {
            return this.addTrackingListener((TrackingListener)listener);
        }
        return super.addListener(listener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof SetObjectListener) {
            return this.addListenerAsync("__keyevent@*:set", (SetObjectListener)listener, SetObjectListener::onSet);
        }
        if (listener instanceof TrackingListener) {
            return this.addTrackingListenerAsync((TrackingListener)listener);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        this.removeTrackingListener(listenerId);
        this.removeListener(listenerId, "__keyevent@*:set");
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        RFuture<Void> f1 = this.removeTrackingListenerAsync(listenerId);
        RFuture<Void> f2 = this.removeListenerAsync(listenerId, "__keyevent@*:set");
        return new CompletableFutureWrapper<Void>(CompletableFuture.allOf(f1.toCompletableFuture(), f2.toCompletableFuture()));
    }

    @Override
    public V findCommon(String name) {
        return this.get(this.findCommonAsync(name));
    }

    @Override
    public RFuture<V> findCommonAsync(String name) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.LCS, this.getRawName(), this.mapName(name), "MINMATCHLEN", 30);
    }

    @Override
    public long findCommonLength(String name) {
        return this.get(this.findCommonLengthAsync(name));
    }

    @Override
    public RFuture<Long> findCommonLengthAsync(String name) {
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.LCS, this.getRawName(), this.mapName(name), "LEN");
    }

    @Override
    public String getDigest() {
        return this.get(this.getDigestAsync());
    }

    @Override
    public RFuture<String> getDigestAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.DIGEST, this.getRawName());
    }

    @Override
    public boolean compareAndSet(CompareAndSetArgs<V> args) {
        return this.get(this.compareAndSetAsync(args));
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(CompareAndSetArgs<V> args) {
        CompareAndSetParams params = (CompareAndSetParams)args;
        Objects.requireNonNull(params, "Args can't be null");
        Objects.requireNonNull(params.getNewValue(), "New value must be set");
        ConditionType conditionType = params.getConditionType();
        switch (conditionType) {
            case EXPECTED: {
                return this.compareAndSetAsync(params, params.getExpectedValue(), "E");
            }
            case UNEXPECTED: {
                return this.compareAndSetAsync(params, params.getUnexpectedValue(), "U");
            }
            case EXPECTED_DIGEST: {
                return this.compareAndSetDigestAsync(params, params.getExpectedDigest(), "IFDEQ");
            }
            case UNEXPECTED_DIGEST: {
                return this.compareAndSetDigestAsync(params, params.getUnexpectedDigest(), "IFDNE");
            }
        }
        throw new IllegalStateException("Unknown condition type: " + (Object)((Object)conditionType));
    }

    private RFuture<Boolean> compareAndSetAsync(CompareAndSetParams<V> args, V value, String cond) {
        ArrayList<Object> params = new ArrayList<Object>();
        if (value == null) {
            cond = cond + "N";
        }
        params.add(cond);
        params.add(this.encode(value));
        params.add(this.encode(args.getNewValue()));
        if (args.getTimeToLive() != null) {
            params.add("pexpire");
            params.add(args.getTimeToLive().toMillis());
        } else if (args.getExpireAt() != null) {
            params.add("pexpireat");
            params.add(args.getExpireAt().toEpochMilli());
        } else {
            params.add("");
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local cv = redis.call('get', KEYS[1]) if (ARGV[1] == 'E' and cv == ARGV[2]) or (ARGV[1] == 'EN' and cv == false) or (ARGV[1] == 'UN' and cv ~= false) or (ARGV[1] == 'U' and cv ~= ARGV[2]) then redis.call('set', KEYS[1], ARGV[3]) if #ARGV[4] > 0 then redis.call(ARGV[4], KEYS[1], ARGV[5]) end return 1 end return 0 ", Collections.singletonList(this.getName()), params.toArray());
    }

    private RFuture<Boolean> compareAndSetDigestAsync(CompareAndSetParams<V> args, String value, String command) {
        V newValue = args.getNewValue();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getName());
        params.add(this.encode(newValue));
        params.add(command);
        params.add(value);
        if (args.getTimeToLive() != null) {
            params.add("PX");
            params.add(args.getTimeToLive().toMillis());
        } else if (args.getExpireAt() != null) {
            params.add("PXAT");
            params.add(args.getExpireAt().toEpochMilli());
        }
        return this.commandExecutor.writeAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.SET_BOOLEAN, params.toArray());
    }

    @Override
    public boolean compareAndDelete(CompareAndDeleteArgs<V> args) {
        return this.get(this.compareAndDeleteAsync(args));
    }

    @Override
    public RFuture<Boolean> compareAndDeleteAsync(CompareAndDeleteArgs<V> args) {
        CompareAndDeleteParams params = (CompareAndDeleteParams)args;
        Objects.requireNonNull(params, "Args can't be null");
        ConditionType conditionType = params.getConditionType();
        switch (conditionType) {
            case EXPECTED: {
                return this.compareAndDeleteExpectedAsync(params.getValue());
            }
            case UNEXPECTED: {
                return this.compareAndDeleteUnexpectedAsync(params.getValue());
            }
            case EXPECTED_DIGEST: {
                return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.DELEX, this.getName(), "IFDEQ", params.getDigest());
            }
            case UNEXPECTED_DIGEST: {
                return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.DELEX, this.getName(), "IFDNE", params.getDigest());
            }
        }
        throw new IllegalArgumentException("Unknown mode: " + (Object)((Object)params.getConditionType()));
    }

    private RFuture<Boolean> compareAndDeleteExpectedAsync(V expected) {
        String script = "local currValue = redis.call('get', KEYS[1]) if currValue == ARGV[1] then redis.call('del', KEYS[1]) return 1 end return 0 ";
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, script, Collections.singletonList(this.getName()), this.encode(expected));
    }

    private RFuture<Boolean> compareAndDeleteUnexpectedAsync(V unexpected) {
        String script = "local currValue = redis.call('get', KEYS[1]) if currValue ~= false and currValue ~= ARGV[1] then redis.call('del', KEYS[1]) return 1 end return 0 ";
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, script, Collections.singletonList(this.getName()), this.encode(unexpected));
    }
}

