/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.redisson.RedissonExpirable;
import org.redisson.api.RBloomFilterNative;
import org.redisson.api.RFuture;
import org.redisson.api.bloomfilter.BloomFilterInfo;
import org.redisson.api.bloomfilter.BloomFilterInfoOption;
import org.redisson.api.bloomfilter.BloomFilterInitArgs;
import org.redisson.api.bloomfilter.BloomFilterInitParams;
import org.redisson.api.bloomfilter.BloomFilterInsertArgs;
import org.redisson.api.bloomfilter.BloomFilterInsertParams;
import org.redisson.api.bloomfilter.BloomFilterScanDumpInfo;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ContainsSetDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonBloomFilterNative<T>
extends RedissonExpirable
implements RBloomFilterNative<T> {
    final CommandAsyncExecutor commandExecutor;

    protected RedissonBloomFilterNative(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
    }

    protected RedissonBloomFilterNative(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.commandExecutor = commandExecutor;
    }

    @Override
    public Boolean add(T element) {
        return this.commandExecutor.get(this.addAsync(element));
    }

    @Override
    public RFuture<Boolean> addAsync(T element) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.BF_ADD, this.getRawName(), element);
    }

    @Override
    public Set<T> add(Collection<T> elements) {
        return this.commandExecutor.get(this.addAsync(elements));
    }

    @Override
    public RFuture<Set<T>> addAsync(Collection<T> elements) {
        if (elements == null || elements.isEmpty()) {
            return new CompletableFutureWrapper<Set<T>>(Collections.emptyList());
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.getRawName());
        params.addAll(elements);
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, new RedisCommand<T>("BF.MADD", new ContainsSetDecoder<T>(elements)), params.toArray());
    }

    @Override
    public Set<T> insert(BloomFilterInsertArgs<T> args) {
        return this.commandExecutor.get(this.insertAsync(args));
    }

    @Override
    public RFuture<Set<T>> insertAsync(BloomFilterInsertArgs<T> args) {
        BloomFilterInsertParams bloomFilterInsertParams = (BloomFilterInsertParams)args;
        Collection elements = bloomFilterInsertParams.getElements();
        if (elements == null || elements.isEmpty()) {
            return new CompletableFutureWrapper<Set<T>>(Collections.emptyList());
        }
        Long capacity = bloomFilterInsertParams.getCapacity();
        Double errorRate = bloomFilterInsertParams.getErrorRate();
        Long expansionRate = bloomFilterInsertParams.getExpansionRate();
        Boolean nonScaling = bloomFilterInsertParams.isNonScaling();
        Boolean noCreate = bloomFilterInsertParams.isNoCreate();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        if (noCreate != null && noCreate.booleanValue() && (capacity != null || errorRate != null)) {
            throw new IllegalArgumentException("BloomFilter Native noCreate and capacity/errorRate are mutually exclusive");
        }
        if (capacity != null) {
            if (capacity <= 0L) {
                throw new IllegalArgumentException("BloomFilter Native capacity must be greater than 0");
            }
            params.add("CAPACITY");
            params.add(capacity);
        }
        if (errorRate != null) {
            if (errorRate <= 0.0 || errorRate >= 1.0) {
                throw new IllegalArgumentException("BloomFilter Native errorRate must be greater than 0 and less than 1");
            }
            params.add("ERROR");
            params.add(errorRate);
        }
        if (expansionRate != null) {
            if (expansionRate <= 0L) {
                throw new IllegalArgumentException("BloomFilter Native expansionRate must be greater than 0");
            }
            params.add("EXPANSION");
            params.add(expansionRate);
        }
        if (noCreate != null && noCreate.booleanValue()) {
            params.add("NOCREATE");
        }
        if (nonScaling != null && nonScaling.booleanValue()) {
            params.add("NONSCALING");
        }
        params.add("ITEMS");
        params.addAll(elements);
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, new RedisCommand("BF.INSERT", new ContainsSetDecoder(elements)), params.toArray());
    }

    @Override
    public void init(double errorRate, long capacity) {
        this.commandExecutor.get(this.initAsync(errorRate, capacity));
    }

    @Override
    public RFuture<Void> initAsync(double errorRate, long capacity) {
        if (errorRate <= 0.0 || errorRate >= 1.0) {
            throw new IllegalArgumentException("BloomFilter Native errorRate must be greater than 0 and less than 1");
        }
        if (capacity <= 0L) {
            throw new IllegalArgumentException("BloomFilter Native capacity must be greater than 0");
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.BF_RESERVE, this.getRawName(), errorRate, capacity);
    }

    @Override
    public void init(BloomFilterInitArgs args) {
        this.commandExecutor.get(this.initAsync(args));
    }

    @Override
    public RFuture<Void> initAsync(BloomFilterInitArgs args) {
        BloomFilterInitParams bloomFilterInitParams = (BloomFilterInitParams)args;
        double errorRate = bloomFilterInitParams.getErrorRate();
        long capacity = bloomFilterInitParams.getCapacity();
        Long expansionRate = bloomFilterInitParams.getExpansionRate();
        Boolean nonScaling = bloomFilterInitParams.isNonScaling();
        if (errorRate <= 0.0 || errorRate >= 1.0) {
            throw new IllegalArgumentException("BloomFilter Native errorRate must be greater than 0 and less than 1");
        }
        if (capacity <= 0L) {
            throw new IllegalArgumentException("BloomFilter Native capacity must be greater than 0");
        }
        if (expansionRate != null && nonScaling != null) {
            throw new IllegalArgumentException("BloomFilter Native expansionRate and nonScaling are mutually exclusive");
        }
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        params.add(errorRate);
        params.add(capacity);
        if (expansionRate != null) {
            if (expansionRate <= 1L) {
                throw new IllegalArgumentException("BloomFilter Native expansionRate must be greater than 1");
            }
            params.add("EXPANSION");
            params.add(expansionRate);
        }
        if (nonScaling != null && nonScaling.booleanValue()) {
            params.add("NONSCALING");
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.BF_RESERVE, params.toArray());
    }

    @Override
    public Boolean exists(T element) {
        return this.commandExecutor.get(this.existsAsync(element));
    }

    @Override
    public RFuture<Boolean> existsAsync(T element) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.BF_EXISTS, this.getRawName(), element);
    }

    @Override
    public Set<T> exists(Collection<T> elements) {
        return this.commandExecutor.get(this.existsAsync(elements));
    }

    @Override
    public RFuture<Set<T>> existsAsync(Collection<T> elements) {
        if (elements == null || elements.isEmpty()) {
            return new CompletableFutureWrapper<Set<T>>(Collections.emptyList());
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.getRawName());
        params.addAll(elements);
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, new RedisCommand<T>("BF.MEXISTS", new ContainsSetDecoder<T>(elements)), params.toArray());
    }

    @Override
    public Long count() {
        return this.commandExecutor.get(this.countAsync());
    }

    @Override
    public RFuture<Long> countAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.BF_CARD, this.getRawName());
    }

    @Override
    public BloomFilterInfo getInfo() {
        return this.commandExecutor.get(this.getInfoAsync());
    }

    @Override
    public RFuture<BloomFilterInfo> getInfoAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.BF_INFO, this.getRawName());
    }

    @Override
    public long getInfo(BloomFilterInfoOption option) {
        return this.commandExecutor.get(this.getInfoAsync(option));
    }

    @Override
    public RFuture<Long> getInfoAsync(BloomFilterInfoOption option) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.BF_INFO_SINGLE, this.getRawName(), option.getOptionString());
    }

    @Override
    public BloomFilterScanDumpInfo scanDump(long iterator) {
        return this.commandExecutor.get(this.scanDumpAsync(iterator));
    }

    @Override
    public RFuture<BloomFilterScanDumpInfo> scanDumpAsync(long iterator) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.BF_SCANDUMP, this.getRawName(), iterator);
    }

    @Override
    public void loadChunk(long iterator, byte[] data) {
        this.commandExecutor.get(this.loadChunkAsync(iterator, data));
    }

    @Override
    public RFuture<Void> loadChunkAsync(long iterator, byte[] data) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.BF_LOADCHUNK, this.getRawName(), iterator, data);
    }
}

