/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.map;

import java.util.concurrent.TimeUnit;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.transaction.operation.map.MapOperation;

public class MapCachePutIfAbsentOperation
extends MapOperation {
    private long ttl;
    private TimeUnit unit;
    private long maxIdleTime;
    private TimeUnit maxIdleUnit;

    public MapCachePutIfAbsentOperation() {
    }

    public MapCachePutIfAbsentOperation(RMap<?, ?> map, Object key, Object value, long ttl, TimeUnit unit, long maxIdleTime, TimeUnit maxIdleUnit, String transactionId) {
        this(map, key, value, transactionId);
        this.ttl = ttl;
        this.unit = unit;
        this.maxIdleTime = maxIdleTime;
        this.maxIdleUnit = maxIdleUnit;
    }

    public MapCachePutIfAbsentOperation(RMap<?, ?> map, Object key, Object value, String transactionId) {
        super(map, key, value, transactionId);
    }

    @Override
    public void commit(RMap<Object, Object> map) {
        ((RMapCache)map).putIfAbsentAsync(this.key, this.value, this.ttl, this.unit, this.maxIdleTime, this.maxIdleUnit);
    }

    public long getTTL() {
        return this.ttl;
    }

    public TimeUnit getTTLUnit() {
        return this.unit;
    }

    public long getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public TimeUnit getMaxIdleUnit() {
        return this.maxIdleUnit;
    }
}

