/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import org.reactivestreams.Publisher;
import org.redisson.RedissonSet;
import org.redisson.api.RFuture;
import org.redisson.api.RSet;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.reactive.PublisherAdder;
import org.redisson.reactive.SetReactiveIterator;
import reactor.core.publisher.Flux;

public class RedissonSetReactive<V> {
    private final RSet<V> instance;

    public RedissonSetReactive(RSet<V> instance) {
        this.instance = instance;
    }

    public Publisher<Boolean> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<Object>(){

            @Override
            public RFuture<Boolean> add(Object e) {
                return RedissonSetReactive.this.instance.addAsync(e);
            }
        }.addAll(c);
    }

    public Publisher<V> iterator(int count) {
        return this.iterator(null, count);
    }

    public Publisher<V> iterator(String pattern) {
        return this.iterator(pattern, 10);
    }

    public Publisher<V> iterator(final String pattern, final int count) {
        return Flux.create(new SetReactiveIterator<V>(){

            @Override
            protected RFuture<ListScanResult<Object>> scanIterator(RedisClient client, long nextIterPos) {
                return ((RedissonSet)RedissonSetReactive.this.instance).scanIteratorAsync(RedissonSetReactive.this.instance.getName(), client, nextIterPos, pattern, count);
            }
        });
    }

    public Publisher<V> iterator() {
        return this.iterator(null, 10);
    }
}

