/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.core;

import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Field;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonDeque;
import org.redisson.RedissonList;
import org.redisson.RedissonMap;
import org.redisson.RedissonQueue;
import org.redisson.RedissonReference;
import org.redisson.RedissonSet;
import org.redisson.RedissonSortedSet;
import org.redisson.api.RMap;
import org.redisson.api.RObject;
import org.redisson.api.RedissonClient;
import org.redisson.api.annotation.REntity;
import org.redisson.api.annotation.RObjectField;
import org.redisson.client.codec.Codec;
import org.redisson.codec.ReferenceCodecProvider;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.liveobject.resolver.NamingScheme;
import org.redisson.misc.RedissonObjectFactory;

public class RedissonObjectBuilder {
    private static final Map<Class<?>, Class<? extends RObject>> supportedClassMapping = new LinkedHashMap();
    ConcurrentMap<String, NamingScheme> namingSchemeCache = PlatformDependent.newConcurrentHashMap();
    private final RedissonClient redisson;
    private final ReferenceCodecProvider codecProvider;

    public RedissonObjectBuilder(RedissonClient redisson) {
        this.redisson = redisson;
        this.codecProvider = redisson.getConfig().getReferenceCodecProvider();
    }

    public void store(RObject ar, String fieldName, RMap<String, Object> liveMap) {
        Codec codec = ar.getCodec();
        this.codecProvider.registerCodec(codec.getClass(), codec);
        liveMap.fastPut(fieldName, new RedissonReference(ar.getClass(), ar.getName(), codec));
    }

    public RObject createObject(Object id, Class<?> clazz, Class<?> fieldType, String fieldName) {
        Class<? extends RObject> mappedClass = this.getMappedClass(fieldType);
        try {
            if (mappedClass != null) {
                Codec fieldCodec = this.getFieldCodec(clazz, mappedClass, fieldName);
                NamingScheme fieldNamingScheme = this.getFieldNamingScheme(clazz, fieldName, fieldCodec);
                RObject obj = RedissonObjectFactory.createRObject(this.redisson, mappedClass, fieldNamingScheme.getFieldReferenceName(clazz, id, mappedClass, fieldName, null), fieldCodec);
                return obj;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return null;
    }

    private Codec getFieldCodec(Class<?> rEntity, Class<? extends RObject> rObjectClass, String fieldName) throws Exception {
        Field field = ClassUtils.getDeclaredField(rEntity, fieldName);
        if (field.isAnnotationPresent(RObjectField.class)) {
            RObjectField anno = field.getAnnotation(RObjectField.class);
            return this.codecProvider.getCodec(anno, rEntity, rObjectClass, fieldName);
        }
        REntity anno = ClassUtils.getAnnotation(rEntity, REntity.class);
        return this.codecProvider.getCodec(anno, rEntity);
    }

    private NamingScheme getFieldNamingScheme(Class<?> rEntity, String fieldName, Codec c) throws Exception {
        if (!this.namingSchemeCache.containsKey(fieldName)) {
            REntity anno = ClassUtils.getAnnotation(rEntity, REntity.class);
            this.namingSchemeCache.putIfAbsent(fieldName, anno.namingScheme().getDeclaredConstructor(Codec.class).newInstance(c));
        }
        return (NamingScheme)this.namingSchemeCache.get(fieldName);
    }

    private Class<? extends RObject> getMappedClass(Class<?> cls) {
        for (Map.Entry<Class<?>, Class<RObject>> entrySet : supportedClassMapping.entrySet()) {
            if (!entrySet.getKey().isAssignableFrom(cls)) continue;
            return entrySet.getValue();
        }
        return null;
    }

    static {
        supportedClassMapping.put(SortedSet.class, RedissonSortedSet.class);
        supportedClassMapping.put(Set.class, RedissonSet.class);
        supportedClassMapping.put(ConcurrentMap.class, RedissonMap.class);
        supportedClassMapping.put(Map.class, RedissonMap.class);
        supportedClassMapping.put(BlockingDeque.class, RedissonBlockingDeque.class);
        supportedClassMapping.put(Deque.class, RedissonDeque.class);
        supportedClassMapping.put(BlockingQueue.class, RedissonBlockingQueue.class);
        supportedClassMapping.put(Queue.class, RedissonQueue.class);
        supportedClassMapping.put(List.class, RedissonList.class);
    }
}

