/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class GeoDistanceMapDecoder
implements MultiDecoder<Map<Object, Object>> {
    private final Codec codec;

    public GeoDistanceMapDecoder(Codec codec) {
        this.codec = codec;
    }

    @Override
    public Decoder<Object> getDecoder(int paramNum, State state) {
        if (paramNum % 2 == 0) {
            return this.codec.getValueDecoder();
        }
        return DoubleCodec.INSTANCE.getValueDecoder();
    }

    @Override
    public Map<Object, Object> decode(List<Object> parts, State state) {
        HashMap<Object, Object> result = new HashMap<Object, Object>(parts.size() / 2);
        for (int i = 0; i < parts.size(); ++i) {
            if (i % 2 == 0) continue;
            result.put(parts.get(i - 1), parts.get(i));
        }
        return result;
    }
}

