/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import reactor.core.CoreSubscriber;
import reactor.core.publisher.FluxRetry;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;

final class MonoRetry<T>
extends MonoOperator<T, T> {
    final long times;

    MonoRetry(Mono<? extends T> source, long times) {
        super(source);
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required");
        }
        this.times = times;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        FluxRetry.RetrySubscriber<T> parent = new FluxRetry.RetrySubscriber<T>(this.source, actual, this.times);
        actual.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.resubscribe();
        }
    }
}

