/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.InnerProducer;
import reactor.util.annotation.Nullable;

final class FluxJust<T>
extends Flux<T>
implements Fuseable.ScalarCallable<T>,
Fuseable {
    final T value;

    FluxJust(T value) {
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public T call() throws Exception {
        return this.value;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        actual.onSubscribe(new WeakScalarSubscription<T>(this.value, actual));
    }

    static final class WeakScalarSubscription<T>
    implements Fuseable.QueueSubscription<T>,
    InnerProducer<T> {
        boolean terminado;
        final T value;
        final CoreSubscriber<? super T> actual;

        WeakScalarSubscription(@Nullable T value, CoreSubscriber<? super T> actual) {
            this.value = value;
            this.actual = actual;
        }

        @Override
        public void request(long elements) {
            if (this.terminado) {
                return;
            }
            this.terminado = true;
            if (this.value != null) {
                this.actual.onNext(this.value);
            }
            this.actual.onComplete();
        }

        @Override
        public void cancel() {
            this.terminado = true;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 1) != 0) {
                return 1;
            }
            return 0;
        }

        @Override
        @Nullable
        public T poll() {
            if (!this.terminado) {
                this.terminado = true;
                return this.value;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.terminado;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }

        @Override
        public void clear() {
            this.terminado = true;
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.TERMINATED || key == Scannable.Attr.CANCELLED) {
                return this.terminado;
            }
            return InnerProducer.super.scanUnsafe(key);
        }
    }
}

