/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.api.RMap;
import org.redisson.transaction.BaseTransactionalMap;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.map.MapCacheFastPutIfAbsentOperation;
import org.redisson.transaction.operation.map.MapCacheFastPutOperation;
import org.redisson.transaction.operation.map.MapCachePutIfAbsentOperation;
import org.redisson.transaction.operation.map.MapCachePutOperation;

public class BaseTransactionalMapCache<K, V>
extends BaseTransactionalMap<K, V> {
    public BaseTransactionalMapCache(long timeout, List<TransactionalOperation> operations, RMap<K, V> map) {
        super(timeout, operations, map);
    }

    public RFuture<V> putIfAbsentAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.putIfAbsentOperationAsync(key, value, new MapCachePutIfAbsentOperation(this.map, key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    public RFuture<Boolean> fastPutOperationAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.fastPutOperationAsync(key, value, new MapCacheFastPutOperation(this.map, key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }

    public RFuture<V> putOperationAsync(K key, V value, long ttlTimeout, long maxIdleTimeout, long maxIdleDelta) {
        return this.putOperationAsync(key, value, new MapCachePutOperation(this.map, key, value, ttlTimeout, TimeUnit.MILLISECONDS, maxIdleTimeout, TimeUnit.MILLISECONDS));
    }

    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        return this.fastPutIfAbsentOperationAsync(key, value, new MapCacheFastPutIfAbsentOperation(this.map, key, value, ttl, ttlUnit, maxIdleTime, maxIdleUnit));
    }
}

