/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.redisson.cache.LocalCachedMapClear;
import org.redisson.cache.LocalCachedMapDisable;
import org.redisson.cache.LocalCachedMapDisableAck;
import org.redisson.cache.LocalCachedMapEnable;
import org.redisson.cache.LocalCachedMapInvalidate;
import org.redisson.cache.LocalCachedMapUpdate;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class LocalCachedMessageCodec
extends BaseCodec {
    public static final LocalCachedMessageCodec INSTANCE = new LocalCachedMessageCodec();
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            byte type = buf.readByte();
            if (type == 0) {
                return new LocalCachedMapClear();
            }
            if (type == 1) {
                byte[] excludedId = new byte[16];
                buf.readBytes(excludedId);
                int hashesCount = buf.readInt();
                byte[][] hashes = new byte[hashesCount][];
                for (int i = 0; i < hashesCount; ++i) {
                    byte[] keyHash = new byte[16];
                    buf.readBytes(keyHash);
                    hashes[i] = keyHash;
                }
                return new LocalCachedMapInvalidate(excludedId, hashes);
            }
            if (type == 2) {
                ArrayList<LocalCachedMapUpdate.Entry> entries = new ArrayList<LocalCachedMapUpdate.Entry>();
                do {
                    int keyLen = buf.readInt();
                    byte[] key = new byte[keyLen];
                    buf.readBytes(key);
                    int valueLen = buf.readInt();
                    byte[] value = new byte[valueLen];
                    buf.readBytes(value);
                    entries.add(new LocalCachedMapUpdate.Entry(key, value));
                } while (buf.isReadable());
                return new LocalCachedMapUpdate(entries);
            }
            if (type == 3) {
                byte len = buf.readByte();
                CharSequence requestId = buf.readCharSequence(len, CharsetUtil.UTF_8);
                long timeout = buf.readLong();
                int hashesCount = buf.readInt();
                byte[][] hashes = new byte[hashesCount][];
                for (int i = 0; i < hashesCount; ++i) {
                    byte[] keyHash = new byte[16];
                    buf.readBytes(keyHash);
                    hashes[i] = keyHash;
                }
                return new LocalCachedMapDisable(requestId.toString(), hashes, timeout);
            }
            if (type == 4) {
                return new LocalCachedMapDisableAck();
            }
            if (type == 5) {
                byte len = buf.readByte();
                CharSequence requestId = buf.readCharSequence(len, CharsetUtil.UTF_8);
                int hashesCount = buf.readInt();
                byte[][] hashes = new byte[hashesCount][];
                for (int i = 0; i < hashesCount; ++i) {
                    byte[] keyHash = new byte[16];
                    buf.readBytes(keyHash);
                    hashes[i] = keyHash;
                }
                return new LocalCachedMapEnable(requestId.toString(), hashes);
            }
            throw new IllegalArgumentException("Can't parse packet");
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            if (in instanceof LocalCachedMapClear) {
                ByteBuf result = ByteBufAllocator.DEFAULT.buffer(1);
                result.writeByte(0);
                return result;
            }
            if (in instanceof LocalCachedMapInvalidate) {
                LocalCachedMapInvalidate li = (LocalCachedMapInvalidate)in;
                ByteBuf result = ByteBufAllocator.DEFAULT.buffer();
                result.writeByte(1);
                result.writeBytes(li.getExcludedId());
                result.writeInt(li.getKeyHashes().length);
                for (int i = 0; i < li.getKeyHashes().length; ++i) {
                    result.writeBytes(li.getKeyHashes()[i]);
                }
                return result;
            }
            if (in instanceof LocalCachedMapUpdate) {
                LocalCachedMapUpdate li = (LocalCachedMapUpdate)in;
                ByteBuf result = ByteBufAllocator.DEFAULT.buffer();
                result.writeByte(2);
                for (LocalCachedMapUpdate.Entry e : li.getEntries()) {
                    result.writeInt(e.getKey().length);
                    result.writeBytes(e.getKey());
                    result.writeInt(e.getValue().length);
                    result.writeBytes(e.getValue());
                }
                return result;
            }
            if (in instanceof LocalCachedMapDisable) {
                LocalCachedMapDisable li = (LocalCachedMapDisable)in;
                ByteBuf result = ByteBufAllocator.DEFAULT.buffer();
                result.writeByte(3);
                result.writeByte(li.getRequestId().length());
                result.writeCharSequence(li.getRequestId(), CharsetUtil.UTF_8);
                result.writeLong(li.getTimeout());
                result.writeInt(li.getKeyHashes().length);
                for (int i = 0; i < li.getKeyHashes().length; ++i) {
                    result.writeBytes(li.getKeyHashes()[i]);
                }
                return result;
            }
            if (in instanceof LocalCachedMapDisableAck) {
                ByteBuf result = ByteBufAllocator.DEFAULT.buffer(1);
                result.writeByte(4);
                return result;
            }
            if (in instanceof LocalCachedMapEnable) {
                LocalCachedMapEnable li = (LocalCachedMapEnable)in;
                ByteBuf result = ByteBufAllocator.DEFAULT.buffer();
                result.writeByte(5);
                result.writeByte(li.getRequestId().length());
                result.writeCharSequence(li.getRequestId(), CharsetUtil.UTF_8);
                result.writeInt(li.getKeyHashes().length);
                for (int i = 0; i < li.getKeyHashes().length; ++i) {
                    result.writeBytes(li.getKeyHashes()[i]);
                }
                return result;
            }
            throw new IllegalArgumentException("Can't encode packet " + in);
        }
    };

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }
}

